/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external.util;

import groove.algebra.StringAlgebra;
import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.aspect.AspectLabel;
import groove.grammar.aspect.AspectNode;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.grammar.model.FormatException;
import groove.grammar.model.HostModel;
import groove.graph.EdgeRole;
import groove.graph.GGraph;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class GraphToKth {
    private static AspectGraph graph;
    private static StringBuilder result;
    private static final String TYPE = "type:";
    private static final String FLOW_NODE_TYPE = "type:FlowNode";
    private static final String FLOW_EDGE_TYPE = "type:FlowEdge";
    private static final String FLOW_PROP_TYPE = "type:FlowProp";
    private static final String METHOD_PROP_TYPE = "type:MethodProp";
    private static final String EXCEPTION_PROP_TYPE = "type:ExceptionProp";
    private static final String EMPTY_EDGE_LABEL = "empty";
    private static final String TO_EDGE_LABEL = "to";
    private static final String OUT_EDGE_LABEL = "out";
    private static final String PROP_EDGE_LABEL = "prop";
    private static final String LABEL_ATTR = "label";
    private static final String BEGIN_NODE = "node";
    private static final String END_NODE = "\n";
    private static final String SPACE = " ";
    private static final String BEGIN_EDGE = "edge";
    private static final String END_EDGE = "\n";
    private static final String OUT_EMPTY_EDGE_LABEL = "eps";
    private static final String BEGIN_METHOD = "meth(";
    private static final String END_METHOD = ")";
    private static final String BEGIN_EXCEPTION = "exc(";
    private static final String END_EXCEPTION = ")";

    public static void export(AspectGraph graph, PrintWriter writer) {
        writer.print(GraphToKth.convertGraph(graph));
    }

    public static String convertGraph(AspectGraph graph) {
        GraphToKth.graph = graph;
        result = new StringBuilder();
        GraphToKth.beginFile();
        GraphToKth.convertNodes();
        GraphToKth.convertEdges();
        GraphToKth.endFile();
        return result.toString();
    }

    private static void beginFile() {
    }

    private static void convertNodes() {
        for (AspectNode node : graph.nodeSet()) {
            if (!GraphToKth.isFlowNode(node)) continue;
            GraphToKth.appendNode(node);
        }
    }

    private static void convertEdges() {
        for (AspectNode node : graph.nodeSet()) {
            if (!GraphToKth.isFlowEdge(node)) continue;
            GraphToKth.appendFlowEdge(node);
        }
        for (AspectEdge edge : graph.edgeSet()) {
            if (!GraphToKth.isEmptyEdge(edge)) continue;
            GraphToKth.appendEmptyEdge(edge);
        }
    }

    private static void endFile() {
    }

    private static boolean isFlowNode(AspectNode node) {
        return FLOW_NODE_TYPE.equals(GraphToKth.getType(node));
    }

    private static boolean isFlowEdge(AspectNode node) {
        return FLOW_EDGE_TYPE.equals(GraphToKth.getType(node));
    }

    private static boolean isFlowProp(AspectNode node) {
        return FLOW_PROP_TYPE.equals(GraphToKth.getType(node)) || GraphToKth.isMethodProp(node) || GraphToKth.isExceptionProp(node);
    }

    private static boolean isMethodProp(AspectNode node) {
        return METHOD_PROP_TYPE.equals(GraphToKth.getType(node));
    }

    private static boolean isExceptionProp(AspectNode node) {
        return EXCEPTION_PROP_TYPE.equals(GraphToKth.getType(node));
    }

    private static boolean isEmptyEdge(AspectEdge edge) {
        return EMPTY_EDGE_LABEL.equals(((AspectLabel)edge.label()).text());
    }

    private static void appendNode(AspectNode node) {
        assert (GraphToKth.isFlowNode(node)) : "Node " + node + " has an illegal type.";
        result.append(BEGIN_NODE);
        result.append(SPACE);
        result.append(node.getNumber());
        for (String flag : GraphToKth.getFlags(node)) {
            result.append(SPACE);
            result.append(flag);
        }
        for (String strAttr : GraphToKth.getStringAttributes(node).values()) {
            result.append(SPACE);
            result.append(strAttr);
        }
        for (String prop : GraphToKth.getPropositions(node)) {
            result.append(SPACE);
            result.append(prop);
        }
        result.append("\n");
    }

    private static void appendFlowEdge(AspectNode node) {
        assert (GraphToKth.isFlowEdge(node)) : "Node " + node + " has an illegal type.";
        result.append(BEGIN_EDGE);
        result.append(SPACE);
        result.append(GraphToKth.getFlowEdgeSourceNodeNumber(node));
        result.append(SPACE);
        result.append(GraphToKth.getFlowEdgeTargetNodeNumber(node));
        result.append(SPACE);
        result.append(GraphToKth.getFlowEdgeLabel(node));
        result.append("\n");
    }

    private static void appendEmptyEdge(AspectEdge edge) {
        result.append(BEGIN_EDGE);
        result.append(SPACE);
        result.append(((AspectNode)edge.source()).getNumber());
        result.append(SPACE);
        result.append(((AspectNode)edge.target()).getNumber());
        result.append(SPACE);
        result.append(OUT_EMPTY_EDGE_LABEL);
        result.append("\n");
    }

    private static String getType(AspectNode node) {
        String type = null;
        for (AspectEdge edge : graph.outEdgeSet(node)) {
            if (edge.getDisplayLabel().getRole() != EdgeRole.NODE_TYPE) continue;
            type = ((AspectLabel)edge.label()).text();
            break;
        }
        return type;
    }

    private static Collection<String> getFlags(AspectNode node) {
        assert (GraphToKth.isFlowNode(node)) : "Node " + node + " has an illegal type.";
        ArrayList<String> flags = new ArrayList<String>();
        for (AspectEdge edge : graph.outEdgeSet(node)) {
            if (edge.getRole() != EdgeRole.FLAG) continue;
            flags.add(edge.getInnerText().substring(5));
        }
        return flags;
    }

    private static Map<String, String> getStringAttributes(AspectNode node) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        GGraph model = null;
        try {
            model = new HostModel(null, graph).toHost();
        }
        catch (FormatException e) {
            e.printStackTrace();
        }
        for (HostEdge edge : model.edgeSet()) {
            if (edge.source().getNumber() != node.getNumber()) continue;
            String possibleKey = edge.label().text();
            HostNode possibleTarget = edge.target();
            if (!(possibleTarget instanceof ValueNode) || !(((ValueNode)possibleTarget).getAlgebra() instanceof StringAlgebra)) continue;
            String key = possibleKey;
            ValueNode target = (ValueNode)possibleTarget;
            String value = GraphToKth.wrapValue(target.getValue().toString(), node);
            attrs.put(key, value);
        }
        return attrs;
    }

    private static Collection<String> getPropositions(AspectNode node) {
        assert (GraphToKth.isFlowNode(node)) : "Node " + node + " has an illegal type.";
        ArrayList<String> props = new ArrayList<String>();
        for (AspectEdge edge : graph.outEdgeSet(node)) {
            if (!PROP_EDGE_LABEL.equals(((AspectLabel)edge.label()).text())) continue;
            AspectNode propNode = (AspectNode)edge.target();
            assert (GraphToKth.isFlowProp(propNode)) : "Target node " + propNode + " is not of type FlowProp.";
            props.add(GraphToKth.getStringAttributes(propNode).get(LABEL_ATTR));
        }
        return props;
    }

    private static int getFlowEdgeSourceNodeNumber(AspectNode node) {
        int n = -1;
        for (AspectEdge edge : graph.edgeSet(node)) {
            if (!OUT_EDGE_LABEL.equals(((AspectLabel)edge.label()).text())) continue;
            n = ((AspectNode)edge.source()).getNumber();
        }
        assert (n != -1) : "Could not find the source of node " + node;
        return n;
    }

    private static int getFlowEdgeTargetNodeNumber(AspectNode node) {
        int n = -1;
        for (AspectEdge edge : graph.outEdgeSet(node)) {
            if (!TO_EDGE_LABEL.equals(((AspectLabel)edge.label()).text())) continue;
            n = ((AspectNode)edge.target()).getNumber();
        }
        assert (n != -1) : "Could not find the target of node " + node;
        return n;
    }

    private static String getFlowEdgeLabel(AspectNode node) {
        return GraphToKth.getStringAttributes(node).get(LABEL_ATTR);
    }

    private static String wrapValue(String value, AspectNode node) {
        String result = GraphToKth.isMethodProp(node) ? BEGIN_METHOD + value + ")" : (GraphToKth.isExceptionProp(node) ? BEGIN_EXCEPTION + value + ")" : value);
        return result;
    }
}

