/*
 * Decompiled with CFR 0.152.
 */
package groove.io.store;

import groove.grammar.GrammarProperties;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.type.TypeLabel;
import groove.io.FileType;
import groove.io.Util;
import groove.io.store.DefaultFileSystemStore;
import groove.io.store.EditType;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public abstract class SystemStore
extends UndoableEditSupport {
    private final Map<ResourceKind, Map<String, AspectGraph>> graphMap = new EnumMap<ResourceKind, Map<String, AspectGraph>>(ResourceKind.class);
    private final Map<ResourceKind, Map<String, String>> textMap = new EnumMap<ResourceKind, Map<String, String>>(ResourceKind.class);
    private GrammarModel model;
    private boolean undoSuspended;
    private final Observable observable = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    };

    public abstract String getName();

    public abstract Object getLocation();

    public boolean isEmpty() {
        boolean result = true;
        ResourceKind[] resourceKindArray = ResourceKind.values();
        int n = resourceKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceKind kind = resourceKindArray[n2];
            result = kind == ResourceKind.PROPERTIES ? !this.hasSystemProperties() : (kind.isTextBased() ? this.getTextMap(kind).isEmpty() : this.getGraphMap(kind).isEmpty());
            if (!result) break;
            ++n2;
        }
        return result;
    }

    public abstract Map<String, AspectGraph> getGraphs(ResourceKind var1);

    public abstract Collection<AspectGraph> putGraphs(ResourceKind var1, Collection<AspectGraph> var2, boolean var3) throws IOException;

    public abstract Collection<AspectGraph> deleteGraphs(ResourceKind var1, Collection<String> var2) throws IOException;

    public abstract Map<String, String> getTexts(ResourceKind var1);

    public abstract Map<String, String> putTexts(ResourceKind var1, Map<String, String> var2) throws IOException;

    public abstract Map<String, String> deleteTexts(ResourceKind var1, Collection<String> var2) throws IOException;

    public abstract void rename(ResourceKind var1, String var2, String var3) throws IOException;

    public abstract GrammarProperties getProperties();

    public abstract void putProperties(GrammarProperties var1) throws IOException;

    public abstract void relabel(TypeLabel var1, TypeLabel var2) throws IOException;

    public abstract void reload() throws IOException;

    public abstract SystemStore save(File var1, boolean var2) throws IOException;

    public GrammarModel toGrammarModel() {
        if (this.model == null) {
            this.model = new GrammarModel(this);
            this.addObserver(this.model);
        }
        return this.model;
    }

    public void addObserver(Observer observer) {
        this.observable.addObserver(observer);
    }

    public abstract boolean isModifiable();

    public boolean isUndoSuspended() {
        return this.undoSuspended;
    }

    public void setUndoSuspended(boolean undoSuspended) {
        this.undoSuspended = undoSuspended;
    }

    protected final Map<String, AspectGraph> getGraphMap(ResourceKind kind) {
        Map<String, AspectGraph> result = this.graphMap.get((Object)kind);
        if (result == null) {
            result = new TreeMap<String, AspectGraph>();
            this.graphMap.put(kind, result);
        }
        return result;
    }

    protected final Map<String, String> getTextMap(ResourceKind kind) {
        Map<String, String> result = this.textMap.get((Object)kind);
        if (result == null) {
            result = new TreeMap<String, String>();
            this.textMap.put(kind, result);
        }
        return result;
    }

    protected abstract boolean hasSystemProperties();

    protected final void notifyObservers(Edit edit) {
        this.observable.notifyObservers(edit);
    }

    public static SystemStore save(File file, SystemStore store, boolean clearDir) throws IOException {
        if (!FileType.GRAMMAR_FILTER.accept(file)) {
            throw new IOException(String.format("File '%s' does not refer to a production system", file));
        }
        File newFile = null;
        if (file.exists()) {
            newFile = file;
            while ((newFile = new File(newFile.getParent(), "Copy of " + newFile.getName())).exists()) {
            }
            if (clearDir) {
                if (!file.renameTo(newFile)) {
                    throw new IOException(String.format("Can't save grammar to existing file '%s'", file));
                }
            } else {
                Util.copyDirectory(file, newFile, true);
            }
        }
        try {
            DefaultFileSystemStore result = new DefaultFileSystemStore(file, true);
            result.reload();
            ResourceKind[] resourceKindArray = ResourceKind.values();
            int n = resourceKindArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceKind kind = resourceKindArray[n2];
                if (kind == ResourceKind.PROPERTIES) {
                    result.putProperties(store.getProperties());
                } else if (kind.isTextBased()) {
                    result.putTexts(kind, store.getTexts(kind));
                } else {
                    result.putGraphs(kind, store.getGraphs(kind).values(), false);
                }
                ++n2;
            }
            if (newFile != null) {
                boolean deleted = SystemStore.deleteRecursive(newFile);
                assert (deleted) : String.format("Failed to delete '%s'", newFile);
            }
            return result;
        }
        catch (IOException exc) {
            file.delete();
            if (newFile != null) {
                newFile.renameTo(file);
            }
            throw exc;
        }
    }

    private static boolean deleteRecursive(File location) {
        if (location.isDirectory()) {
            File[] fileArray = location.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!SystemStore.deleteRecursive(file)) {
                    return false;
                }
                ++n2;
            }
            return location.delete();
        }
        location.delete();
        return true;
    }

    public static interface Edit
    extends UndoableEdit {
        public Set<ResourceKind> getChange();

        public EditType getType();
    }
}

