/*
 * Decompiled with CFR 0.152.
 */
package groove.lts;

import groove.grammar.Recipe;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostGraphMorphism;
import groove.graph.AEdge;
import groove.graph.EdgeRole;
import groove.graph.Morphism;
import groove.lts.GraphState;
import groove.lts.GraphTransition;
import groove.lts.RecipeEvent;
import groove.lts.RecipeTransitionLabel;
import groove.lts.RuleTransition;
import groove.transform.RuleApplication;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class RecipeTransition
extends AEdge<GraphState, RecipeTransitionLabel>
implements GraphTransition {
    private HostGraphMorphism morphism;
    private RecipeEvent event;
    private Set<RuleTransition> steps;

    public RecipeTransition(GraphState source, RuleTransition initial, GraphState target) {
        super(source, new RecipeTransitionLabel(initial), target);
    }

    @Override
    public String text(boolean anchored) {
        return ((RecipeTransitionLabel)this.label()).text();
    }

    @Override
    public Recipe getAction() {
        return ((RecipeTransitionLabel)this.label()).getAction();
    }

    @Override
    public RecipeEvent getEvent() {
        if (this.event == null) {
            this.event = new RecipeEvent(this);
        }
        return this.event;
    }

    @Override
    public boolean isPartial() {
        return false;
    }

    @Override
    public RuleTransition getInitial() {
        return ((RecipeTransitionLabel)this.label()).getInitial();
    }

    public Set<RuleTransition> getSteps() {
        Set<RuleTransition> result = this.steps;
        if (result == null) {
            result = this.computeSteps();
            if (((GraphState)this.source()).isDone()) {
                this.steps = result;
            }
        }
        return result;
    }

    public List<RuleTransition> getPath() {
        List result = null;
        ArrayList<List<RuleTransition>> paths = new ArrayList<List<RuleTransition>>();
        paths.add(Arrays.asList(this.getInitial()));
        while (result == null) {
            ArrayList newPaths = new ArrayList();
            for (List list : paths) {
                GraphState target = ((RuleTransition)list.get(list.size() - 1)).target();
                if (target == this.target()) {
                    result = list;
                    break;
                }
                for (RuleTransition next : target.getRuleTransitions()) {
                    if (!this.getSteps().contains(next)) continue;
                    ArrayList<RuleTransition> newPath = new ArrayList<RuleTransition>(list);
                    newPath.add(next);
                    newPaths.add(newPath);
                }
            }
            paths = newPaths;
        }
        return result;
    }

    private Set<RuleTransition> computeSteps() {
        HashMap<GraphState, HashSet<RuleTransition>> inMap = new HashMap<GraphState, HashSet<RuleTransition>>();
        Stack<GraphState> pool = new Stack<GraphState>();
        pool.add(this.getInitial().target());
        while (!pool.isEmpty()) {
            GraphState next = (GraphState)pool.pop();
            for (RuleTransition trans : next.getRuleTransitions()) {
                boolean fresh;
                GraphState target = trans.target();
                if (!target.isTransient() && target != this.target()) continue;
                HashSet<RuleTransition> inSet = (HashSet<RuleTransition>)inMap.get(target);
                boolean bl = fresh = inSet == null;
                if (fresh) {
                    inSet = new HashSet<RuleTransition>();
                    inMap.put(target, inSet);
                }
                inSet.add(trans);
                if (!fresh || target == this.target()) continue;
                pool.add(target);
            }
        }
        assert (this.getInitial().target().equals(this.target()) || inMap.containsKey(this.target()));
        HashSet<RuleTransition> result = new HashSet<RuleTransition>();
        result.add(this.getInitial());
        pool.add((GraphState)this.target());
        while (!pool.isEmpty()) {
            GraphState next = (GraphState)pool.pop();
            Set inSet = (Set)inMap.remove(next);
            if (inSet == null) continue;
            for (RuleTransition in : inSet) {
                result.add(in);
                pool.add(in.source());
            }
        }
        return result;
    }

    @Override
    public EdgeRole getRole() {
        return EdgeRole.BINARY;
    }

    @Override
    public HostGraphMorphism getMorphism() {
        if (this.morphism == null) {
            this.morphism = this.computeMorphism();
        }
        return this.morphism;
    }

    @Override
    public RecipeEvent getKey() {
        return this.getEvent();
    }

    @Override
    public RecipeEvent toStub() {
        return this.getEvent();
    }

    protected HostGraphMorphism computeMorphism() {
        HostGraphMorphism result = null;
        HostGraph host = ((GraphState)this.source()).getGraph();
        for (RuleTransition step : this.getSteps()) {
            RuleApplication appl = step.getEvent().newApplication(host);
            result = result == null ? appl.getMorphism() : result.then((Morphism)appl.getMorphism());
            host = appl.getTarget();
        }
        return result;
    }

    public RecipeTransition toTransition(GraphState source) {
        if (source != this.source()) {
            throw new IllegalArgumentException("Source state incompatible");
        }
        return this;
    }

    protected boolean equalsSource(RuleTransition other) {
        return this.source() == other.source();
    }

    @Override
    protected boolean isTypeEqual(Object obj) {
        return obj instanceof RecipeTransition;
    }
}

