/*
 * Decompiled with CFR 0.152.
 */
package groove.match.plan;

import groove.algebra.Algebra;
import groove.algebra.SignatureKind;
import groove.grammar.Condition;
import groove.grammar.GrammarProperties;
import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.grammar.rule.AnchorKey;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleElement;
import groove.grammar.rule.RuleGraph;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.RuleToHostMap;
import groove.match.Matcher;
import groove.match.MatcherFactory;
import groove.match.TreeMatch;
import groove.match.plan.AbstractSearchItem;
import groove.match.plan.PlanSearchStrategy;
import groove.match.plan.SearchItem;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ConditionSearchItem
extends AbstractSearchItem {
    final Condition condition;
    final Matcher matcher;
    final Algebra<?> intAlgebra;
    final RuleNode countNode;
    final boolean positive;
    int condIx;
    boolean preCounted;
    int countNodeIx = -1;
    private final RuleGraph rootGraph;
    private final Set<RuleNode> neededNodes;
    private final Set<LabelVar> neededVars;
    private final Set<RuleNode> boundNodes;
    Map<RuleNode, Integer> nodeIxMap;
    Map<RuleEdge, Integer> edgeIxMap;
    Map<LabelVar, Integer> varIxMap;

    public ConditionSearchItem(Condition condition) {
        this.condition = condition;
        GrammarProperties properties = condition.getSystemProperties();
        this.matcher = MatcherFactory.instance().createMatcher(condition);
        if (condition.hasPattern()) {
            this.intAlgebra = properties.getAlgebraFamily().getAlgebra(SignatureKind.INT);
            this.rootGraph = condition.getRoot();
            this.neededNodes = condition.getInputNodes();
            this.neededVars = this.rootGraph.varSet();
            this.positive = condition.isPositive();
            this.countNode = condition.getCountNode();
            this.boundNodes = this.countNode == null ? Collections.emptySet() : Collections.singleton(this.countNode);
        } else {
            this.intAlgebra = null;
            this.rootGraph = null;
            this.neededNodes = Collections.emptySet();
            this.neededVars = Collections.emptySet();
            this.positive = false;
            this.boundNodes = Collections.emptySet();
            this.countNode = null;
        }
    }

    @Override
    public Collection<RuleNode> needsNodes() {
        return this.neededNodes;
    }

    @Override
    public Collection<LabelVar> needsVars() {
        return this.neededVars;
    }

    @Override
    public Collection<? extends RuleNode> bindsNodes() {
        return this.boundNodes;
    }

    @Override
    public int compareTo(SearchItem item) {
        int result = super.compareTo(item);
        if (result != 0) {
            return result;
        }
        ConditionSearchItem other = (ConditionSearchItem)item;
        return this.condition.getName().compareTo(other.condition.getName());
    }

    @Override
    int getRating() {
        switch (this.condition.getOp()) {
            case FORALL: 
            case EXISTS: 
            case NOT: {
                return -this.condition.getPattern().nodeCount() - (this.rootGraph == null ? 0 : this.rootGraph.size());
            }
            case TRUE: {
                return 0;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    int computeHashCode() {
        int result = super.computeHashCode();
        return result * 31 + this.getCondition().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ConditionSearchItem other = (ConditionSearchItem)obj;
        return this.getCondition().equals(other.getCondition());
    }

    @Override
    public boolean isTestsNodes() {
        return true;
    }

    @Override
    public void activate(PlanSearchStrategy strategy) {
        if (this.condition.getOp() != Condition.Op.NOT) {
            this.condIx = strategy.getCondIx(this.condition);
        }
        if (this.condition.hasPattern()) {
            this.nodeIxMap = new HashMap<RuleNode, Integer>();
            for (RuleNode node : this.rootGraph.nodeSet()) {
                this.nodeIxMap.put(node, strategy.getNodeIx(node));
            }
            this.edgeIxMap = new HashMap<RuleEdge, Integer>();
            for (RuleEdge edge : this.rootGraph.edgeSet()) {
                this.edgeIxMap.put(edge, strategy.getEdgeIx(edge));
            }
            this.varIxMap = new HashMap<LabelVar, Integer>();
            for (LabelVar var : this.rootGraph.varSet()) {
                this.varIxMap.put(var, strategy.getVarIx(var));
            }
            if (this.countNode != null) {
                this.preCounted = strategy.isNodeFound(this.countNode);
                this.countNodeIx = strategy.getNodeIx(this.countNode);
            }
        }
    }

    @Override
    public SearchItem.Record createRecord(PlanSearchStrategy.Search search) {
        switch (this.condition.getOp()) {
            case FORALL: 
            case EXISTS: {
                return new QuantifierRecord(search);
            }
            case NOT: {
                return new NegConditionRecord(search);
            }
            case TRUE: {
                return new TrueRecord(search);
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return String.format("%s %s: %s", this.condition.getOp().getName(), this.condition.getName(), ((PlanSearchStrategy)this.matcher.getSearchStrategy()).getPlan());
    }

    @Override
    void setRelevant(boolean relevant) {
        super.setRelevant(relevant || this.isModifying());
    }

    public Condition getCondition() {
        return this.condition;
    }

    private boolean isModifying() {
        return this.isModifying(this.condition);
    }

    private boolean isModifying(Condition condition) {
        boolean result = false;
        if (condition.hasRule()) {
            result = condition.getRule().isModifying();
        } else {
            for (Condition subCondition : condition.getSubConditions()) {
                if (!this.isModifying(subCondition)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private class NegConditionRecord
    extends PatternRecord {
        public NegConditionRecord(PlanSearchStrategy.Search search) {
            super(search);
        }

        @Override
        boolean find() {
            return ConditionSearchItem.this.matcher.find(this.host, this.createContextMap()) == null;
        }

        @Override
        boolean write() {
            return true;
        }

        @Override
        void erase() {
        }
    }

    private abstract class PatternRecord
    extends AbstractSearchItem.SingularRecord {
        public PatternRecord(PlanSearchStrategy.Search search) {
            super(search);
        }

        final RuleToHostMap createContextMap() {
            RuleToHostMap result = this.host.getFactory().createRuleToHostMap();
            for (Map.Entry<RuleNode, Integer> entry : ConditionSearchItem.this.nodeIxMap.entrySet()) {
                result.putNode(entry.getKey(), this.search.getNode(entry.getValue()));
            }
            for (Map.Entry<RuleElement, Integer> entry : ConditionSearchItem.this.edgeIxMap.entrySet()) {
                result.putEdge((RuleEdge)entry.getKey(), this.search.getEdge(entry.getValue()));
            }
            for (Map.Entry<AnchorKey, Integer> entry : ConditionSearchItem.this.varIxMap.entrySet()) {
                result.putVar((LabelVar)entry.getKey(), this.search.getVar(entry.getValue()));
            }
            return result;
        }
    }

    private class QuantifierRecord
    extends PatternRecord {
        private int preCount;
        private ValueNode countImage;
        private TreeMatch match;

        public QuantifierRecord(PlanSearchStrategy.Search search) {
            super(search);
        }

        @Override
        boolean find() {
            boolean result = true;
            if (ConditionSearchItem.this.preCounted) {
                HostNode countImage = this.search.getNode(ConditionSearchItem.this.countNodeIx);
                this.preCount = Integer.parseInt(((ValueNode)countImage).getSymbol());
            }
            RuleToHostMap contextMap = this.createContextMap();
            List<TreeMatch> matches = ConditionSearchItem.this.matcher.findAll(this.host, contextMap);
            if (ConditionSearchItem.this.condition.getOp() == Condition.Op.FORALL && ConditionSearchItem.this.positive && matches.isEmpty()) {
                result = false;
            } else if (ConditionSearchItem.this.preCounted) {
                result = matches.size() == this.preCount;
            } else if (ConditionSearchItem.this.countNode != null) {
                this.countImage = this.host.getFactory().createNodeFromJava(ConditionSearchItem.this.intAlgebra, matches.size());
            }
            if (result) {
                this.match = this.createMatch(matches);
                result = this.write();
            } else {
                this.match = null;
            }
            return result;
        }

        private TreeMatch createMatch(List<TreeMatch> matches) {
            Condition.Op op;
            boolean noMatches = matches.isEmpty();
            boolean positive = ConditionSearchItem.this.positive;
            switch (ConditionSearchItem.this.condition.getOp()) {
                case AND: {
                    op = noMatches ? Condition.Op.TRUE : Condition.Op.AND;
                    break;
                }
                case FORALL: {
                    op = noMatches ? (positive ? Condition.Op.FALSE : Condition.Op.TRUE) : Condition.Op.AND;
                    break;
                }
                case OR: {
                    op = noMatches ? Condition.Op.FALSE : Condition.Op.OR;
                    break;
                }
                case EXISTS: {
                    op = noMatches ? (positive ? Condition.Op.FALSE : Condition.Op.TRUE) : Condition.Op.OR;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            TreeMatch result = new TreeMatch(op, ConditionSearchItem.this.condition);
            if (!noMatches) {
                result.addSubMatches(matches);
            }
            return result;
        }

        @Override
        boolean write() {
            boolean result = true;
            if (this.countImage != null) {
                result = this.search.putNode(ConditionSearchItem.this.countNodeIx, this.countImage);
            }
            if (result) {
                result = this.search.putSubMatch(ConditionSearchItem.this.condIx, this.match);
            }
            return result;
        }

        @Override
        void erase() {
            if (this.countImage != null) {
                this.search.putNode(ConditionSearchItem.this.countNodeIx, null);
            }
            this.search.putSubMatch(ConditionSearchItem.this.condIx, null);
        }

        @Override
        public String toString() {
            return "Match of " + ConditionSearchItem.this.toString();
        }
    }

    private class TrueRecord
    extends AbstractSearchItem.SingularRecord {
        public TrueRecord(PlanSearchStrategy.Search search) {
            super(search);
        }

        @Override
        boolean find() {
            return this.write();
        }

        @Override
        boolean write() {
            this.search.putSubMatch(ConditionSearchItem.this.condIx, new TreeMatch(ConditionSearchItem.this.condition, null));
            return true;
        }

        @Override
        void erase() {
            this.search.putSubMatch(ConditionSearchItem.this.condIx, null);
        }

        @Override
        public String toString() {
            return "Match of " + ConditionSearchItem.this.toString();
        }
    }
}

