/*
 * Decompiled with CFR 0.152.
 */
package groove.match.plan;

import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleNode;
import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeNode;
import groove.match.plan.AbstractSearchItem;
import groove.match.plan.PlanSearchStrategy;
import groove.match.plan.SearchItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

class NodeTypeSearchItem
extends AbstractSearchItem {
    final RuleNode node;
    final TypeNode type;
    private final List<LabelVar> boundVars;
    private final Set<RuleNode> boundNodes;
    private int nodeIx;
    boolean[] varFound;
    int[] varIxs;
    boolean nodeFound;
    final Set<TypeNode> matchingTypes;

    public NodeTypeSearchItem(RuleNode node) {
        this(node, node.getType());
    }

    public NodeTypeSearchItem(RuleNode node, TypeNode type) {
        this.node = node;
        this.type = type;
        this.boundVars = new ArrayList<LabelVar>(node.getVars());
        this.boundNodes = Collections.singleton(node);
        this.matchingTypes = node.getMatchingTypes();
    }

    @Override
    public Collection<? extends RuleNode> bindsNodes() {
        return this.boundNodes;
    }

    @Override
    public Collection<LabelVar> bindsVars() {
        return this.boundVars;
    }

    @Override
    public Collection<? extends RuleEdge> bindsEdges() {
        return Collections.emptySet();
    }

    public RuleNode getNode() {
        return this.node;
    }

    public String toString() {
        return String.format("Find node %s:%s", this.node, this.matchingTypes);
    }

    @Override
    public int compareTo(SearchItem item) {
        int result = super.compareTo(item);
        if (result != 0) {
            return result;
        }
        NodeTypeSearchItem other = (NodeTypeSearchItem)item;
        result = this.type.compareTo(other.type);
        if (result != 0) {
            return result;
        }
        return this.node.getNumber() - other.node.getNumber();
    }

    @Override
    int computeHashCode() {
        return super.computeHashCode() * 31 * this.getNode().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getNode().equals(((NodeTypeSearchItem)obj).getNode());
    }

    @Override
    public void activate(PlanSearchStrategy strategy) {
        this.nodeFound = strategy.isNodeFound(this.node);
        this.nodeIx = strategy.getNodeIx(this.node);
        this.varIxs = new int[this.boundVars.size()];
        this.varFound = new boolean[this.boundVars.size()];
        int i = 0;
        while (i < this.varIxs.length) {
            LabelVar var = this.boundVars.get(i);
            this.varFound[i] = strategy.isVarFound(var);
            this.varIxs[i] = strategy.getVarIx(var);
            ++i;
        }
    }

    @Override
    int getRating() {
        return this.type.hashCode();
    }

    @Override
    public final SearchItem.Record createRecord(PlanSearchStrategy.Search search) {
        if (this.nodeFound) {
            return this.createSingularRecord(search);
        }
        return this.createMultipleRecord(search);
    }

    AbstractSearchItem.SingularRecord createSingularRecord(PlanSearchStrategy.Search search) {
        return new NodeTypeSingularRecord(search, this.nodeIx);
    }

    AbstractSearchItem.MultipleRecord<HostNode> createMultipleRecord(PlanSearchStrategy.Search search) {
        return new NodeTypeMultipleRecord(search, this.nodeIx);
    }

    private class NodeTypeMultipleRecord
    extends AbstractSearchItem.MultipleRecord<HostNode> {
        private final int sourceIx;
        private final TypeElement[] varFind;
        private HostNode selected;

        NodeTypeMultipleRecord(PlanSearchStrategy.Search search, int sourceIx) {
            super(search);
            this.sourceIx = sourceIx;
            this.varFind = new TypeElement[NodeTypeSearchItem.this.varIxs.length];
        }

        @Override
        void init() {
            int vi = 0;
            while (vi < this.varFind.length) {
                if (NodeTypeSearchItem.this.varFound[vi]) {
                    int varIx = NodeTypeSearchItem.this.varIxs[vi];
                    this.varFind[vi] = this.search.getVar(varIx);
                }
                ++vi;
            }
            this.initImages();
        }

        @Override
        boolean write(HostNode image) {
            if (!NodeTypeSearchItem.this.matchingTypes.contains(image.getType())) {
                return false;
            }
            boolean result = true;
            int vi = 0;
            while (result && vi < this.varFind.length) {
                int varIx = NodeTypeSearchItem.this.varIxs[vi];
                TypeElement varFind = this.varFind[vi];
                result = varFind != null ? varFind == image.getType() : this.search.putVar(varIx, image.getType());
                ++vi;
            }
            if (result) {
                result = this.search.putNode(this.sourceIx, image);
            }
            if (result) {
                this.selected = image;
            } else {
                --vi;
                while (vi >= 0) {
                    if (this.varFind[vi] == null) {
                        this.search.putVar(NodeTypeSearchItem.this.varIxs[vi], null);
                    }
                    --vi;
                }
            }
            return result;
        }

        @Override
        void erase() {
            this.search.putNode(this.sourceIx, null);
            int vi = 0;
            while (vi < this.varFind.length) {
                if (this.varFind[vi] == null) {
                    this.search.putVar(NodeTypeSearchItem.this.varIxs[vi], null);
                }
                ++vi;
            }
            this.selected = null;
        }

        private void initImages() {
            this.imageIter = this.host.nodeSet().iterator();
        }

        public String toString() {
            return String.valueOf(NodeTypeSearchItem.this.toString()) + " <= " + this.selected;
        }
    }

    private class NodeTypeSingularRecord
    extends AbstractSearchItem.SingularRecord {
        private HostNode nodeSeed;
        private final int nodeIx;
        private TypeNode imageType;

        public NodeTypeSingularRecord(PlanSearchStrategy.Search search, int nodeIx) {
            super(search);
            this.nodeIx = nodeIx;
        }

        @Override
        public void initialise(HostGraph host) {
            super.initialise(host);
            this.nodeSeed = this.search.getNodeSeed(this.nodeIx);
        }

        @Override
        boolean find() {
            boolean result = false;
            this.imageType = this.computeImage().getType();
            result = NodeTypeSearchItem.this.matchingTypes.contains(this.imageType);
            int vi = 0;
            while (result && vi < NodeTypeSearchItem.this.varFound.length) {
                int varIx = NodeTypeSearchItem.this.varIxs[vi];
                if (NodeTypeSearchItem.this.varFound[vi]) {
                    result = this.search.getVar(varIx) == this.imageType;
                }
                ++vi;
            }
            if (result) {
                result = this.write();
            }
            return result;
        }

        @Override
        void erase() {
            int vi = 0;
            while (vi < NodeTypeSearchItem.this.varFound.length) {
                if (!NodeTypeSearchItem.this.varFound[vi]) {
                    this.search.putVar(NodeTypeSearchItem.this.varIxs[vi], null);
                }
                ++vi;
            }
        }

        @Override
        final boolean write() {
            boolean result = true;
            int vi = 0;
            while (result && vi < NodeTypeSearchItem.this.varFound.length) {
                if (!NodeTypeSearchItem.this.varFound[vi]) {
                    result = this.search.putVar(NodeTypeSearchItem.this.varIxs[vi], this.imageType);
                }
                ++vi;
            }
            if (!result) {
                this.erase();
            }
            return result;
        }

        private HostNode computeImage() {
            return this.nodeSeed == null ? this.search.getNode(this.nodeIx) : this.nodeSeed;
        }

        @Override
        public String toString() {
            return String.valueOf(NodeTypeSearchItem.this.toString()) + " <= " + this.computeImage();
        }
    }
}

