/*
 * Decompiled with CFR 0.152.
 */
package groove.match.plan;

import groove.algebra.AlgebraFamily;
import groove.automaton.RegExpr;
import groove.grammar.Condition;
import groove.grammar.EdgeEmbargo;
import groove.grammar.GrammarProperties;
import groove.grammar.rule.Anchor;
import groove.grammar.rule.AnchorKey;
import groove.grammar.rule.DefaultRuleNode;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.OperatorNode;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleGraph;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.VariableNode;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.EdgeRole;
import groove.graph.Label;
import groove.match.SearchEngine;
import groove.match.ValueOracle;
import groove.match.plan.AbstractSearchItem;
import groove.match.plan.ConditionSearchItem;
import groove.match.plan.Edge2SearchItem;
import groove.match.plan.EqualitySearchItem;
import groove.match.plan.NegatedSearchItem;
import groove.match.plan.NodeTypeSearchItem;
import groove.match.plan.OperatorNodeSearchItem;
import groove.match.plan.PlanSearchStrategy;
import groove.match.plan.RegExprEdgeSearchItem;
import groove.match.plan.SearchItem;
import groove.match.plan.SearchPlan;
import groove.match.plan.SeedSearchItem;
import groove.match.plan.ValueNodeSearchItem;
import groove.match.plan.VarEdgeSearchItem;
import groove.util.collect.Bag;
import groove.util.collect.HashBag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;

public class PlanSearchEngine
extends SearchEngine {
    private final SearchEngine.SearchMode searchMode;
    private static Map<SearchEngine.SearchMode, PlanSearchEngine> instance;
    private static final boolean PRINT = false;

    private PlanSearchEngine(SearchEngine.SearchMode searchMode) {
        this.searchMode = searchMode;
    }

    @Override
    public PlanSearchStrategy createMatcher(Condition condition, Anchor seed, ValueOracle oracle) {
        HashSet<AnchorKey> anchorKeys = new HashSet<AnchorKey>();
        if (condition.hasRule()) {
            anchorKeys.addAll(condition.getRule().getAnchor());
        }
        PlanData planData = new PlanData(condition, this.searchMode);
        if (seed == null) {
            seed = new Anchor();
        }
        SearchPlan plan = planData.getPlan(seed);
        for (AbstractSearchItem item : plan) {
            boolean relevant = anchorKeys.removeAll(item.bindsNodes());
            relevant |= anchorKeys.removeAll(item.bindsEdges());
            relevant |= anchorKeys.removeAll(item.bindsVars());
            relevant |= condition.getOp() == Condition.Op.FORALL;
            relevant |= item instanceof ConditionSearchItem && ((ConditionSearchItem)item).getCondition().getOp() == Condition.Op.FORALL;
            item.setRelevant(relevant |= this.searchMode == SearchEngine.SearchMode.MINIMAL);
        }
        PlanSearchStrategy result = new PlanSearchStrategy(this, plan, oracle);
        result.setFixed();
        return result;
    }

    public static PlanSearchEngine getInstance() {
        return PlanSearchEngine.getInstance(SearchEngine.SearchMode.NORMAL);
    }

    public static PlanSearchEngine getInstance(SearchEngine.SearchMode searchMode) {
        if (instance == null) {
            instance = new EnumMap<SearchEngine.SearchMode, PlanSearchEngine>(SearchEngine.SearchMode.class);
            SearchEngine.SearchMode[] searchModeArray = SearchEngine.SearchMode.values();
            int n = searchModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SearchEngine.SearchMode mode = searchModeArray[n2];
                instance.put(mode, new PlanSearchEngine(mode));
                ++n2;
            }
        }
        return instance.get((Object)searchMode);
    }

    static class ConnectedPartsComparator
    implements Comparator<SearchItem> {
        private final Set<RuleNode> remainingNodes;
        private final Set<LabelVar> remainingVars;

        ConnectedPartsComparator(Set<RuleNode> remainingNodes, Set<LabelVar> remainingVars) {
            this.remainingNodes = remainingNodes;
            this.remainingVars = remainingVars;
        }

        @Override
        public int compare(SearchItem o1, SearchItem o2) {
            return this.getConnectCount(o1) - this.getConnectCount(o2);
        }

        private int getConnectCount(SearchItem item) {
            int result = 0;
            for (RuleNode ruleNode : item.bindsNodes()) {
                if (this.remainingNodes.contains(ruleNode)) continue;
                ++result;
            }
            for (LabelVar labelVar : item.bindsVars()) {
                if (this.remainingVars.contains(labelVar)) continue;
                ++result;
            }
            return result;
        }
    }

    static class FrequencyComparator
    implements Comparator<SearchItem> {
        private final Map<Label, Integer> priorities = new HashMap<Label, Integer>();

        FrequencyComparator(List<String> rare, List<String> common) {
            TypeLabel label;
            int i;
            if (rare != null) {
                i = 0;
                while (i < rare.size()) {
                    label = TypeLabel.createLabel(rare.get(i));
                    this.priorities.put(label, rare.size() - i);
                    ++i;
                }
            }
            if (common != null) {
                i = 0;
                while (i < common.size()) {
                    label = TypeLabel.createLabel(common.get(i));
                    this.priorities.put(label, i - common.size());
                    ++i;
                }
            }
        }

        @Override
        public int compare(SearchItem first, SearchItem second) {
            if (first instanceof Edge2SearchItem && second instanceof Edge2SearchItem) {
                Object firstLabel = ((Edge2SearchItem)first).getEdge().label();
                Object secondLabel = ((Edge2SearchItem)second).getEdge().label();
                return this.getEdgePriority((Label)firstLabel) - this.getEdgePriority((Label)secondLabel);
            }
            return 0;
        }

        private int getEdgePriority(Label edgeLabel) {
            Integer result = this.priorities.get(edgeLabel);
            if (result == null) {
                return 0;
            }
            return result;
        }
    }

    static class IndegreeComparator
    implements Comparator<SearchItem>,
    Observer {
        private final Bag<RuleNode> indegrees;

        IndegreeComparator(Set<? extends RuleEdge> remainingEdges) {
            HashBag<RuleNode> indegrees = new HashBag<RuleNode>();
            for (RuleEdge ruleEdge : remainingEdges) {
                if (((RuleNode)ruleEdge.target()).equals(ruleEdge.source())) continue;
                indegrees.add((RuleNode)ruleEdge.target());
            }
            this.indegrees = indegrees;
        }

        @Override
        public int compare(SearchItem item1, SearchItem item2) {
            int result = 0;
            if (item1 instanceof Edge2SearchItem && item2 instanceof Edge2SearchItem) {
                RuleEdge first = ((Edge2SearchItem)item1).getEdge();
                RuleEdge second = ((Edge2SearchItem)item2).getEdge();
                result = this.indegree((RuleNode)second.source()) - this.indegree((RuleNode)first.source());
                if (result == 0) {
                    result = this.indegree((RuleNode)first.target()) - this.indegree((RuleNode)second.target());
                }
            }
            return result;
        }

        @Override
        public void update(Observable o, Object arg) {
            if (arg instanceof Edge2SearchItem) {
                RuleEdge selected = ((Edge2SearchItem)arg).getEdge();
                this.indegrees.remove(selected.target());
            }
        }

        private int indegree(RuleNode node) {
            return this.indegrees.multiplicity(node);
        }
    }

    static class ItemComparatorComparator
    implements Comparator<Comparator<SearchItem>> {
        ItemComparatorComparator() {
        }

        @Override
        public int compare(Comparator<SearchItem> o1, Comparator<SearchItem> o2) {
            return this.getRating(o1) - this.getRating(o2);
        }

        private int getRating(Comparator<SearchItem> comparator) {
            int result = 0;
            Class<?> compClass = comparator.getClass();
            if (compClass == NeededPartsComparator.class) {
                return result;
            }
            ++result;
            if (compClass == ItemTypeComparator.class) {
                return result;
            }
            ++result;
            if (compClass == ConnectedPartsComparator.class) {
                return result;
            }
            ++result;
            if (compClass == FrequencyComparator.class) {
                return result;
            }
            ++result;
            if (compClass == IndegreeComparator.class) {
                return result;
            }
            throw new IllegalArgumentException(String.format("Unknown comparator class %s", compClass));
        }
    }

    static class ItemTypeComparator
    implements Comparator<SearchItem> {
        ItemTypeComparator() {
        }

        @Override
        public int compare(SearchItem o1, SearchItem o2) {
            return this.getRating(o1) - this.getRating(o2);
        }

        int getRating(SearchItem item) {
            int result = 0;
            Class<?> itemClass = item.getClass();
            if (itemClass == RegExprEdgeSearchItem.class && ((RegExprEdgeSearchItem)item).getEdgeExpr().isAcceptsEmptyWord()) {
                return result;
            }
            if (itemClass == NodeTypeSearchItem.class) {
                return result;
            }
            ++result;
            if (itemClass == ConditionSearchItem.class) {
                return result;
            }
            ++result;
            if (itemClass == RegExprEdgeSearchItem.class) {
                return result;
            }
            ++result;
            if (itemClass == VarEdgeSearchItem.class) {
                return result;
            }
            ++result;
            if (itemClass == Edge2SearchItem.class) {
                return result;
            }
            ++result;
            if (itemClass == EqualitySearchItem.class) {
                return result;
            }
            ++result;
            if (itemClass == NegatedSearchItem.class) {
                return result;
            }
            ++result;
            if (itemClass == OperatorNodeSearchItem.class) {
                return result;
            }
            ++result;
            if (itemClass == ValueNodeSearchItem.class) {
                return result;
            }
            ++result;
            if (itemClass == SeedSearchItem.class) {
                return result;
            }
            throw new IllegalArgumentException(String.format("Unrecognised search item %s", item));
        }
    }

    static class NeededPartsComparator
    implements Comparator<SearchItem> {
        private final Set<RuleNode> remainingNodes;
        private final Set<LabelVar> remainingVars;

        NeededPartsComparator(Set<RuleNode> remainingNodes, Set<LabelVar> remainingVars) {
            this.remainingNodes = remainingNodes;
            this.remainingVars = remainingVars;
        }

        @Override
        public int compare(SearchItem o1, SearchItem o2) {
            return this.getNeedCount(o1) - this.getNeedCount(o2);
        }

        private int getNeedCount(SearchItem item) {
            boolean missing = false;
            Iterator<RuleNode> neededNodeIter = item.needsNodes().iterator();
            while (!missing && neededNodeIter.hasNext()) {
                missing = this.remainingNodes.contains(neededNodeIter.next());
            }
            Iterator<LabelVar> neededVarIter = item.needsVars().iterator();
            while (!missing && neededVarIter.hasNext()) {
                missing = this.remainingVars.contains(neededVarIter.next());
            }
            return missing ? 0 : 1;
        }
    }

    private static class PlanData
    extends Observable
    implements Comparator<SearchItem> {
        private final Set<RuleNode> remainingNodes;
        private final Set<RuleEdge> remainingEdges;
        private final Set<LabelVar> remainingVars;
        private final TypeGraph typeGraph;
        private final AlgebraFamily algebraFamily;
        private Collection<Comparator<SearchItem>> comparators;
        private boolean used;
        private final SearchEngine.SearchMode searchMode;
        private final Condition condition;

        PlanData(Condition condition, SearchEngine.SearchMode searchMode) {
            this.condition = condition;
            this.searchMode = searchMode;
            this.typeGraph = condition.getTypeGraph();
            this.remainingNodes = new LinkedHashSet<RuleNode>();
            this.remainingEdges = new LinkedHashSet<RuleEdge>();
            this.remainingVars = new LinkedHashSet<LabelVar>();
            if (condition.hasPattern()) {
                RuleGraph graph = condition.getPattern();
                this.remainingNodes.addAll(graph.nodeSet());
                this.remainingEdges.addAll(graph.edgeSet());
                this.remainingVars.addAll(graph.varSet());
                this.algebraFamily = condition.getSystemProperties().getAlgebraFamily();
            } else {
                this.algebraFamily = AlgebraFamily.DEFAULT;
            }
        }

        private void testUsed() {
            if (this.used) {
                throw new IllegalStateException("Method getPlan() was already called");
            }
            this.used = true;
        }

        private boolean getInjectivity() {
            switch (this.searchMode) {
                case MINIMAL: 
                case REGEXPR: {
                    return false;
                }
                case REVERSE: {
                    return true;
                }
                case NORMAL: {
                    return this.condition.isInjective();
                }
            }
            assert (false);
            return false;
        }

        public SearchPlan getPlan(Anchor seed) {
            this.testUsed();
            boolean injective = this.getInjectivity();
            SearchPlan result = new SearchPlan(this.condition, seed, injective);
            Collection<AbstractSearchItem> items = this.computeSearchItems(seed);
            while (!items.isEmpty()) {
                AbstractSearchItem bestItem = (AbstractSearchItem)Collections.max(items, this);
                result.add(bestItem);
                this.remainingEdges.removeAll(bestItem.bindsEdges());
                this.remainingNodes.removeAll(bestItem.bindsNodes());
                this.remainingVars.removeAll(bestItem.bindsVars());
                this.setChanged();
                this.notifyObservers(bestItem);
                items.remove(bestItem);
            }
            assert (this.remainingEdges.isEmpty()) : String.format("Unmatched edges %s", this.remainingEdges);
            assert (this.remainingNodes.isEmpty()) : String.format("Unmatched nodes %s", this.remainingNodes);
            assert (this.remainingVars.isEmpty()) : String.format("Unmatched variables %s", this.remainingVars);
            return result;
        }

        @Override
        public final int compare(SearchItem o1, SearchItem o2) {
            int result = 0;
            Iterator<Comparator<SearchItem>> comparatorIter = this.getComparators().iterator();
            while (result == 0 && comparatorIter.hasNext()) {
                Comparator<SearchItem> next = comparatorIter.next();
                result = next.compare(o1, o2);
            }
            if (result == 0) {
                result = o1.compareTo(o2);
            }
            return result;
        }

        private Collection<AbstractSearchItem> computeSearchItems(Anchor seed) {
            ArrayList<AbstractSearchItem> result = new ArrayList<AbstractSearchItem>();
            if (this.condition.hasPattern()) {
                result.addAll(this.computePatternSearchItems(seed));
            }
            for (Condition subCondition : this.condition.getSubConditions()) {
                AbstractSearchItem item = null;
                if (subCondition.isCompatible(this.searchMode)) {
                    item = subCondition instanceof EdgeEmbargo ? this.createEdgeEmbargoItem((EdgeEmbargo)subCondition) : new ConditionSearchItem(subCondition);
                } else if (this.searchMode == SearchEngine.SearchMode.REVERSE && subCondition.isReversable()) {
                    item = new ConditionSearchItem(subCondition.reverse());
                }
                if (item == null) continue;
                result.add(item);
            }
            return result;
        }

        private AbstractSearchItem createEdgeEmbargoItem(EdgeEmbargo subCondition) {
            AbstractSearchItem item = null;
            RuleEdge embargoEdge = subCondition.getEmbargoEdge();
            if (!((RuleLabel)embargoEdge.label()).isEmpty()) {
                AbstractSearchItem edgeSearchItem = this.createEdgeSearchItem(embargoEdge);
                item = this.createNegatedSearchItem(edgeSearchItem);
            } else if (!this.condition.isInjective()) {
                item = new EqualitySearchItem(embargoEdge, false);
            }
            return item;
        }

        Collection<AbstractSearchItem> computePatternSearchItems(Anchor seed) {
            ArrayList<AbstractSearchItem> result = new ArrayList<AbstractSearchItem>();
            LinkedHashSet<RuleNode> unmatchedNodes = new LinkedHashSet<RuleNode>(this.remainingNodes);
            LinkedHashSet<RuleEdge> unmatchedEdges = new LinkedHashSet<RuleEdge>(this.remainingEdges);
            if (seed == null) {
                seed = new Anchor();
            }
            if (!seed.isEmpty()) {
                SeedSearchItem seedItem = new SeedSearchItem(seed);
                result.add(seedItem);
                unmatchedNodes.removeAll(((AbstractSearchItem)seedItem).bindsNodes());
                unmatchedEdges.removeAll(((AbstractSearchItem)seedItem).bindsEdges());
            }
            Iterator unmatchedNodeIter = unmatchedNodes.iterator();
            while (unmatchedNodeIter.hasNext()) {
                AbstractSearchItem nodeItem;
                RuleNode node = (RuleNode)unmatchedNodeIter.next();
                if ((!(node instanceof VariableNode) || ((VariableNode)node).getConstant() == null) && node.getTypeGuards().isEmpty() || (nodeItem = this.createNodeSearchItem(node)) == null) continue;
                result.add(nodeItem);
                unmatchedNodeIter.remove();
            }
            for (RuleEdge edge : unmatchedEdges) {
                AbstractSearchItem edgeItem = this.createEdgeSearchItem(edge);
                if (edgeItem == null) continue;
                result.add(edgeItem);
                RuleNode source = (RuleNode)edge.source();
                if (edgeItem.bindsNodes().contains(source) && edge.getType() != null && edge.getType().source() == source.getType()) {
                    unmatchedNodes.remove(source);
                }
                RuleNode target = (RuleNode)edge.target();
                if (!edgeItem.bindsNodes().contains(target) || edge.getType() == null || edge.getType().target() != target.getType()) continue;
                unmatchedNodes.remove(target);
            }
            for (RuleNode node : unmatchedNodes) {
                AbstractSearchItem nodeItem = this.createNodeSearchItem(node);
                if (nodeItem == null) continue;
                assert (!(node instanceof VariableNode) || ((VariableNode)node).hasConstant() || this.algebraFamily.supportsSymbolic() || seed.nodeSet().contains(node)) : String.format("Variable node '%s' should be among anchors %s", node, seed);
                result.add(nodeItem);
            }
            return result;
        }

        Collection<Comparator<SearchItem>> computeComparators() {
            TreeSet<Comparator<SearchItem>> result = new TreeSet<Comparator<SearchItem>>(new ItemComparatorComparator());
            result.add(new NeededPartsComparator(this.remainingNodes, this.remainingVars));
            result.add(new ItemTypeComparator());
            result.add(new ConnectedPartsComparator(this.remainingNodes, this.remainingVars));
            result.add(new IndegreeComparator(this.remainingEdges));
            GrammarProperties properties = this.condition.getSystemProperties();
            if (properties != null) {
                List<String> controlLabels = properties.getControlLabels();
                List<String> commonLabels = properties.getCommonLabels();
                result.add(new FrequencyComparator(controlLabels, commonLabels));
            }
            return result;
        }

        final Collection<Comparator<SearchItem>> getComparators() {
            if (this.comparators == null) {
                this.comparators = this.computeComparators();
                for (Comparator<SearchItem> comparator : this.comparators) {
                    if (!(comparator instanceof Observer)) continue;
                    this.addObserver((Observer)((Object)comparator));
                }
            }
            return this.comparators;
        }

        protected AbstractSearchItem createEdgeSearchItem(RuleEdge edge) {
            AbstractSearchItem result = null;
            RuleLabel label = (RuleLabel)edge.label();
            RuleNode target = (RuleNode)edge.target();
            RuleNode source = (RuleNode)edge.source();
            RegExpr negOperand = label.getNegOperand();
            if (negOperand instanceof RegExpr.Empty) {
                result = new EqualitySearchItem(edge, false);
            } else if (negOperand != null) {
                AbstractSearchItem negatedItem;
                RuleLabel negatedLabel = negOperand.toLabel();
                if (negatedLabel.getRole() == EdgeRole.NODE_TYPE && !this.typeGraph.isImplicit()) {
                    TypeNode negatedType = this.typeGraph.getNode(negatedLabel);
                    negatedItem = new NodeTypeSearchItem((RuleNode)edge.source(), negatedType);
                } else {
                    RuleEdge negatedEdge = this.condition.getFactory().createEdge(source, (Label)negatedLabel, target);
                    negatedItem = this.createEdgeSearchItem(negatedEdge);
                }
                result = this.createNegatedSearchItem(negatedItem);
                this.remainingEdges.remove(edge);
            } else if (label.getWildcardGuard() != null) {
                assert (!this.typeGraph.isNodeType(edge));
                result = new VarEdgeSearchItem(edge);
            } else {
                result = label.isEmpty() ? new EqualitySearchItem(edge, true) : (label.isSharp() || label.isAtom() ? new Edge2SearchItem(edge) : new RegExprEdgeSearchItem(edge, this.typeGraph));
            }
            return result;
        }

        protected AbstractSearchItem createNodeSearchItem(RuleNode node) {
            AbstractSearchItem result = null;
            if (node instanceof VariableNode) {
                assert (this.searchMode == SearchEngine.SearchMode.NORMAL);
                if (((VariableNode)node).hasConstant() || this.algebraFamily.supportsSymbolic()) {
                    result = new ValueNodeSearchItem((VariableNode)node, this.algebraFamily);
                }
            } else if (node instanceof OperatorNode) {
                assert (this.searchMode == SearchEngine.SearchMode.NORMAL);
                result = new OperatorNodeSearchItem((OperatorNode)node, this.algebraFamily);
            } else {
                assert (node instanceof DefaultRuleNode);
                result = new NodeTypeSearchItem(node);
            }
            return result;
        }

        protected NegatedSearchItem createNegatedSearchItem(SearchItem inner) {
            return new NegatedSearchItem(inner);
        }
    }
}

