/*
 * Decompiled with CFR 0.152.
 */
package groove.match.plan;

import groove.automaton.RegAut;
import groove.automaton.RegExpr;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.Valuation;
import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeGraph;
import groove.graph.EdgeComparator;
import groove.match.plan.AbstractSearchItem;
import groove.match.plan.PlanSearchStrategy;
import groove.match.plan.SearchItem;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class RegExprEdgeSearchItem
extends AbstractSearchItem {
    private final RuleEdge edge;
    final RuleNode source;
    final RuleNode target;
    final boolean selfEdge;
    private final Set<RuleEdge> boundEdges;
    private final Set<RuleNode> boundNodes;
    int sourceIx;
    int targetIx;
    boolean sourceFound;
    boolean targetFound;
    final RegAut labelAutomaton;
    final RegExpr edgeExpr;
    final Set<LabelVar> allVars;
    final Set<LabelVar> boundVars;
    final Set<LabelVar> neededVars;
    Set<LabelVar> prematchedVars;
    Map<LabelVar, Integer> varIxMap;

    public RegExprEdgeSearchItem(RuleEdge edge, TypeGraph typeGraph) {
        this.edge = edge;
        this.source = (RuleNode)edge.source();
        this.target = (RuleNode)edge.target();
        this.selfEdge = this.source == this.target;
        this.boundEdges = Collections.singleton(edge);
        this.boundNodes = new HashSet<RuleNode>();
        this.boundNodes.add((RuleNode)edge.source());
        this.boundNodes.add((RuleNode)edge.target());
        RuleLabel label = (RuleLabel)edge.label();
        this.labelAutomaton = label.getAutomaton(typeGraph);
        this.edgeExpr = label.getMatchExpr();
        this.boundVars = label.getMatchExpr().boundVarSet();
        this.allVars = label.getMatchExpr().allVarSet();
        this.neededVars = new HashSet<LabelVar>(this.allVars);
        this.neededVars.removeAll(this.boundVars);
    }

    @Override
    public final SearchItem.Record createRecord(PlanSearchStrategy.Search search) {
        if (this.isSingular(search)) {
            return this.createSingularRecord(search);
        }
        return this.createMultipleRecord(search);
    }

    @Override
    public int compareTo(SearchItem item) {
        int result = super.compareTo(item);
        if (result != 0) {
            return result;
        }
        RegExprEdgeSearchItem other = (RegExprEdgeSearchItem)item;
        return EdgeComparator.instance().compare(this.edge, other.edge);
    }

    @Override
    int computeHashCode() {
        return super.computeHashCode() + 31 * this.edge.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RegExprEdgeSearchItem other = (RegExprEdgeSearchItem)obj;
        return this.edge.equals(other.edge);
    }

    @Override
    int getRating() {
        return -this.labelAutomaton.size();
    }

    @Override
    public Collection<LabelVar> needsVars() {
        return this.neededVars;
    }

    @Override
    public Collection<LabelVar> bindsVars() {
        return this.boundVars;
    }

    public RegExpr getEdgeExpr() {
        return this.edgeExpr;
    }

    @Override
    public Collection<? extends RuleEdge> bindsEdges() {
        return this.boundEdges;
    }

    @Override
    public Collection<? extends RuleNode> bindsNodes() {
        return this.boundNodes;
    }

    @Override
    public void activate(PlanSearchStrategy strategy) {
        this.sourceFound = strategy.isNodeFound(this.source);
        this.sourceIx = strategy.getNodeIx(this.source);
        if (this.selfEdge) {
            this.targetFound = this.sourceFound;
            this.targetIx = this.sourceIx;
        } else {
            this.targetFound = strategy.isNodeFound(this.target);
            this.targetIx = strategy.getNodeIx(this.target);
        }
        this.varIxMap = new HashMap<LabelVar, Integer>();
        this.prematchedVars = new HashSet<LabelVar>();
        for (LabelVar var : this.allVars) {
            assert (strategy.isVarFound(var));
            this.prematchedVars.add(var);
            this.varIxMap.put(var, strategy.getVarIx(var));
        }
    }

    boolean isSingular(PlanSearchStrategy.Search search) {
        boolean targetSingular;
        boolean sourceSingular = this.sourceFound || search.getNodeSeed(this.sourceIx) != null;
        boolean bl = targetSingular = this.targetFound || search.getNodeSeed(this.targetIx) != null;
        return sourceSingular && targetSingular;
    }

    AbstractSearchItem.SingularRecord createSingularRecord(PlanSearchStrategy.Search search) {
        return new RegExprEdgeSingularRecord(search);
    }

    AbstractSearchItem.MultipleRecord<RegAut.Result> createMultipleRecord(PlanSearchStrategy.Search search) {
        return new RegExprEdgeMultipleRecord(search, this.sourceIx, this.targetIx, this.sourceFound, this.targetFound);
    }

    public String toString() {
        return String.format("Find %s--%s->%s", this.source, this.edgeExpr, this.target);
    }

    private class RegExprEdgeMultipleRecord
    extends AbstractSearchItem.MultipleRecord<RegAut.Result> {
        private final int sourceIx;
        private final int targetIx;
        private final boolean sourceFound;
        private final boolean targetFound;
        private HostNode sourcePreMatch;
        private HostNode targetPreMatch;
        private HostNode sourceFind;
        private HostNode targetFind;

        RegExprEdgeMultipleRecord(PlanSearchStrategy.Search search, int sourceIx, int targetIx, boolean sourceFound, boolean targetFound) {
            super(search);
            this.sourceIx = sourceIx;
            this.targetIx = targetIx;
            this.sourceFound = sourceFound;
            this.targetFound = targetFound;
            assert (RegExprEdgeSearchItem.this.varIxMap.keySet().containsAll(RegExprEdgeSearchItem.this.neededVars));
        }

        @Override
        public void initialise(HostGraph host) {
            super.initialise(host);
            this.sourcePreMatch = this.search.getNodeSeed(this.sourceIx);
            this.targetPreMatch = this.search.getNodeSeed(this.targetIx);
        }

        @Override
        void init() {
            this.sourceFind = this.sourcePreMatch;
            if (this.sourceFind == null && this.sourceFound) {
                this.sourceFind = this.search.getNode(this.sourceIx);
                assert (this.sourceFind != null) : String.format("Source node not found", new Object[0]);
            }
            this.targetFind = this.targetPreMatch;
            if (this.targetFind == null && this.targetFound) {
                this.targetFind = this.search.getNode(this.targetIx);
                assert (this.targetFind != null) : String.format("Target node not found", new Object[0]);
            }
            Valuation valuation = new Valuation();
            for (LabelVar var : RegExprEdgeSearchItem.this.prematchedVars) {
                TypeElement image = this.search.getVar(RegExprEdgeSearchItem.this.varIxMap.get(var));
                assert (image != null);
                valuation.put(var, image);
            }
            Set<RegAut.Result> matches = RegExprEdgeSearchItem.this.labelAutomaton.getMatches(this.host, this.sourceFind, this.targetFind, valuation);
            this.imageIter = matches.iterator();
        }

        @Override
        boolean write(RegAut.Result image) {
            boolean result = true;
            HostNode source = (HostNode)image.one();
            if (this.sourceFind == null) {
                this.rollBackTargetImage();
                if (!this.search.putNode(this.sourceIx, source)) {
                    result = false;
                }
            }
            if (result) {
                HostNode target = (HostNode)image.two();
                if (RegExprEdgeSearchItem.this.selfEdge ? target != source : this.targetFind == null && !this.search.putNode(this.targetIx, target)) {
                    return false;
                }
            }
            return result;
        }

        @Override
        void erase() {
            if (this.sourceFind == null) {
                this.search.putNode(this.sourceIx, null);
            }
            if (this.targetFind == null) {
                this.search.putNode(this.targetIx, null);
            }
        }

        private void rollBackTargetImage() {
            if (this.targetFind == null && !RegExprEdgeSearchItem.this.selfEdge) {
                this.search.putNode(this.targetIx, null);
            }
        }

        public String toString() {
            return String.valueOf(RegExprEdgeSearchItem.this.toString()) + " = [" + this.sourceFind + ", " + this.targetFind + "]";
        }
    }

    private class RegExprEdgeSingularRecord
    extends AbstractSearchItem.SingularRecord {
        private HostNode sourcePreMatch;
        private HostNode targetPreMatch;

        RegExprEdgeSingularRecord(PlanSearchStrategy.Search search) {
            super(search);
            assert (RegExprEdgeSearchItem.this.varIxMap.keySet().containsAll(RegExprEdgeSearchItem.this.needsVars()));
        }

        @Override
        public void initialise(HostGraph host) {
            super.initialise(host);
            this.sourcePreMatch = this.search.getNodeSeed(RegExprEdgeSearchItem.this.sourceIx);
            this.targetPreMatch = this.search.getNodeSeed(RegExprEdgeSearchItem.this.targetIx);
        }

        @Override
        boolean find() {
            Valuation valuation = new Valuation();
            for (LabelVar var : RegExprEdgeSearchItem.this.prematchedVars) {
                TypeElement image = this.search.getVar(RegExprEdgeSearchItem.this.varIxMap.get(var));
                assert (image != null);
                valuation.put(var, image);
            }
            return !this.computeRelation(valuation).isEmpty();
        }

        @Override
        void erase() {
        }

        @Override
        boolean write() {
            return true;
        }

        private Set<RegAut.Result> computeRelation(Valuation valuation) {
            HostNode targetFind;
            HostNode sourceFind = this.sourcePreMatch;
            if (sourceFind == null && RegExprEdgeSearchItem.this.sourceFound) {
                sourceFind = this.search.getNode(RegExprEdgeSearchItem.this.sourceIx);
            }
            if ((targetFind = this.targetPreMatch) == null && RegExprEdgeSearchItem.this.targetFound) {
                targetFind = this.search.getNode(RegExprEdgeSearchItem.this.targetIx);
            }
            return RegExprEdgeSearchItem.this.labelAutomaton.getMatches(this.host, sourceFind, targetFind, valuation);
        }

        @Override
        public String toString() {
            return String.valueOf(RegExprEdgeSearchItem.this.toString()) + ": " + this.state.isWritten();
        }
    }
}

