/*
 * Decompiled with CFR 0.152.
 */
package groove.match.plan;

import groove.grammar.Condition;
import groove.grammar.rule.Anchor;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleNode;
import groove.match.plan.AbstractSearchItem;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class SearchPlan
extends ArrayList<AbstractSearchItem> {
    private final Condition condition;
    private final Anchor seed;
    private final List<Integer> dependencies = new ArrayList<Integer>();
    private final boolean injective;

    public SearchPlan(Condition condition, Anchor seed, boolean injective) {
        this.condition = condition;
        this.injective = injective;
        this.seed = seed;
    }

    public final Condition getCondition() {
        return this.condition;
    }

    public final Anchor getSeed() {
        return this.seed;
    }

    @Override
    public boolean add(AbstractSearchItem e) {
        int position = this.size();
        boolean result = super.add(e);
        int depend = -1;
        HashSet<RuleNode> usedNodes = new HashSet<RuleNode>(e.needsNodes());
        usedNodes.addAll(e.bindsNodes());
        HashSet<LabelVar> usedVars = new HashSet<LabelVar>(e.needsVars());
        usedVars.addAll(e.bindsVars());
        int i = 0;
        while (i < position) {
            if (usedNodes.removeAll(((AbstractSearchItem)this.get(i)).bindsNodes()) | usedVars.removeAll(((AbstractSearchItem)this.get(i)).bindsVars())) {
                depend = i;
            }
            ++i;
        }
        if (this.injective) {
            HashSet<? extends RuleNode> boundNodes = new HashSet<RuleNode>();
            BitSet bindsNewNodes = new BitSet();
            int i2 = 0;
            while (i2 <= position) {
                bindsNewNodes.set(i2, boundNodes.addAll(((AbstractSearchItem)this.get(i2)).bindsNodes()));
                ++i2;
            }
            if (bindsNewNodes.get(position) || e.isTestsNodes()) {
                i2 = 0;
                while (i2 < position) {
                    if (bindsNewNodes.get(i2)) {
                        depend = i2;
                    }
                    ++i2;
                }
            }
        }
        assert (this.areDisjoint(usedNodes, e.needsNodes())) : String.format("Required node(s) %s not all bound in search plan %s", e.needsNodes(), this);
        assert (this.areDisjoint(usedVars, e.needsVars())) : String.format("Required label variable(s) %s not all bound in search plan %s", e.needsVars(), this);
        this.dependencies.add(depend);
        return result;
    }

    private <X> boolean areDisjoint(Collection<X> set1, Collection<X> set2) {
        HashSet<X> copy = new HashSet<X>(set1);
        return !copy.removeAll(set2);
    }

    @Override
    public AbstractSearchItem set(int index, AbstractSearchItem element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, AbstractSearchItem element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractSearchItem remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends AbstractSearchItem> c) {
        throw new UnsupportedOperationException();
    }

    public int getDependency(int i) {
        return this.dependencies.get(i);
    }

    public boolean isInjective() {
        return this.injective;
    }
}

