/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.grammar.rule.RuleElement;
import groove.grammar.rule.RuleNode;
import groove.grammar.type.TypeNode;
import groove.match.rete.AbstractReteMatch;
import groove.match.rete.NodeChecker;
import groove.match.rete.ReteNetwork;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.ReteSimpleMatch;
import groove.match.rete.ReteStateSubscriber;
import groove.util.Reporter;
import groove.util.collect.TreeHashSet;
import java.util.List;

public class DefaultNodeChecker
extends NodeChecker
implements ReteStateSubscriber {
    private HostNodeSet ondemandBuffer = new HostNodeSet();
    private TreeHashSet<ReteSimpleMatch> memory = new TreeHashSet();
    final boolean sharpType;
    final TypeNode type;
    protected static final Reporter reporter = Reporter.register(NodeChecker.class);
    protected static final Reporter receiveNodeReporter = reporter.register("receiveNode(node, action)");

    public DefaultNodeChecker(ReteNetwork network, RuleNode node) {
        super(network);
        this.pattern[0] = node;
        this.type = node.getType();
        this.sharpType = node.isSharp() || this.type.getSubtypes().size() == 1;
        this.getOwner().getState().subscribe(this);
    }

    public void receiveNode(HostNode node, ReteNetworkNode.Action action) {
        receiveNodeReporter.start();
        if (this.checkType(node)) {
            if (!this.getOwner().isInOnDemandMode()) {
                this.sendDownReceivedNode(node, action);
            } else if (action == ReteNetworkNode.Action.REMOVE && !this.ondemandBuffer.contains(node)) {
                this.sendDownReceivedNode(node, action);
            } else {
                this.bufferReceivedNode(node, action);
            }
        }
        receiveNodeReporter.stop();
    }

    private boolean checkType(HostNode image) {
        return this.type.subsumes(image.getType(), this.sharpType);
    }

    private void sendDownReceivedNode(HostNode node, ReteNetworkNode.Action action) {
        ReteSimpleMatch m = new ReteSimpleMatch((ReteNetworkNode)this, node, this.getOwner().isInjective());
        if (action == ReteNetworkNode.Action.ADD) {
            assert (!this.memory.contains(m));
            this.memory.add(m);
            this.passDownMatchToSuccessors(m);
        } else if (this.memory.contains(m)) {
            ReteSimpleMatch m1 = m;
            m = this.memory.put(m);
            this.memory.remove(m1);
            m.dominoDelete(null);
        }
    }

    private void bufferReceivedNode(HostNode node, ReteNetworkNode.Action action) {
        if (action == ReteNetworkNode.Action.REMOVE) {
            this.ondemandBuffer.remove(node);
        } else {
            this.ondemandBuffer.add(node);
            this.invalidate();
        }
    }

    @Override
    public boolean equals(ReteNetworkNode node) {
        return node != null && node instanceof DefaultNodeChecker && ((DefaultNodeChecker)node).getType().equals(this.getType());
    }

    @Override
    public int size() {
        return this.pattern.length;
    }

    @Override
    public RuleElement[] getPattern() {
        return this.pattern;
    }

    @Override
    public boolean demandUpdate() {
        boolean result;
        boolean bl = result = this.ondemandBuffer.size() > 0;
        if (!this.isUpToDate()) {
            if (this.getOwner().isInOnDemandMode()) {
                for (HostNode n : this.ondemandBuffer) {
                    this.sendDownReceivedNode(n, ReteNetworkNode.Action.ADD);
                }
                this.ondemandBuffer.clear();
            }
            this.setUpToDate(true);
        }
        return result;
    }

    @Override
    public void clear() {
        this.ondemandBuffer.clear();
        this.memory.clear();
    }

    @Override
    public List<? extends Object> initialize() {
        return null;
    }

    @Override
    public int demandOneMatch() {
        int result = this.ondemandBuffer.size();
        if (this.getOwner().isInOnDemandMode() && !this.isUpToDate() && result > 0) {
            HostNode n = (HostNode)this.ondemandBuffer.iterator().next();
            this.ondemandBuffer.remove(n);
            this.sendDownReceivedNode(n, ReteNetworkNode.Action.ADD);
            this.setUpToDate(this.ondemandBuffer.size() == 0);
            result = 1;
        }
        return result;
    }

    @Override
    public void receive(ReteNetworkNode source, int repeatIndex, AbstractReteMatch subgraph) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBegin() {
    }

    @Override
    public void updateEnd() {
    }

    @Override
    public boolean canBeStaticallyMappedTo(RuleNode node) {
        return this.getNode().getType() == node.getType();
    }

    public TypeNode getType() {
        return this.type;
    }
}

