/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleElement;
import groove.grammar.rule.RuleNode;
import groove.match.rete.LookupEntry;
import groove.match.rete.ReteNetworkNode;
import java.util.HashMap;

public class LookupTable {
    private final HashMap<RuleNode, LookupEntry> nodeTable = new HashMap();
    private final HashMap<RuleEdge, Integer> edgeTable = new HashMap();

    public LookupTable(ReteNetworkNode nnode) {
        RuleElement[] pattern = nnode.getPattern();
        int i = 0;
        while (i < pattern.length) {
            RuleElement elem = pattern[i];
            if (elem instanceof RuleNode) {
                this.nodeTable.put((RuleNode)elem, new LookupEntry(i, LookupEntry.Role.NODE));
            } else if (pattern[i] instanceof RuleEdge) {
                RuleEdge edge = (RuleEdge)elem;
                this.edgeTable.put(edge, i);
                this.nodeTable.put((RuleNode)edge.source(), new LookupEntry(i, LookupEntry.Role.SOURCE));
                this.nodeTable.put((RuleNode)edge.target(), new LookupEntry(i, LookupEntry.Role.TARGET));
            }
            ++i;
        }
    }

    public int getEdge(RuleEdge e) {
        Integer result = this.edgeTable.get(e);
        return result == null ? -1 : result;
    }

    public LookupEntry getNode(RuleNode n) {
        return this.nodeTable.get(n);
    }
}

