/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.grammar.rule.RuleElement;
import groove.match.rete.AbstractPathChecker;
import groove.match.rete.AbstractReteMatch;
import groove.match.rete.DominoEventListener;
import groove.match.rete.ReteNetwork;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.RetePathMatch;
import groove.match.rete.ReteSimpleMatch;
import groove.match.rete.SubgraphCheckerNode;
import groove.util.collect.TreeHashSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class NegativeFilterSubgraphCheckerNode<LeftMatchType extends AbstractReteMatch, RightMatchType extends AbstractReteMatch>
extends SubgraphCheckerNode<LeftMatchType, RightMatchType> {
    private BidirectionalInhibitionMap inhibitionMap = new BidirectionalInhibitionMap();

    public NegativeFilterSubgraphCheckerNode(ReteNetwork network, ReteNetwork.ReteStaticMapping left, ReteNetwork.ReteStaticMapping right, boolean keepPrefix) {
        super(network, left, right, keepPrefix);
    }

    @Override
    protected void copyPatternsFromAntecedents() {
        RuleElement[] leftAntecedentPattern = this.getAntecedents().get(0).getPattern();
        this.pattern = new RuleElement[leftAntecedentPattern.length];
        int i = 0;
        while (i < leftAntecedentPattern.length) {
            this.pattern[i] = leftAntecedentPattern[i];
            ++i;
        }
    }

    @Override
    protected void selectJoinStrategy(ReteNetwork.ReteStaticMapping left, ReteNetwork.ReteStaticMapping right) {
        if (!(left.getNNode() instanceof AbstractPathChecker) && right.getNNode() instanceof AbstractPathChecker) {
            this.joinStrategy = new SubgraphCheckerNode.AbstractJoinWithPathStrategy<ReteSimpleMatch>((SubgraphCheckerNode)this){

                @Override
                public AbstractReteMatch construct(ReteSimpleMatch left, RetePathMatch right) {
                    if (!$assertionsDisabled && right != null) {
                        throw new AssertionError();
                    }
                    return new ReteSimpleMatch((ReteNetworkNode)this.subgraphChecker, this.subgraphChecker.getOwner().isInjective(), left);
                }
            };
        } else if (left.getNNode() instanceof AbstractPathChecker && right.getNNode() instanceof AbstractPathChecker) {
            this.joinStrategy = new SubgraphCheckerNode.AbstractJoinWithPathStrategy<RetePathMatch>((SubgraphCheckerNode)this){

                @Override
                public AbstractReteMatch construct(RetePathMatch left, RetePathMatch right) {
                    if (!$assertionsDisabled && right != null) {
                        throw new AssertionError();
                    }
                    return new ReteSimpleMatch((ReteNetworkNode)this.subgraphChecker, this.subgraphChecker.getOwner().isInjective(), left);
                }
            };
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void receive(ReteNetworkNode source, int repeatIndex, AbstractReteMatch subgraph) {
        this.receiveAndProcess(source, repeatIndex == 0, subgraph);
    }

    @Override
    public boolean demandUpdate() {
        boolean result = false;
        if (!this.isUpToDate()) {
            for (ReteNetworkNode nnode : this.getAntecedents()) {
                boolean bl = result = result || nnode.demandUpdate();
            }
            this.setUpToDate(true);
        }
        return result;
    }

    @Override
    protected boolean unbufferMatch(ReteNetworkNode source, boolean first, AbstractReteMatch subgraph) {
        return false;
    }

    @Override
    public int demandOneMatch() {
        this.demandUpdate();
        return 0;
    }

    @Override
    protected int receiveAndProcess(ReteNetworkNode source, boolean first, AbstractReteMatch subgraph) {
        int result = 0;
        result = this.isLeftAntecedent(source, first) ? this.receivePositiveMatch(subgraph) : this.receiveNegativeMatch(source, subgraph);
        return result;
    }

    private int receiveNegativeMatch(ReteNetworkNode source, RightMatchType subgraph) {
        int result = 0;
        this.rightMemory.add(subgraph);
        ((AbstractReteMatch)subgraph).addContainerCollection(this.rightMemory);
        ((AbstractReteMatch)subgraph).addDominoListener(new DominoEventListener(){

            @Override
            public void matchRemoved(AbstractReteMatch match) {
                NegativeFilterSubgraphCheckerNode.this.negativeMatchRemoved(match);
            }
        });
        for (AbstractReteMatch positiveMatch : this.leftMemory) {
            if (!this.joinStrategy.test(positiveMatch, subgraph)) continue;
            if (this.inhibitionMap.getInhibitorsOf(positiveMatch).size() == 0) {
                positiveMatch.dominoDeleteAfter();
            }
            this.inhibitionMap.add((AbstractReteMatch)subgraph, positiveMatch);
            ++result;
        }
        return result;
    }

    private void negativeMatchRemoved(RightMatchType negativeMatch) {
        Set<AbstractReteMatch> positiveMatches = this.inhibitionMap.removeInhibitor((AbstractReteMatch)negativeMatch);
        if (positiveMatches != null) {
            for (AbstractReteMatch positiveMatch : positiveMatches) {
                if (this.inhibitionMap.getInhibitorsOf(positiveMatch).size() != 0) continue;
                assert (this.leftMemory.contains(positiveMatch));
                AbstractReteMatch combined = this.joinStrategy.construct(positiveMatch, null);
                if (combined == null) continue;
                this.passDownMatchToSuccessors(combined);
            }
        }
    }

    private void positiveMatchRemoved(RightMatchType match) {
        this.inhibitionMap.removePositiveMatch((AbstractReteMatch)match);
    }

    private int receivePositiveMatch(LeftMatchType subgraph) {
        int result = 0;
        this.leftMemory.add(subgraph);
        ((AbstractReteMatch)subgraph).addContainerCollection(this.leftMemory);
        ((AbstractReteMatch)subgraph).addDominoListener(new DominoEventListener(){

            @Override
            public void matchRemoved(AbstractReteMatch match) {
                NegativeFilterSubgraphCheckerNode.this.positiveMatchRemoved(match);
            }
        });
        boolean canBePassedDown = true;
        for (AbstractReteMatch negativeMatch : this.rightMemory) {
            if (!this.joinStrategy.test(subgraph, negativeMatch)) continue;
            canBePassedDown = false;
            this.inhibitionMap.add(negativeMatch, (AbstractReteMatch)subgraph);
        }
        if (canBePassedDown) {
            result = 1;
            AbstractReteMatch combined = this.joinStrategy.construct(subgraph, null);
            this.passDownMatchToSuccessors(combined);
        }
        return result;
    }

    @Override
    public String toString() {
        return super.toString().replaceAll("Subgraph Checker", "Negative Filter");
    }

    protected class BidirectionalInhibitionMap {
        private HashMap<AbstractReteMatch, Set<AbstractReteMatch>> positiveToNegative = new HashMap();
        private HashMap<AbstractReteMatch, Set<AbstractReteMatch>> negativeToPositive = new HashMap();

        protected BidirectionalInhibitionMap() {
        }

        public void add(AbstractReteMatch inhibitor, AbstractReteMatch inhibited) {
            Set<AbstractReteMatch> inhibitorSet = this.positiveToNegative.get(inhibited);
            if (inhibitorSet == null) {
                inhibitorSet = new TreeHashSet<AbstractReteMatch>();
                this.positiveToNegative.put(inhibited, inhibitorSet);
            }
            inhibitorSet.add(inhibitor);
            Set<AbstractReteMatch> inhibitedSet = this.negativeToPositive.get(inhibitor);
            if (inhibitedSet == null) {
                inhibitedSet = new TreeHashSet<AbstractReteMatch>();
                this.negativeToPositive.put(inhibitor, inhibitedSet);
            }
            inhibitedSet.add(inhibited);
        }

        public Set<AbstractReteMatch> getInhibitedBy(AbstractReteMatch inhibitor) {
            assert (inhibitor != null);
            Set<AbstractReteMatch> result = this.negativeToPositive.get(inhibitor);
            if (result == null) {
                result = Collections.emptySet();
            }
            return result;
        }

        public Set<AbstractReteMatch> getInhibitorsOf(AbstractReteMatch positive) {
            assert (positive != null);
            Set<AbstractReteMatch> result = this.positiveToNegative.get(positive);
            if (result == null) {
                result = Collections.emptySet();
            }
            return result;
        }

        public boolean isInhibited(AbstractReteMatch positiveMatch) {
            return this.positiveToNegative.containsKey(positiveMatch);
        }

        public Set<AbstractReteMatch> removeInhibitor(AbstractReteMatch inhibitor) {
            Set<AbstractReteMatch> inhibitedPositiveMatches = this.negativeToPositive.get(inhibitor);
            if (inhibitedPositiveMatches != null) {
                for (AbstractReteMatch positiveMatch : inhibitedPositiveMatches) {
                    Set<AbstractReteMatch> s = this.positiveToNegative.get(positiveMatch);
                    boolean b = s.remove(inhibitor);
                    assert (b);
                    if (s.size() != 0) continue;
                    this.positiveToNegative.remove(positiveMatch);
                }
                this.negativeToPositive.remove(inhibitor);
            }
            return inhibitedPositiveMatches;
        }

        public void removePositiveMatch(AbstractReteMatch positive) {
            Set<AbstractReteMatch> inhibitors = this.positiveToNegative.get(positive);
            if (inhibitors != null) {
                this.positiveToNegative.remove(positive);
                for (AbstractReteMatch negative : inhibitors) {
                    Set<AbstractReteMatch> otherPositives = this.negativeToPositive.get(negative);
                    assert (otherPositives != null);
                    otherPositives.remove(positive);
                    if (otherPositives.size() != 0) continue;
                    this.negativeToPositive.remove(negative);
                }
            }
        }
    }
}

