/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.grammar.rule.RuleElement;
import groove.match.rete.AbstractReteMatch;
import groove.match.rete.LookupTable;
import groove.match.rete.ReteNetwork;
import java.util.ArrayList;
import java.util.List;

public abstract class ReteNetworkNode {
    private List<ReteNetworkNode> successors;
    private ReteNetwork owner;
    private ArrayList<ReteNetworkNode> antecedents = new ArrayList();
    private LookupTable patternLookupTable;
    private boolean isUpToDate = true;

    public abstract RuleElement[] getPattern();

    public LookupTable getPatternLookupTable() {
        if (this.patternLookupTable == null && this.getPattern() != null) {
            this.patternLookupTable = new LookupTable(this);
        }
        return this.patternLookupTable;
    }

    public ReteNetworkNode(ReteNetwork network) {
        this.owner = network;
        this.successors = new ArrayList<ReteNetworkNode>();
    }

    public void addSuccessor(ReteNetworkNode suc) {
        this.getSuccessors().add(suc);
    }

    public List<ReteNetworkNode> getSuccessors() {
        return this.successors;
    }

    public abstract boolean equals(ReteNetworkNode var1);

    public abstract int size();

    public abstract boolean demandUpdate();

    public abstract int demandOneMatch();

    public void forceFlush() {
        this.demandUpdate();
        for (ReteNetworkNode nnode : this.getSuccessors()) {
            nnode.forceFlush();
        }
    }

    protected boolean isAlreadySuccessor(ReteNetworkNode nnode) {
        boolean result = false;
        for (ReteNetworkNode n : this.getSuccessors()) {
            result = n.equals(nnode);
            if (result) break;
        }
        return result;
    }

    public ReteNetwork getOwner() {
        return this.owner;
    }

    public List<ReteNetworkNode> getAntecedents() {
        return this.antecedents;
    }

    public void addAntecedent(ReteNetworkNode nnode) {
        this.antecedents.add(nnode);
    }

    public boolean isUpToDate() {
        return this.isUpToDate;
    }

    public boolean invalidate() {
        boolean result = this.isUpToDate;
        this.isUpToDate = false;
        if (result) {
            for (ReteNetworkNode suc : this.getSuccessors()) {
                suc.invalidate();
            }
        }
        return result;
    }

    protected boolean setUpToDate(boolean newValue) {
        boolean result = this.isUpToDate;
        this.isUpToDate = newValue;
        return result;
    }

    public abstract void receive(ReteNetworkNode var1, int var2, AbstractReteMatch var3);

    protected void passDownMatchToSuccessors(AbstractReteMatch m) {
        ReteNetworkNode previous = null;
        int repeatedSuccessorIndex = 0;
        for (ReteNetworkNode n : this.getSuccessors()) {
            repeatedSuccessorIndex = n != previous ? 0 : repeatedSuccessorIndex + 1;
            n.receive(this, repeatedSuccessorIndex, m);
            previous = n;
        }
    }

    public static enum Action {
        ADD,
        REMOVE;

    }
}

