/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.grammar.Condition;
import groove.grammar.EdgeEmbargo;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostEdgeSet;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.grammar.rule.RuleToHostMap;
import groove.match.SearchStrategy;
import groove.match.TreeMatch;
import groove.match.ValueOracle;
import groove.match.rete.ConditionChecker;
import groove.match.rete.ReteNetwork;
import groove.match.rete.ReteSearchEngine;
import groove.match.rete.ReteSimpleMatch;
import groove.util.Visitor;
import java.util.ArrayList;
import java.util.Iterator;

public class ReteSearchStrategy
implements SearchStrategy {
    private final Condition condition;
    private final ReteSearchEngine engine;
    private final ValueOracle oracle;
    private ReteSearchStrategy[] subMatchers;

    public ReteSearchStrategy(ReteSearchEngine owner, Condition condition, ValueOracle oracle) {
        this.engine = owner;
        this.condition = condition;
        this.oracle = oracle;
        assert (condition != null);
    }

    @Override
    public ReteSearchEngine getEngine() {
        return this.engine;
    }

    @Override
    public ValueOracle getOracle() {
        return this.oracle;
    }

    @Override
    public <T> T traverse(HostGraph host, RuleToHostMap seedMap, Visitor<TreeMatch, T> visitor) {
        assert (host.getFactory().getTypeFactory().getGraph() == this.condition.getTypeGraph());
        ReteNetwork network = this.getEngine().getNetwork();
        assert (network != null);
        if (host != network.getState().getHostGraph()) {
            network.processGraph(host);
        }
        assert (this.graphShapesEqual(host, network.getState().getHostGraph()));
        ConditionChecker cc = network.getConditionCheckerNodeFor(this.getCondition());
        if (cc != null) {
            Iterator<ReteSimpleMatch> iter = seedMap != null && !seedMap.isEmpty() ? cc.getConflictSetIterator(seedMap) : cc.getConflictSetIterator();
            boolean cont = true;
            while (cont && iter.hasNext()) {
                cont = visitor.visit(this.createTreeMatch(iter.next(), host));
            }
        }
        return visitor.getResult();
    }

    private TreeMatch createTreeMatch(ReteSimpleMatch matchMap, HostGraph host) {
        RuleToHostMap patternMap = matchMap.toRuleToHostMap(host.getFactory());
        TreeMatch result = new TreeMatch(this.getCondition(), patternMap);
        ReteSearchStrategy[] subMatchers = this.getSubMatchers();
        if (subMatchers.length != 0) {
            int i = 0;
            while (i < subMatchers.length) {
                Condition subCondition = subMatchers[i].getCondition();
                Condition.Op subConditionOp = subCondition.getOp();
                if (subConditionOp != Condition.Op.NOT) {
                    Condition.Op op;
                    ArrayList subMatches = new ArrayList();
                    Visitor.Collector collector = Visitor.newCollector(subMatches);
                    subMatchers[i].traverse(host, patternMap, collector);
                    collector.dispose();
                    boolean noMatches = subMatches.isEmpty();
                    boolean positive = subCondition.isPositive();
                    switch (subConditionOp) {
                        case AND: {
                            op = noMatches ? Condition.Op.TRUE : Condition.Op.AND;
                            break;
                        }
                        case FORALL: {
                            op = noMatches ? (positive ? Condition.Op.FALSE : Condition.Op.TRUE) : Condition.Op.AND;
                            break;
                        }
                        case OR: {
                            op = noMatches ? Condition.Op.FALSE : Condition.Op.OR;
                            break;
                        }
                        case EXISTS: {
                            op = noMatches ? (positive ? Condition.Op.FALSE : Condition.Op.TRUE) : Condition.Op.OR;
                            break;
                        }
                        default: {
                            assert (false);
                            op = null;
                            throw new IllegalStateException();
                        }
                    }
                    TreeMatch subResult = new TreeMatch(op, subCondition);
                    subResult.getSubMatches().addAll(subMatches);
                    result.addSubMatch(subResult);
                }
                ++i;
            }
        }
        return result;
    }

    private synchronized boolean graphShapesEqual(HostGraph g1, HostGraph g2) {
        HostEdgeSet edges;
        boolean result = true;
        HostNodeSet nodes = new HostNodeSet(g1.nodeSet());
        for (HostNode n : nodes) {
            result = g2.nodeSet().contains(n);
            if (result) continue;
            System.out.println("------------------------ReteStrategy.graph comparison failed.--------------------------");
            System.out.println(String.format("Node %s in RETE-state does not exist in given host graph.", n.toString()));
            break;
        }
        if (result) {
            nodes = new HostNodeSet(g2.nodeSet());
            for (HostNode n : nodes) {
                result = g1.nodeSet().contains(n);
                if (result) continue;
                System.out.println("------------------------ReteStrategy.graph comparison failed.--------------------------");
                System.out.println(String.format("Node %s in given host graph does not exist in RETE-state graph.", n.toString()));
                break;
            }
        }
        if (result) {
            edges = new HostEdgeSet(g1.edgeSet());
            for (HostEdge e : edges) {
                result = g2.edgeSet().contains(e);
                if (result) continue;
                System.out.println("------------------------ReteStrategy.graph comparison failed.--------------------------");
                System.out.println(String.format("Edge %s in given RETE-state graph does not exist in given host graph.", e.toString()));
                break;
            }
        }
        if (result) {
            edges = new HostEdgeSet(g2.edgeSet());
            for (HostEdge e : edges) {
                result = g1.edgeSet().contains(e);
                if (result) continue;
                System.out.println("------------------------ReteStrategy.graph comparison failed.--------------------------");
                System.out.println(String.format("Edge %s in given host graph does not exist in RETE-state graph.", e.toString()));
                break;
            }
        }
        if (!result) {
            System.out.println("RETE host graph:");
            System.out.println(g1.toString());
            System.out.println("given host graph:");
            System.out.println(g2.toString());
        }
        return result;
    }

    private ReteSearchStrategy[] getSubMatchers() {
        if (this.subMatchers == null) {
            ArrayList<ReteSearchStrategy> result = new ArrayList<ReteSearchStrategy>(this.getCondition().getSubConditions().size());
            for (Condition subCondition : this.getCondition().getSubConditions()) {
                if (subCondition instanceof EdgeEmbargo) continue;
                result.add(new ReteSearchStrategy(this.getEngine(), subCondition, this.oracle));
            }
            this.subMatchers = result.toArray(new ReteSearchStrategy[result.size()]);
        }
        return this.subMatchers;
    }

    private final Condition getCondition() {
        return this.condition;
    }
}

