/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.grammar.host.HostEdge;
import groove.grammar.host.HostFactory;
import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.grammar.host.ValueNode;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleElement;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.RuleToHostMap;
import groove.grammar.rule.Valuation;
import groove.match.rete.AbstractReteMatch;
import groove.match.rete.LookupEntry;
import groove.match.rete.QuantifierCountChecker;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.RetePathMatch;

public class ReteSimpleMatch
extends AbstractReteMatch {
    private Object[] units;
    protected HostNodeSet nodes = null;
    private RuleToHostMap equivalentMap = null;

    public ReteSimpleMatch(ReteNetworkNode origin, boolean injective, AbstractReteMatch subMatch) {
        this(origin, injective);
        this.specialPrefix = subMatch.specialPrefix;
        assert (origin.getPattern().length == subMatch.getOrigin().getPattern().length);
        this.units = subMatch.getAllUnits();
        this.valuation = subMatch.valuation;
        subMatch.addSuperMatch(this);
    }

    public ReteSimpleMatch(ReteNetworkNode origin, boolean injective, AbstractReteMatch subMatch, Object[] unitsToAppend) {
        this(origin, injective);
        Object[] subMatchUnits = subMatch.getAllUnits();
        assert (unitsToAppend.length + subMatchUnits.length == origin.getPattern().length);
        this.specialPrefix = subMatch.specialPrefix;
        this.valuation = subMatch.valuation;
        subMatch.addSuperMatch(this);
        this.units = new Object[subMatchUnits.length + unitsToAppend.length];
        int i = 0;
        while (i < subMatchUnits.length) {
            this.units[i] = subMatchUnits[i];
            ++i;
        }
        i = 0;
        while (i < unitsToAppend.length) {
            this.units[i + subMatchUnits.length] = unitsToAppend[i];
            ++i;
        }
    }

    public ReteSimpleMatch(ReteNetworkNode origin, boolean injective) {
        super(origin, injective);
        this.units = new Object[origin.getPattern().length];
    }

    public ReteSimpleMatch(ReteNetworkNode origin, HostEdge match, boolean injective) {
        this(origin, injective);
        this.units[0] = match;
    }

    public ReteSimpleMatch(ReteNetworkNode origin, HostEdge match, LabelVar variable, boolean injective) {
        this(origin, injective);
        this.units[0] = match;
        this.valuation = new Valuation();
        this.valuation.put(variable, match.getType());
    }

    public ReteSimpleMatch(ReteNetworkNode origin, HostNode match, boolean injective) {
        this(origin, injective);
        this.units[0] = match;
    }

    @Override
    public AbstractReteMatch getSpecialPrefix() {
        return this.specialPrefix;
    }

    @Override
    public Object[] getAllUnits() {
        return this.units;
    }

    @Override
    public int size() {
        return this.units.length;
    }

    public HostNode getNode(RuleNode n) {
        LookupEntry entry = this.getOrigin().getPatternLookupTable().getNode(n);
        return (HostNode)entry.lookup(this.units);
    }

    @Override
    public HostNodeSet getNodes() {
        if (this.nodes == null) {
            this.nodes = new HostNodeSet();
            int i = 0;
            while (i < this.units.length) {
                if (this.units[i] instanceof HostEdge) {
                    HostEdge e = (HostEdge)this.units[i];
                    this.nodes.add(e.source());
                    if (!e.source().equals(e.target())) {
                        this.nodes.add(e.target());
                    }
                } else {
                    this.nodes.add((HostNode)this.units[i]);
                }
                ++i;
            }
        }
        return this.nodes;
    }

    public HostEdge getEdge(RuleEdge e) {
        int index = this.getOrigin().getPatternLookupTable().getEdge(e);
        return index != -1 ? (HostEdge)this.units[index] : null;
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReteSimpleMatch)) {
            return false;
        }
        ReteSimpleMatch m = (ReteSimpleMatch)o;
        if (this.hashCode() != m.hashCode()) {
            return false;
        }
        if (this.getOrigin() != m.getOrigin()) {
            return false;
        }
        Object[] thisList = this.getAllUnits();
        Object[] mList = m.getAllUnits();
        boolean bl = result = mList.length == thisList.length;
        if (result) {
            int thisSize = this.size();
            int i = 0;
            while (i < thisSize) {
                if (thisList[i] != mList[i]) {
                    assert (!thisList[i].equals(mList[i]));
                    result = false;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public boolean isContainedAt(int index, ReteSimpleMatch m) {
        boolean result = true;
        int mSize = m.size();
        Object[] units = this.getAllUnits();
        int i = 0;
        while (i < mSize) {
            if (!this.units[i + index].equals(units[i])) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    public RuleToHostMap toRuleToHostMap(HostFactory factory) {
        if (this.equivalentMap == null) {
            this.equivalentMap = factory.createRuleToHostMap();
            RuleElement[] pattern = this.getOrigin().getPattern();
            int i = 0;
            while (i < this.units.length) {
                RuleEdge e1;
                Object e = this.units[i];
                if (e instanceof HostNode) {
                    this.equivalentMap.putNode((RuleNode)pattern[i], (HostNode)e);
                } else if (e instanceof HostEdge) {
                    e1 = (RuleEdge)pattern[i];
                    HostEdge e2 = (HostEdge)e;
                    this.equivalentMap.putEdge(e1, e2);
                    this.equivalentMap.putNode((RuleNode)e1.source(), e2.source());
                    this.equivalentMap.putNode((RuleNode)e1.target(), e2.target());
                } else {
                    e1 = (RuleEdge)pattern[i];
                    RetePathMatch m = (RetePathMatch)e;
                    this.equivalentMap.putNode((RuleNode)e1.source(), m.start());
                    this.equivalentMap.putNode((RuleNode)e1.target(), m.end());
                }
                ++i;
            }
            if (this.getValuation() != null) {
                this.equivalentMap.getValuation().putAll(this.getValuation());
            }
        }
        return this.equivalentMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ " + this.getOrigin().getPattern().toString() + ": ");
        int i = 0;
        while (i < this.units.length) {
            sb.append("[ " + this.units[i].toString() + "] ");
            ++i;
        }
        if (this.valuation != null) {
            sb.append(" |> " + this.valuation.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public static ReteSimpleMatch merge(ReteNetworkNode origin, AbstractReteMatch[] subMatches, boolean injective) {
        ReteSimpleMatch result = new ReteSimpleMatch(origin, injective);
        HostNodeSet nodes = injective ? new HostNodeSet() : null;
        Valuation valuation = AbstractReteMatch.getMergedValuation(subMatches);
        if (valuation != null) {
            int k = 0;
            int i = 0;
            while (i < subMatches.length) {
                Object[] subMatchUnits = subMatches[i].getAllUnits();
                if (injective) {
                    for (HostNode n : subMatches[i].getNodes()) {
                        if (nodes.put(n) == null) continue;
                        return null;
                    }
                }
                int j = 0;
                while (j < subMatchUnits.length) {
                    result.units[k++] = subMatchUnits[j];
                    ++j;
                }
                subMatches[i].addSuperMatch(result);
                ++i;
            }
            assert (k == origin.getPattern().length);
            result.valuation = valuation == emptyMap ? null : valuation;
        } else {
            result = null;
        }
        return result;
    }

    public static ReteSimpleMatch merge(ReteNetworkNode origin, AbstractReteMatch m1, AbstractReteMatch m2, boolean injective, boolean copyPrefix) {
        ReteSimpleMatch result = null;
        Valuation valuation = m1.getMergedValuation(m2);
        if (valuation != null) {
            result = new ReteSimpleMatch(origin, injective);
            Object[] units1 = m1.getAllUnits();
            Object[] units2 = m2.getAllUnits();
            if (copyPrefix) {
                AbstractReteMatch abstractReteMatch = result.specialPrefix = m1.specialPrefix != null ? m1.specialPrefix : m1;
            }
            assert (result.units.length == units1.length + units2.length);
            int i = 0;
            while (i < units1.length) {
                result.units[i] = units1[i];
                ++i;
            }
            while (i < result.units.length) {
                result.units[i] = units2[i - units1.length];
                ++i;
            }
            m1.addSuperMatch(result);
            m2.addSuperMatch(result);
            result.valuation = valuation != emptyMap ? valuation : null;
        }
        return result;
    }

    public static ReteSimpleMatch merge(ReteNetworkNode origin, ReteSimpleMatch m1, ReteSimpleMatch m2, boolean injective, boolean copyPrefix) {
        ReteSimpleMatch result = null;
        Valuation valuation = m1.getMergedValuation(m2);
        if (valuation != null) {
            Object[] m1Units = m1.getAllUnits();
            result = new ReteSimpleMatch(origin, injective);
            Object[] units2 = m2.getAllUnits();
            if (copyPrefix) {
                AbstractReteMatch abstractReteMatch = result.specialPrefix = m1.specialPrefix != null ? m1.specialPrefix : m1;
            }
            assert (result.units.length == m1Units.length + units2.length);
            int i = 0;
            while (i < m1Units.length) {
                result.units[i] = m1Units[i];
                ++i;
            }
            while (i < result.units.length) {
                result.units[i] = units2[i - m1Units.length];
                ++i;
            }
            result.hashCode();
            m1.addSuperMatch(result);
            m2.addSuperMatch(result);
            result.valuation = valuation != emptyMap ? valuation : null;
        }
        return result;
    }

    public static ReteSimpleMatch forge(ReteNetworkNode origin, boolean injective, AbstractReteMatch source) {
        ReteSimpleMatch result = new ReteSimpleMatch(origin, injective);
        result.specialPrefix = source.specialPrefix;
        assert (source.specialPrefix == null || origin.getPattern().length == source.specialPrefix.getOrigin().getPattern().length);
        result.units = source.getAllUnits();
        result.valuation = source.valuation;
        return result;
    }

    public static class ReteCountMatch
    extends ReteSimpleMatch {
        private final boolean dummy;

        public ReteCountMatch(ReteNetworkNode owner, HostNode[] anchors, ValueNode value) {
            super(owner, owner.getOwner().isInjective());
            Object[] myUnits = this.getAllUnits();
            assert (owner instanceof QuantifierCountChecker && anchors.length + 1 == owner.getPattern().length);
            this.dummy = false;
            int i = 0;
            while (i < anchors.length) {
                myUnits[i] = anchors[i];
                ++i;
            }
            myUnits[this.size() - 1] = value;
        }

        public ReteCountMatch(ReteNetworkNode owner, ValueNode value) {
            super(owner, owner.getOwner().isInjective());
            this.dummy = true;
            Object[] myUnits = this.getAllUnits();
            int i = 0;
            while (i < this.size() - 1) {
                myUnits[i] = value;
                ++i;
            }
            if (!value.getValue().equals(0)) {
                throw new IllegalArgumentException(String.format("The given value for the wildcard match must be zero. It is now %s", value.getValue().toString()));
            }
            myUnits[this.size() - 1] = value;
        }

        public boolean isDummy() {
            return this.dummy;
        }

        public ValueNode getValue() {
            return (ValueNode)this.getAllUnits()[this.size() - 1];
        }

        @Override
        public boolean equals(Object o) {
            if (o != null) {
                return o instanceof ReteCountMatch && this.getOrigin() == ((ReteCountMatch)o).getOrigin() && this.dummy == ((ReteCountMatch)o).dummy && this.getValue() == ((ReteCountMatch)o).getValue();
            }
            return false;
        }

        @Override
        public String toString() {
            return "Count match for " + ((QuantifierCountChecker)this.getOrigin()).getUniversalQuantifierChecker().getCondition().getName() + ". Value = " + this.getValue().toString();
        }

        public ReteSimpleMatch dummyMerge(ReteNetworkNode origin, AbstractReteMatch leftMatch, boolean copyPrefix, LookupEntry[] mergeLookupTable) {
            assert (this.dummy);
            ReteSimpleMatch result = new ReteSimpleMatch(origin, origin.getOwner().isInjective());
            Object[] resultUnits = result.getAllUnits();
            Object[] leftUnits = leftMatch.getAllUnits();
            Object[] myUnits = this.getAllUnits();
            int i = 0;
            while (i < leftUnits.length) {
                resultUnits[i] = leftUnits[i];
                ++i;
            }
            while (i < leftUnits.length + this.size() - 1) {
                LookupEntry pos = mergeLookupTable[i - leftUnits.length];
                resultUnits[i] = pos.lookup(leftUnits);
                ++i;
            }
            resultUnits[result.size() - 1] = myUnits[this.size() - 1];
            if (copyPrefix) {
                result.specialPrefix = leftMatch.specialPrefix != null ? leftMatch.specialPrefix : leftMatch;
            }
            result.hashCode();
            this.addSuperMatch(result);
            leftMatch.addSuperMatch(result);
            result.valuation = leftMatch.valuation;
            return result;
        }
    }
}

