/*
 * Decompiled with CFR 0.152.
 */
package groove.prolog.builtin;

import groove.annotation.Signature;
import groove.annotation.ToolTipBody;
import groove.annotation.ToolTipPars;
import groove.prolog.builtin.GroovePredicates;

public class TypePredicates
extends GroovePredicates {
    @Signature(value={"TypeGraph", "?"})
    @ToolTipBody(value={"Retrieves the composite type graph, which is the union of the individual type graphs."})
    @ToolTipPars(value={"Composite type graph object"})
    public void composite_type_graph_1() {
        this.s(":-build_in(composite_type_graph/1,'groove.prolog.builtin.type.Predicate_composite_type_graph').");
    }

    @Signature(value={"TypeGraph", "Label", "Label", "++?", "+?+"})
    @ToolTipBody(value={"Retrieves the direct subtype relation, as defined in a given type graph."})
    @ToolTipPars(value={"Type graph object", "Subtype label", "Supertype label"})
    public void direct_subtype_3() {
        this.s(":-build_in(direct_subtype/3,'groove.prolog.builtin.type.Predicate_direct_subtype').");
    }

    @Signature(value={"String", "Label", "+?", "?+"})
    @ToolTipBody(value={"Estabishes the relation between label text (of type String) and label object"})
    public void label_2() {
        this.s(":-build_in(label/2,'groove.prolog.builtin.type.Predicate_label').");
    }

    @Signature(value={"TypeGraph", "Label", "Label", "++?", "+?+"})
    @ToolTipBody(value={"Retrieves the recursively and transitively closed subtype relation, as defined in a given type graph."})
    @ToolTipPars(value={"Type graph object", "Subtype label", "Supertype label"})
    public void subtype_3() {
        this.s(":-build_in(subtype/3,'groove.prolog.builtin.type.Predicate_subtype').");
    }

    @Signature(value={"String", "?"})
    @ToolTipBody(value={"Cycles over the set of available (active) type graph names."})
    @ToolTipPars(value={"Name of an active type graph"})
    public void type_graph_name_1() {
        this.s(":-build_in(type_graph_name/1,'groove.prolog.builtin.type.Predicate_type_graph_name').");
    }

    @Signature(value={"TypeGraph", "String", "String", "++?", "+?+"})
    @ToolTipBody(value={"Retrieves the direct subtype relation, as defined in a given type graph.", "The type labels are given as Strings"})
    @ToolTipPars(value={"Type graph object", "Subtype label text", "Supertype label text"})
    public void direct_subtype_label_3() {
        this.s("direct_subtype_label(TG,A,B) :- label(A,AL), label(B,BL), direct_subtype(TG,AL,BL).");
    }

    @Signature(value={"TypeGraph", "String", "String", "++?", "+?+"})
    @ToolTipBody(value={"Retrieves the recursively and transitively closed subtype relation, as defined in a given type graph.", "The type labels are given as Strings"})
    @ToolTipPars(value={"Type graph object", "Subtype label text", "Supertype label text"})
    public void subtype_label_3() {
        this.s("subtype_label(TG,A,B) :- label(A,AL), label(B,BL), subtype(TG,AL,BL).");
    }
}

