/*
 * Decompiled with CFR 0.152.
 */
package groove.prolog.util;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.FloatTerm;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.JavaObjectTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.TermConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class TermConverter {
    public static Map<String, Object> convert(Map<String, VariableTerm> rawVars) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, VariableTerm> entry : rawVars.entrySet()) {
            if (entry.getKey().charAt(0) == '_') continue;
            result.put(entry.getKey(), TermConverter.convert((Term)entry.getValue()));
        }
        return result;
    }

    public static Object convert(Term value) {
        if ((value = value.dereference()) instanceof JavaObjectTerm) {
            return ((JavaObjectTerm)value).value;
        }
        if (value instanceof IntegerTerm) {
            return ((IntegerTerm)value).value;
        }
        if (value instanceof FloatTerm) {
            return ((FloatTerm)value).value;
        }
        if (value instanceof AtomTerm) {
            return ((AtomTerm)value).value;
        }
        if (value instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)value;
            if (ct.tag == TermConstants.listTag) {
                ArrayList<Object> compound;
                block10: {
                    compound = new ArrayList<Object>();
                    while (true) {
                        if ((value = ct.args[0].dereference()) != TermConstants.emptyListAtom) {
                            compound.add(TermConverter.convert(value));
                        }
                        if ((value = ct.args[1]) != null) {
                            value = value.dereference();
                        }
                        if (value == TermConstants.emptyListAtom) break block10;
                        if (!(value instanceof CompoundTerm) || ((CompoundTerm)value).tag != TermConstants.listTag) break;
                        ct = (CompoundTerm)value;
                    }
                    compound.add((Object)SpecialValue.ANONYMOUS_LIST_TAIL);
                }
                return compound;
            }
            if (ct.tag == CompoundTermTag.divide2) {
                return CompoundTermTag.get((CompoundTerm)ct).toString();
            }
        }
        return null;
    }

    public static enum SpecialValue {
        ANONYMOUS_LIST_TAIL;

    }
}

