/*
 * Decompiled with CFR 0.152.
 */
package groove.transform;

import groove.grammar.AnchorKind;
import groove.grammar.Rule;
import groove.grammar.host.AnchorValue;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostEdgeSet;
import groove.grammar.host.HostFactory;
import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.grammar.host.ValueNode;
import groove.grammar.rule.Anchor;
import groove.grammar.rule.AnchorKey;
import groove.grammar.rule.DefaultRuleNode;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.RuleToHostMap;
import groove.grammar.type.TypeLabel;
import groove.graph.Label;
import groove.graph.Node;
import groove.match.TreeMatch;
import groove.transform.AbstractRuleEvent;
import groove.transform.MergeMap;
import groove.transform.Proof;
import groove.transform.RuleEffect;
import groove.transform.RuleEvent;
import groove.util.Groove;
import groove.util.cache.CacheReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class BasicEvent
extends AbstractRuleEvent<Rule, SPOEventCache> {
    private final HostFactory hostFactory;
    private final AnchorValue[] anchorImage;
    private final List<List<HostNode>> freshNodeList;
    private static int freshNodeCount;
    public static final String ANCHOR_START = "(";
    public static final String ANCHOR_SEPARATOR = ",";
    public static final String ANCHOR_END = ")";
    private static final HostNodeSet EMPTY_NODE_SET;
    private static List<List<HostNode>> NO_REUSE_LIST;
    private static List<List<HostNode>> AGGRESIVE_REUSE_LIST;
    private static final CacheReference<SPOEventCache> reference;

    static {
        EMPTY_NODE_SET = new HostNodeSet(0);
        NO_REUSE_LIST = new ArrayList<List<HostNode>>();
        AGGRESIVE_REUSE_LIST = new ArrayList<List<HostNode>>();
        reference = CacheReference.newInstance(false);
    }

    public BasicEvent(Rule rule, RuleToHostMap anchorMap, RuleEvent.Reuse reuse) {
        super(reference, rule);
        assert (anchorMap != null) : String.format("Can't produce event for %s with null anchor map", rule.getFullName());
        rule.testFixed(true);
        this.anchorImage = this.computeAnchorImage(anchorMap);
        this.hostFactory = anchorMap.getFactory();
        switch (reuse) {
            case AGGRESSIVE: {
                this.freshNodeList = AGGRESIVE_REUSE_LIST;
                break;
            }
            case NONE: {
                this.freshNodeList = NO_REUSE_LIST;
                break;
            }
            default: {
                this.freshNodeList = this.createFreshNodeList();
            }
        }
    }

    @Override
    public RuleToHostMap getAnchorMap() {
        return ((SPOEventCache)this.getCache()).getAnchorMap();
    }

    @Override
    public String getAnchorImageString() {
        return Groove.toString(this.getAnchorImage(), ANCHOR_START, ANCHOR_END, ANCHOR_SEPARATOR);
    }

    public RuleToHostMap getCoanchorMap() {
        return ((SPOEventCache)this.getCache()).getCoanchorMap();
    }

    @Override
    RuleEvent.Reuse getReuse() {
        if (this.freshNodeList == NO_REUSE_LIST) {
            return RuleEvent.Reuse.NONE;
        }
        if (this.freshNodeList == AGGRESIVE_REUSE_LIST) {
            return RuleEvent.Reuse.AGGRESSIVE;
        }
        return RuleEvent.Reuse.EVENT;
    }

    @Override
    int computeEventHashCode() {
        int result = this.getRule().hashCode();
        AnchorValue[] anchorImage = this.getAnchorImage();
        int MAX_HASHED_ANCHOR_COUNT = 10;
        int hashedAnchorCount = Math.min(anchorImage.length, MAX_HASHED_ANCHOR_COUNT);
        int i = 0;
        while (i < hashedAnchorCount) {
            AnchorValue elem = anchorImage[i];
            if (elem != null) {
                result += elem.hashCode() << i;
            }
            ++i;
        }
        return result;
    }

    @Override
    boolean equalsEvent(RuleEvent obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BasicEvent)) {
            return false;
        }
        BasicEvent other = (BasicEvent)obj;
        if (!this.getRule().equals(obj.getRule())) {
            return false;
        }
        return Arrays.equals(this.getAnchorImage(), other.getAnchorImage());
    }

    @Override
    HostNode[] getArguments(HostNode[] addedNodes) {
        HostNode[] result;
        int size = ((Rule)this.getRule()).getSignature().size();
        if (size == 0) {
            result = AbstractRuleEvent.EMPTY_NODE_ARRAY;
        } else {
            result = new HostNode[size];
            int anchorSize = ((Rule)this.getRule()).getAnchor().size();
            AnchorValue[] anchorImage = this.getAnchorImage();
            int i = 0;
            while (i < size) {
                int binding = ((Rule)this.getRule()).getParBinding(i);
                HostNode argument = binding < anchorSize ? (HostNode)anchorImage[binding] : (addedNodes == null ? null : addedNodes[binding - anchorSize]);
                result[i] = argument;
                ++i;
            }
        }
        return result;
    }

    @Override
    protected Proof extractProof(TreeMatch match) {
        return new Proof(((Rule)this.getRule()).getCondition(), match.getPatternMap());
    }

    @Override
    public RuleEvent createEvent(Proof proof) {
        return proof.newEvent(null);
    }

    @Override
    public int compareTo(RuleEvent other) {
        int result = ((Rule)this.getRule()).compareTo(other.getRule());
        if (result != 0) {
            return result;
        }
        AnchorValue[] anchorImage = this.getAnchorImage();
        AnchorValue[] hisAnchorImage = ((BasicEvent)other).getAnchorImage();
        int upper = Math.min(anchorImage.length, hisAnchorImage.length);
        int i = 0;
        while (result == 0 && i < upper) {
            result = AnchorKind.compare(anchorImage[i], hisAnchorImage[i]);
            ++i;
        }
        if (result == 0) {
            return anchorImage.length - hisAnchorImage.length;
        }
        return result;
    }

    @Override
    public AnchorValue getAnchorImage(int i) {
        return this.getAnchorImage()[i];
    }

    AnchorValue[] getAnchorImage() {
        return this.anchorImage;
    }

    private AnchorValue[] computeAnchorImage(RuleToHostMap anchorMap) {
        Anchor anchor = ((Rule)this.getRule()).getAnchor();
        AnchorValue[] result = new AnchorValue[anchor.size()];
        int i = 0;
        while (i < result.length) {
            AnchorKey key = (AnchorKey)anchor.get(i);
            result[i] = anchorMap.get(key);
            assert (result[i] != null) : String.format("No image for %s in anchor map %s", key, anchorMap);
            ++i;
        }
        return result;
    }

    @Override
    public boolean conflicts(RuleEvent other) {
        boolean result;
        if (other instanceof BasicEvent) {
            result = false;
            Iterator myErasedEdgeIter = this.getErasedEdges().iterator();
            HostEdgeSet otherCreatedEdges = ((BasicEvent)other).getSimpleCreatedEdges();
            while (!result && myErasedEdgeIter.hasNext()) {
                result = otherCreatedEdges.contains(myErasedEdgeIter.next());
            }
            if (!result) {
                Iterator myCreatedEdgeIter = this.getSimpleCreatedEdges().iterator();
                HostEdgeSet otherErasedEdges = ((BasicEvent)other).getErasedEdges();
                while (!result && myCreatedEdgeIter.hasNext()) {
                    result = otherErasedEdges.contains(myCreatedEdgeIter.next());
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    public boolean disables(RuleEvent other) {
        boolean result = false;
        Set<AnchorValue> anchorImage = ((BasicEvent)other).getAnchorImageSet();
        Iterator nodeIter = this.getErasedNodes().iterator();
        while (!result && nodeIter.hasNext()) {
            result = anchorImage.contains(nodeIter.next());
        }
        Iterator edgeIter = this.getErasedEdges().iterator();
        while (!result && edgeIter.hasNext()) {
            result = anchorImage.contains(edgeIter.next());
        }
        return result;
    }

    private Set<AnchorValue> getAnchorImageSet() {
        return ((SPOEventCache)this.getCache()).getAnchorImageSet();
    }

    @Override
    public void recordEffect(RuleEffect record) {
        if (((Rule)this.getRule()).isModifying()) {
            if (((Rule)this.getRule()).getCreatorNodes().length > 0) {
                this.recordCreatedNodes(record);
            }
            if (record.getFragment() != RuleEffect.Fragment.NODE_CREATION) {
                if (((Rule)this.getRule()).getEraserNodes().length > 0) {
                    this.recordErasedNodes(record);
                }
                if (!((Rule)this.getRule()).getLhsMergeMap().isEmpty() || !((Rule)this.getRule()).getRhsMergeMap().isEmpty()) {
                    this.recordMergeMap(record);
                }
            }
            if (record.getFragment() == RuleEffect.Fragment.ALL) {
                if (((Rule)this.getRule()).getEraserEdges().length > 0) {
                    this.recordErasedEdges(record);
                }
                if (((Rule)this.getRule()).getCreatorEdges().length > 0) {
                    this.recordCreatedEdges(record);
                }
            }
        }
    }

    private void recordErasedNodes(RuleEffect record) {
        record.addErasedNodes(this.getErasedNodes());
    }

    private void recordErasedEdges(RuleEffect record) {
        record.addErasedEdges(this.getErasedEdges());
    }

    private void recordCreatedNodes(RuleEffect record) {
        RuleNode[] creatorNodes = ((Rule)this.getRule()).getCreatorNodes();
        if (record.isNodesInitialised()) {
            record.addCreatorNodes(creatorNodes);
        } else {
            HostNode[] createdNodes = this.getCreatedNodes(record.getSourceNodes(), record.getCreatedNodes());
            record.addCreatedNodes(creatorNodes, createdNodes);
        }
    }

    private void recordCreatedEdges(RuleEffect record) {
        HostEdgeSet simpleCreatedEdges = this.getSimpleCreatedEdges();
        record.addCreatedEdges(simpleCreatedEdges);
        Map<RuleNode, HostNode> createdNodeMap = record.getCreatedNodeMap();
        RuleToHostMap anchorMap = this.getAnchorMap();
        for (RuleEdge edge : ((Rule)this.getRule()).getComplexCreatorEdges()) {
            RuleNode target;
            HostNode targetImage;
            RuleNode source = (RuleNode)edge.source();
            HostNode sourceImage = (HostNode)anchorMap.getNode(source);
            if (sourceImage == null) {
                sourceImage = createdNodeMap.get(source);
                assert (sourceImage != null) : String.format("Event '%s': No image for %s", this, source);
            }
            if ((targetImage = (HostNode)anchorMap.getNode(target = (RuleNode)edge.target())) == null) {
                targetImage = createdNodeMap.get(target);
                assert (sourceImage != null) : String.format("Event '%s': No image for %s", this, target);
            }
            HostEdge image = this.getHostFactory().createEdge(sourceImage, (Label)anchorMap.mapLabel((Label)edge.label()), targetImage);
            record.addCreatedEdge(image);
        }
    }

    private void recordMergeMap(RuleEffect record) {
        MergeMap lhsMergeMap = ((SPOEventCache)this.getCache()).getMergeMap();
        Map<RuleNode, RuleNode> rhsMergers = ((Rule)this.getRule()).getRhsMergeMap();
        if (rhsMergers.isEmpty()) {
            record.addMergeMap(lhsMergeMap);
        } else {
            MergeMap rhsMergeMap = new MergeMap(lhsMergeMap.getFactory());
            rhsMergeMap.putAll(lhsMergeMap);
            RuleToHostMap anchorMap = this.getAnchorMap();
            Map<RuleNode, HostNode> createdNodeMap = record.getCreatedNodeMap();
            for (Map.Entry<RuleNode, RuleNode> rhsMergeEntry : rhsMergers.entrySet()) {
                HostNode target;
                RuleNode ruleSource = rhsMergeEntry.getKey();
                RuleNode ruleTarget = rhsMergeEntry.getValue();
                HostNode source = (HostNode)anchorMap.getNode(ruleSource);
                if (source == null) {
                    source = createdNodeMap.get(ruleSource);
                }
                if ((target = (HostNode)anchorMap.getNode(ruleTarget)) == null) {
                    target = createdNodeMap.get(ruleTarget);
                }
                rhsMergeMap.putNode(source, target);
            }
            record.addMergeMap(rhsMergeMap);
        }
    }

    private HostNodeSet getErasedNodes() {
        return ((SPOEventCache)this.getCache()).getErasedNodes();
    }

    private HostNodeSet computeErasedNodes() {
        if (((Rule)this.getRule()).getEraserNodes().length == 0) {
            return EMPTY_NODE_SET;
        }
        HostNodeSet result = this.createNodeSet();
        RuleToHostMap anchorMap = this.getAnchorMap();
        DefaultRuleNode[] defaultRuleNodeArray = ((Rule)this.getRule()).getEraserNodes();
        int n = defaultRuleNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DefaultRuleNode node = defaultRuleNodeArray[n2];
            result.add((HostNode)anchorMap.getNode(node));
            ++n2;
        }
        return result;
    }

    private HostEdgeSet getErasedEdges() {
        return ((SPOEventCache)this.getCache()).getErasedEdges();
    }

    private HostEdgeSet computeErasedEdges() {
        RuleEdge[] eraserEdges;
        HostEdgeSet result = this.createEdgeSet();
        RuleToHostMap anchorMap = this.getAnchorMap();
        RuleEdge[] ruleEdgeArray = eraserEdges = ((Rule)this.getRule()).getEraserEdges();
        int n = eraserEdges.length;
        int n2 = 0;
        while (n2 < n) {
            RuleEdge edge = ruleEdgeArray[n2];
            HostEdge edgeImage = (HostEdge)anchorMap.getEdge(edge);
            assert (edgeImage != null) : "Image of " + edge + " cannot be deduced from " + anchorMap;
            result.add(edgeImage);
            ++n2;
        }
        return result;
    }

    private HostEdgeSet getSimpleCreatedEdges() {
        return ((SPOEventCache)this.getCache()).getSimpleCreatedEdges();
    }

    private HostEdgeSet computeSimpleCreatedEdges() {
        HostEdgeSet result = this.createEdgeSet();
        RuleToHostMap coAnchorMap = this.getCoanchorMap();
        RuleEdge[] ruleEdgeArray = ((Rule)this.getRule()).getSimpleCreatorEdges();
        int n = ruleEdgeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RuleEdge edge = ruleEdgeArray[n2];
            HostEdge edgeImage = (HostEdge)coAnchorMap.mapEdge(edge);
            if (edgeImage != null) {
                result.add(edgeImage);
            }
            ++n2;
        }
        return result;
    }

    private HostNode[] getCreatedNodes(Set<? extends HostNode> sourceNodes, Collection<HostNode> added) {
        HostNode[] result;
        RuleNode[] creatorNodes = ((Rule)this.getRule()).getCreatorNodes();
        int count = creatorNodes.length;
        if (count == 0) {
            result = AbstractRuleEvent.EMPTY_NODE_ARRAY;
        } else {
            result = new HostNode[count];
            if (added == null && this.getReuse() == RuleEvent.Reuse.AGGRESSIVE) {
                added = new ArrayList<HostNode>();
            }
            int i = 0;
            while (i < count) {
                TypeLabel label = creatorNodes[i].getTypeGuards().isEmpty() ? creatorNodes[i].getType().label() : this.getCoanchorMap().getVar(creatorNodes[i].getTypeGuards().get(0).getVar()).label();
                result[i] = this.createNode(i, label, sourceNodes, added);
                ++i;
            }
        }
        if (this.getReuse() != RuleEvent.Reuse.NONE) {
            result = this.getHostFactory().normalise(result);
        }
        return result;
    }

    private HostNode createNode(int creatorIndex, TypeLabel type, Set<? extends HostNode> sourceNodes, Collection<HostNode> current) {
        HostNode result = null;
        boolean added = false;
        List<HostNode> previous = this.getFreshNodes(creatorIndex);
        if (previous != null) {
            int previousCount = previous.size();
            int i = 0;
            while (!added && i < previousCount) {
                result = previous.get(i);
                added = !sourceNodes.contains(result) && (current == null || current.add(result));
                ++i;
            }
        }
        if (!added) {
            result = this.getReuse() == RuleEvent.Reuse.AGGRESSIVE ? this.getFreshNode(sourceNodes, current, type) : this.createNode(type);
            if (current != null) {
                current.add(result);
            }
            if (previous != null) {
                previous.add(result);
            }
        }
        assert (result != null);
        return result;
    }

    private HostNode getFreshNode(Set<? extends HostNode> sourceNodes, Collection<HostNode> current, TypeLabel type) {
        int size = sourceNodes.size();
        if (current != null) {
            size += current.size();
        }
        int[] numbers = new int[size];
        int i = 0;
        for (Node node : sourceNodes) {
            numbers[i] = node.getNumber();
            ++i;
        }
        if (current != null) {
            for (Node node : current) {
                numbers[i] = node.getNumber();
                ++i;
            }
        }
        assert (i == numbers.length);
        return this.getHostFactory().createNode(type, numbers);
    }

    private List<List<HostNode>> createFreshNodeList() {
        int creatorNodeCount = ((Rule)this.getRule()).getCreatorNodes().length;
        ArrayList<List<HostNode>> result = new ArrayList<List<HostNode>>();
        int i = 0;
        while (i < creatorNodeCount) {
            result.add(new ArrayList());
            ++i;
        }
        return result;
    }

    private HostNode createNode(TypeLabel type) {
        ++freshNodeCount;
        HostFactory record = this.getHostFactory();
        return record.createNode(type);
    }

    public HostFactory getHostFactory() {
        return this.hostFactory;
    }

    private List<HostNode> getFreshNodes(int creatorIndex) {
        if (this.getReuse() == RuleEvent.Reuse.EVENT) {
            return this.freshNodeList.get(creatorIndex);
        }
        return null;
    }

    private RuleToHostMap createRuleToHostMap() {
        return this.getHostFactory().createRuleToHostMap();
    }

    @Override
    protected SPOEventCache createCache() {
        return new SPOEventCache();
    }

    public static int getFreshNodeCount() {
        return freshNodeCount;
    }

    final class SPOEventCache
    extends AbstractRuleEvent.AbstractEventCache {
        private HostNodeSet erasedNodeSet;
        private RuleToHostMap anchorMap;
        private Set<AnchorValue> anchorImageSet;
        private RuleToHostMap coanchorMap;
        private MergeMap mergeMap;
        private HostEdgeSet erasedEdgeSet;
        private HostEdgeSet simpleCreatedEdgeSet;

        SPOEventCache() {
        }

        final RuleToHostMap getAnchorMap() {
            if (this.anchorMap == null) {
                this.anchorMap = this.computeAnchorMap();
            }
            return this.anchorMap;
        }

        private RuleToHostMap computeAnchorMap() {
            Anchor anchor = ((Rule)BasicEvent.this.getRule()).getAnchor();
            AnchorValue[] anchorImage = BasicEvent.this.getAnchorImage();
            RuleToHostMap result = BasicEvent.this.createRuleToHostMap();
            int i = 0;
            while (i < anchor.size()) {
                result.put((AnchorKey)anchor.get(i), anchorImage[i]);
                ++i;
            }
            RuleEdge[] ruleEdgeArray = ((Rule)BasicEvent.this.getRule()).getEraserNonAnchorEdges();
            int n = ruleEdgeArray.length;
            int n2 = 0;
            while (n2 < n) {
                RuleEdge eraserEdge = ruleEdgeArray[n2];
                HostEdge eraserImage = (HostEdge)result.mapEdge(eraserEdge);
                assert (eraserImage != null) : String.format("Eraser edge %s has no image in anchor map %s", eraserEdge, result);
                ++n2;
            }
            return result;
        }

        Set<AnchorValue> getAnchorImageSet() {
            if (this.anchorImageSet == null) {
                RuleToHostMap anchorMap = this.getAnchorMap();
                this.anchorImageSet = new HashSet(anchorMap.nodeMap().values());
                this.anchorImageSet.addAll(anchorMap.edgeMap().values());
            }
            return this.anchorImageSet;
        }

        final RuleToHostMap getCoanchorMap() {
            if (this.coanchorMap == null) {
                this.coanchorMap = this.computeCoanchorMap();
            }
            return this.coanchorMap;
        }

        private RuleToHostMap computeCoanchorMap() {
            RuleToHostMap result = BasicEvent.this.createRuleToHostMap();
            RuleToHostMap anchorMap = this.getAnchorMap();
            for (RuleNode creatorEnd : ((Rule)BasicEvent.this.getRule()).getCreatorEnds()) {
                HostNode createdValue;
                if (creatorEnd instanceof ValueNode) {
                    ValueNode node = (ValueNode)((Object)creatorEnd);
                    createdValue = BasicEvent.this.hostFactory.createValueNode(node.getAlgebra(), node.getValue());
                } else {
                    createdValue = (HostNode)anchorMap.getNode(creatorEnd);
                    assert (creatorEnd != null) : String.format("Event '%s': No coanchor image for '%s' in %s", BasicEvent.this, creatorEnd, anchorMap);
                }
                if (createdValue == null) continue;
                result.putNode(creatorEnd, createdValue);
            }
            LabelVar[] labelVarArray = ((Rule)BasicEvent.this.getRule()).getCreatorVars();
            int n = labelVarArray.length;
            int n2 = 0;
            while (n2 < n) {
                LabelVar var = labelVarArray[n2];
                result.putVar(var, anchorMap.getVar(var));
                ++n2;
            }
            return result;
        }

        final MergeMap getMergeMap() {
            if (this.mergeMap == null) {
                this.mergeMap = this.computeMergeMap();
            }
            return this.mergeMap;
        }

        private MergeMap computeMergeMap() {
            RuleToHostMap anchorMap = this.getAnchorMap();
            MergeMap mergeMap = this.createMergeMap();
            for (Map.Entry<RuleNode, RuleNode> ruleMergeEntry : ((Rule)BasicEvent.this.getRule()).getLhsMergeMap().entrySet()) {
                HostNode mergeKey = (HostNode)anchorMap.getNode(ruleMergeEntry.getKey());
                HostNode mergeImage = (HostNode)anchorMap.getNode(ruleMergeEntry.getValue());
                mergeMap.putNode(mergeKey, mergeImage);
            }
            for (HostNode node : this.getErasedNodes()) {
                mergeMap.removeNode(node);
            }
            return mergeMap;
        }

        final HostEdgeSet getErasedEdges() {
            if (this.erasedEdgeSet == null) {
                this.erasedEdgeSet = BasicEvent.this.computeErasedEdges();
            }
            return this.erasedEdgeSet;
        }

        final HostEdgeSet getSimpleCreatedEdges() {
            if (this.simpleCreatedEdgeSet == null) {
                this.simpleCreatedEdgeSet = BasicEvent.this.computeSimpleCreatedEdges();
            }
            return this.simpleCreatedEdgeSet;
        }

        private MergeMap createMergeMap() {
            return new MergeMap(BasicEvent.this.getHostFactory());
        }

        final HostNodeSet getErasedNodes() {
            if (this.erasedNodeSet == null) {
                this.erasedNodeSet = BasicEvent.this.computeErasedNodes();
            }
            return this.erasedNodeSet;
        }
    }
}

