/*
 * Decompiled with CFR 0.152.
 */
package groove.transform;

import groove.grammar.host.HostEdge;
import groove.grammar.host.HostEdgeSet;
import groove.grammar.host.HostElement;
import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.transform.DeltaStore;
import groove.transform.DeltaTarget;
import groove.transform.StoredDeltaApplier;
import groove.util.collect.DeltaSet;
import groove.util.collect.StackedSet;
import java.util.Collection;
import java.util.Set;

public class DefaultDeltaApplier
implements StoredDeltaApplier {
    private final HostNodeSet addedNodeSet;
    private final HostNodeSet removedNodeSet;
    private final HostEdgeSet addedEdgeSet;
    private final HostEdgeSet removedEdgeSet;

    protected DefaultDeltaApplier(HostNodeSet addedNodeSet, HostNodeSet removedNodeSet, HostEdgeSet addedEdgeSet, HostEdgeSet removedEdgeSet) {
        this.addedNodeSet = this.createNodeSet(addedNodeSet);
        this.removedNodeSet = this.createNodeSet(removedNodeSet);
        this.addedEdgeSet = this.createEdgeSet(addedEdgeSet);
        this.removedEdgeSet = this.createEdgeSet(removedEdgeSet);
    }

    protected DefaultDeltaApplier(HostNodeSet addedNodeSet, HostNodeSet removedNodeSet, HostEdgeSet addedEdgeSet, HostEdgeSet removedEdgeSet, boolean share) {
        this.addedNodeSet = share ? addedNodeSet : this.createNodeSet(addedNodeSet);
        this.removedNodeSet = share ? removedNodeSet : this.createNodeSet(removedNodeSet);
        this.addedEdgeSet = share ? addedEdgeSet : this.createEdgeSet(addedEdgeSet);
        this.removedEdgeSet = share ? removedEdgeSet : this.createEdgeSet(removedEdgeSet);
    }

    @Override
    public void applyDelta(DeltaTarget target, int mode) {
        if (mode != 2) {
            for (HostNode addedNode : this.addedNodeSet) {
                target.addNode(addedNode);
            }
        }
        if (mode != 1) {
            for (HostEdge addedEdge : this.addedEdgeSet) {
                target.addEdge(addedEdge);
            }
            for (HostEdge removedEdge : this.removedEdgeSet) {
                target.removeEdge(removedEdge);
            }
        }
        if (mode != 2) {
            for (HostNode removedNode : this.removedNodeSet) {
                target.removeNode(removedNode);
            }
        }
    }

    @Override
    public void applyDelta(DeltaTarget target) {
        this.applyDelta(target, 0);
    }

    public HostNodeSet getAddedNodeSet() {
        return this.addedNodeSet;
    }

    public HostNodeSet getRemovedNodeSet() {
        return this.removedNodeSet;
    }

    public HostEdgeSet getAddedEdgeSet() {
        return this.addedEdgeSet;
    }

    public HostEdgeSet getRemovedEdgeSet() {
        return this.removedEdgeSet;
    }

    public DeltaStore invert() {
        return this.invert(false);
    }

    public DeltaStore invert(boolean share) {
        return new DeltaStore(this.removedNodeSet, this.addedNodeSet, this.removedEdgeSet, this.addedEdgeSet, share);
    }

    public int addedSize() {
        return this.addedNodeSet.size() + this.addedEdgeSet.size();
    }

    public int removedSize() {
        return this.removedNodeSet.size() + this.removedEdgeSet.size();
    }

    @Override
    public int size() {
        return this.addedSize() + this.removedSize();
    }

    private HostNodeSet createNodeSet(Collection<HostNode> set) {
        return HostNodeSet.newInstance(set);
    }

    private HostEdgeSet createEdgeSet(Collection<HostEdge> set) {
        return HostEdgeSet.newInstance(set);
    }

    protected <E extends HostElement> DeltaSet<E> createDeltaSet(Set<E> lower, Set<E> added, Set<E> removed) {
        return new DeltaSet<E>(lower, added, removed);
    }

    protected <E extends HostElement> StackedSet<E> createStackedSet(Set<? extends E> lower, Set<E> added, Set<E> removed) {
        return new StackedSet<E>(lower, added, removed);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (!this.addedNodeSet.isEmpty()) {
            result.append('+');
            result.append(this.addedNodeSet);
            result.append(' ');
        }
        if (!this.removedNodeSet.isEmpty()) {
            result.append('-');
            result.append(this.removedNodeSet);
            result.append(' ');
        }
        if (!this.addedEdgeSet.isEmpty()) {
            result.append('+');
            result.append(this.addedEdgeSet);
            result.append(' ');
        }
        if (!this.removedEdgeSet.isEmpty()) {
            result.append('-');
            result.append(this.removedEdgeSet);
            result.append(' ');
        }
        return result.toString();
    }
}

