/*
 * Decompiled with CFR 0.152.
 */
package groove.transform;

import groove.grammar.Rule;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostEdgeSet;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostGraphMorphism;
import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.grammar.host.ValueNode;
import groove.grammar.rule.Anchor;
import groove.grammar.rule.AnchorKey;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.RuleToHostMap;
import groove.match.TreeMatch;
import groove.transform.BasicEvent;
import groove.transform.CompositeEvent;
import groove.transform.DeltaApplier;
import groove.transform.DeltaTarget;
import groove.transform.FilteredDeltaTarget;
import groove.transform.MergeMap;
import groove.transform.Proof;
import groove.transform.RuleEffect;
import groove.transform.RuleEvent;
import groove.util.Property;
import groove.util.Visitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RuleApplication
implements DeltaApplier {
    private final Rule rule;
    private final HostGraph source;
    private RuleToHostMap anchorMap;
    private final RuleEvent event;
    private RuleEffect record;
    private Map<RuleNode, HostNodeSet> comatch;
    private HostGraph target;
    private Proof match;
    private HostGraphMorphism morphism;
    private HostNode[] addedNodes;
    private Map<ValueNode, HostEdgeSet> valueNodeEdgesMap;
    private Set<ValueNode> isolatedValueNodes;
    private Set<ValueNode> addedValueNodes;

    public RuleApplication(RuleEvent event, HostGraph source) {
        this(event, source, null);
    }

    public RuleApplication(RuleEvent event, HostGraph source, HostNode[] coanchorImage) {
        this.event = event;
        this.rule = event.getRule();
        this.source = source;
        this.addedNodes = coanchorImage;
        if (event instanceof BasicEvent) {
            this.anchorMap = ((BasicEvent)event).getAnchorMap();
        }
        assert (this.testEvent(event, source)) : String.format("Event error for %s applied to %s", event, source);
    }

    private boolean testEvent(final RuleEvent event, HostGraph source) {
        Property<Proof> proofContainsEvent = new Property<Proof>(){

            @Override
            public boolean isSatisfied(Proof proof) {
                return event.createEvent(proof).equals(event);
            }
        };
        final Visitor.Finder<Proof> eventFinder = Visitor.newFinder(proofContainsEvent);
        Property<TreeMatch> matchContainsProof = new Property<TreeMatch>(){

            @Override
            public boolean isSatisfied(TreeMatch value) {
                return value.traverseProofs(eventFinder) != null;
            }
        };
        Visitor.Finder<TreeMatch> matchFinder = Visitor.newFinder(matchContainsProof);
        boolean result = this.rule.getEventMatcher().traverse(source, event.getAnchorMap(), matchFinder) != null;
        eventFinder.dispose();
        matchFinder.dispose();
        return result;
    }

    public RuleApplication(RuleEvent event, HostGraph source, HostGraph target, HostNode[] coanchorImage) {
        this(event, source, coanchorImage);
        this.target = target;
    }

    public HostGraph getSource() {
        return this.source;
    }

    public Rule getRule() {
        return this.rule;
    }

    public HostGraph getTarget() {
        if (this.target == null) {
            this.target = this.rule.isModifying() ? this.computeTarget() : this.source;
        }
        return this.target;
    }

    protected HostGraph computeTarget() {
        HostGraph target = this.createTarget();
        this.applyDelta(target);
        target.setFixed();
        return target;
    }

    public Proof getMatch() {
        if (this.match == null) {
            this.match = this.computeMatch();
        }
        return this.match;
    }

    private Proof computeMatch() {
        return this.getEvent().getMatch(this.source);
    }

    public HostGraphMorphism getMorphism() {
        if (this.morphism == null) {
            this.morphism = this.computeMorphism(this.getEffect());
        }
        return this.morphism;
    }

    private HostGraphMorphism computeMorphism(RuleEffect record) {
        HostGraphMorphism result = this.createMorphism();
        MergeMap mergeMap = record.getMergeMap();
        HostNodeSet sourceNodes = new HostNodeSet(this.source.nodeSet());
        HostEdgeSet sourceEdges = new HostEdgeSet(this.source.edgeSet());
        for (HostNode node : sourceNodes) {
            HostNode nodeImage;
            HostNode hostNode = nodeImage = mergeMap == null ? node : mergeMap.getNode(node);
            if (nodeImage == null || !this.getTarget().containsNode(nodeImage)) continue;
            result.putNode(node, nodeImage);
        }
        for (HostEdge edge : sourceEdges) {
            HostEdge edgeImage;
            if (this.getEffect().isErasedEdge(edge)) continue;
            HostEdge hostEdge = edgeImage = mergeMap == null ? edge : mergeMap.mapEdge(edge);
            if (edgeImage == null || !this.getTarget().containsEdge(edgeImage)) continue;
            result.putEdge(edge, edgeImage);
        }
        return result;
    }

    @Override
    public void applyDelta(DeltaTarget target) {
        if (this.rule.isModifying()) {
            RuleEffect record = this.getEffect();
            this.eraseEdges(record, target);
            this.mergeNodes(record, target);
            this.eraseNodes(record, target);
            this.createNodes(record, target);
            this.createEdges(record, target);
            this.eraseIsolatedValueNodes(target);
        }
    }

    private RuleEffect getEffect() {
        if (this.record == null) {
            this.record = this.addedNodes == null ? new RuleEffect(this.getSource()) : new RuleEffect(this.addedNodes);
            this.getEvent().recordEffect(this.record);
        }
        return this.record;
    }

    @Override
    public void applyDelta(DeltaTarget target, int mode) {
        this.applyDelta(new FilteredDeltaTarget(target, mode));
    }

    protected void eraseNodes(RuleEffect record, DeltaTarget target) {
        HostNodeSet nodeSet = record.getErasedNodes();
        if (nodeSet != null && !nodeSet.isEmpty()) {
            for (HostNode node : nodeSet) {
                for (HostEdge edge : this.source.edgeSet(node)) {
                    if (record.isErasedEdge(edge)) continue;
                    target.removeEdge(edge);
                    this.registerErasure(edge);
                }
            }
            this.removeNodeSet(target, nodeSet);
        }
    }

    private void eraseIsolatedValueNodes(DeltaTarget target) {
        if (this.isolatedValueNodes != null) {
            for (ValueNode node : this.isolatedValueNodes) {
                target.removeNode(node);
            }
        }
    }

    private void eraseEdges(RuleEffect record, DeltaTarget target) {
        Collection<HostEdge> erasedEdges = record.getErasedEdges();
        if (erasedEdges != null) {
            for (HostEdge erasedEdge : erasedEdges) {
                target.removeEdge(erasedEdge);
                this.registerErasure(erasedEdge);
            }
        }
    }

    protected void registerErasure(HostEdge edge) {
        HostNode target = edge.target();
        if (target instanceof ValueNode) {
            HostEdgeSet edges = this.getValueNodeEdges((ValueNode)target);
            edges.remove(edge);
            if (edges.isEmpty()) {
                this.addIsolatedValueNode((ValueNode)target);
            }
        }
    }

    protected void mergeNodes(RuleEffect record, DeltaTarget target) {
        MergeMap mergeMap = record.getMergeMap();
        if (mergeMap != null) {
            for (HostNode mergedElem : mergeMap.nodeMap().keySet()) {
                for (HostEdge sourceEdge : this.source.edgeSet(mergedElem)) {
                    if (record.isErasedEdge(sourceEdge)) continue;
                    target.removeEdge(sourceEdge);
                    this.registerErasure(sourceEdge);
                    record.addCreatedEdge(sourceEdge);
                }
                this.removeNode(target, mergedElem);
            }
        }
    }

    private void createNodes(RuleEffect record, DeltaTarget target) {
        Collection<HostNode> createdNodes = record.getCreatedNodes();
        if (createdNodes != null) {
            for (HostNode node : createdNodes) {
                target.addNode(node);
            }
        }
    }

    private void createEdges(RuleEffect record, DeltaTarget target) {
        Iterable<HostEdge> createdEdges = record.getCreatedTargetEdges();
        if (createdEdges != null) {
            for (HostEdge createdEdge : createdEdges) {
                boolean existing = this.source.containsEdge(createdEdge);
                if (existing && !record.isErasedEdge(createdEdge)) continue;
                this.addEdge(target, createdEdge);
            }
        }
    }

    public int hashCode() {
        return this.getEvent().hashCode() ^ this.getSource().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RuleApplication)) {
            return false;
        }
        RuleApplication other = (RuleApplication)obj;
        return this.getEvent() == other.getEvent() && this.getSource() == other.getSource();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Derivation for rule " + this.getRule().getFullName());
        result.append("\nMatching:\n  " + this.anchorMap);
        return result.toString();
    }

    public RuleEvent getEvent() {
        return this.event;
    }

    private HostGraphMorphism createMorphism() {
        return this.getSource().getFactory().createMorphism();
    }

    protected HostGraph createTarget() {
        return this.getSource().clone();
    }

    private void addEdge(DeltaTarget target, HostEdge edge) {
        HostNode targetNode = edge.target();
        if (targetNode instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)targetNode;
            if (this.source.containsNode(targetNode)) {
                this.removeIsolatedValueNode(valueNode);
            } else if (this.registerAddedValueNode(valueNode)) {
                target.addNode(targetNode);
            }
        }
        if (target instanceof HostGraph) {
            ((HostGraph)target).addEdge(edge);
        } else {
            target.addEdge(edge);
        }
    }

    private void removeNode(DeltaTarget target, HostNode node) {
        target.removeNode(node);
    }

    private void removeNodeSet(DeltaTarget target, Collection<HostNode> nodeSet) {
        for (HostNode node : nodeSet) {
            target.removeNode(node);
        }
    }

    private HostEdgeSet getValueNodeEdges(ValueNode node) {
        HostEdgeSet result;
        if (this.valueNodeEdgesMap == null) {
            this.valueNodeEdgesMap = new HashMap<ValueNode, HostEdgeSet>();
        }
        if ((result = this.valueNodeEdgesMap.get(node)) == null) {
            result = new HostEdgeSet(this.source.inEdgeSet(node));
            this.valueNodeEdgesMap.put(node, result);
        }
        return result;
    }

    private void addIsolatedValueNode(ValueNode node) {
        if (this.isolatedValueNodes == null) {
            this.isolatedValueNodes = new HashSet<ValueNode>();
        }
        this.isolatedValueNodes.add(node);
    }

    private void removeIsolatedValueNode(ValueNode node) {
        if (this.isolatedValueNodes != null) {
            this.isolatedValueNodes.remove(node);
        }
    }

    private boolean registerAddedValueNode(ValueNode node) {
        if (this.addedValueNodes == null) {
            this.addedValueNodes = new HashSet<ValueNode>();
        }
        return this.addedValueNodes.add(node);
    }

    public Map<RuleNode, HostNodeSet> getComatch() {
        if (this.comatch == null) {
            this.comatch = this.computeComatch();
        }
        return this.comatch;
    }

    private Map<RuleNode, HostNodeSet> computeComatch() {
        HashMap<RuleNode, HostNodeSet> result = new HashMap<RuleNode, HostNodeSet>();
        RuleEvent event = this.getEvent();
        if (event instanceof BasicEvent) {
            this.collectComatch(result, (BasicEvent)event);
        } else {
            for (BasicEvent subEvent : ((CompositeEvent)event).getEventSet()) {
                this.collectComatch(result, subEvent);
            }
        }
        return result;
    }

    private void collectComatch(Map<RuleNode, HostNodeSet> result, BasicEvent event) {
        Object rule = event.getRule();
        Anchor anchor = ((Rule)rule).getAnchor();
        int i = 0;
        while (i < anchor.size()) {
            AnchorKey anchorKey = (AnchorKey)anchor.get(i);
            if (anchorKey instanceof RuleNode) {
                HostNode anchorValue = (HostNode)event.getAnchorImage(i);
                HostNode image = (HostNode)this.getMorphism().getNode(anchorValue);
                if (image != null) {
                    this.addToComatch(result, (RuleNode)anchorKey, image);
                }
            }
            ++i;
        }
        RuleNode[] creators = ((Rule)rule).getCreatorNodes();
        int i2 = 0;
        while (i2 < creators.length) {
            this.addToComatch(result, creators[i2], this.addedNodes[i2]);
            ++i2;
        }
    }

    private void addToComatch(Map<RuleNode, HostNodeSet> result, RuleNode ruleNode, HostNode hostNode) {
        assert (hostNode != null);
        HostNodeSet image = result.get(ruleNode);
        if (image == null) {
            image = new HostNodeSet();
            result.put(ruleNode, image);
        }
        image.add(hostNode);
    }
}

