/*
 * Decompiled with CFR 0.152.
 */
package groove.util.cache;

import groove.util.cache.CacheHolder;
import groove.util.cache.CacheReference;

public abstract class AbstractCacheHolder<C>
implements CacheHolder<C> {
    private CacheReference<C> reference;

    protected AbstractCacheHolder(CacheReference<C> template) {
        this.reference = this.createNullReference(template);
    }

    public C getCache() {
        return this.getCache(true);
    }

    public final C getCache(boolean create) {
        Object result = this.getCacheReference().get();
        if (result == null && create) {
            result = this.createCache();
            this.setCacheReference(this.getCacheReference().newReference(this, result));
        }
        return (C)result;
    }

    public void clearCache() {
        this.getCacheReference().clear();
    }

    public final boolean hasCache() {
        return this.getCacheReference().get() != null;
    }

    protected abstract C createCache();

    public final void setCacheCollectable() {
        if (this.hasCache()) {
            this.getCacheReference().setSoft();
        } else {
            this.setCacheReference(this.getCacheReference().getNullReference(false));
        }
        assert (this.isCacheCollectable());
    }

    public final boolean isCacheCollectable() {
        return !this.getCacheReference().isStrong();
    }

    @Override
    public final CacheReference<C> getCacheReference() {
        return this.reference;
    }

    @Override
    public final void setCacheReference(CacheReference<C> reference) {
        this.reference = reference;
    }

    protected CacheReference<C> createNullReference(CacheReference<C> template) {
        if (template == null) {
            return CacheReference.newInstance();
        }
        return template.newNullReference();
    }
}

