/*
 * Decompiled with CFR 0.152.
 */
package groove.util.collect;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Chain<E>
implements Iterable<E> {
    private final E value;
    private final Chain<E> next;
    private final int size;

    public Chain(E value) {
        this(value, null);
    }

    public Chain(E value, Chain<E> next) {
        this.value = value;
        this.next = next;
        this.size = next == null ? 1 : 1 + next.size();
    }

    public E getValue() {
        return this.value;
    }

    public Chain<E> getNext() {
        return this.next;
    }

    public Chain<E> prefix(E value) {
        return new Chain<E>(value, this);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private Chain<E> current;

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public E next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                Object result = this.current.getValue();
                this.current = this.current.getNext();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.size;
    }

    public List<E> toList(boolean inOrder) {
        Object[] result = new Object[this.size];
        int inc = inOrder ? 1 : -1;
        int ix = inOrder ? 0 : this.size - 1;
        Chain<E> chain = this;
        do {
            result[ix] = chain.getValue();
            ix += inc;
        } while ((chain = chain.getNext()) != null);
        return Arrays.asList(result);
    }

    public static final <E> Chain<E> singleton(E value) {
        return new Chain<E>(value);
    }
}

