/*
 * Decompiled with CFR 0.152.
 */
package groove.util.collect;

import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class DeltaSet<T>
extends AbstractSet<T> {
    private final Set<T> lower;
    private final Set<T> added;
    private final Set<T> removed;

    public DeltaSet() {
        this(new HashSet());
    }

    public DeltaSet(Set<T> lower) {
        assert (lower != null) : "Lower set of deltaset should not be null";
        this.lower = lower;
        this.added = this.createAddedSet();
        this.removed = this.createRemovedSet();
    }

    public DeltaSet(Set<T> lower, Set<T> added, Set<T> removed) {
        assert (lower != null) : "Lower set of deltaset should not be null";
        this.lower = lower;
        this.added = added;
        this.removed = removed;
    }

    @Override
    public int size() {
        return this.lower.size();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Set<T> removed;
            private final Set<T> added;
            private final Iterator<T> iter;
            private T latestNext;
            {
                this.removed = DeltaSet.this.removed();
                this.added = DeltaSet.this.added();
                this.iter = DeltaSet.this.lower().iterator();
                this.latestNext = null;
            }

            @Override
            public void remove() {
                this.iter.remove();
                if (!this.added.remove(this.latestNext)) {
                    this.removed.add(this.latestNext);
                }
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    this.latestNext = this.iter.next();
                    return this.latestNext;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean add(T o) {
        boolean result = this.lower.add(o);
        if (result && !this.removed.remove(o)) {
            boolean inner = this.added.add(o);
            assert (inner) : "Added element " + o + " already in added set" + this.added;
        }
        return result;
    }

    @Override
    public void clear() {
        this.removed.addAll(this.lower);
        this.removed.removeAll(this.added);
        this.added.clear();
        this.lower.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.lower.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this.lower.remove(o);
        if (result && !this.added.remove(o)) {
            boolean inner = this.removed.add(o);
            assert (inner) : "Removed element " + o + " already in removed set" + this.removed;
        }
        return result;
    }

    public Set<T> added() {
        return this.added;
    }

    public Set<T> removed() {
        return this.removed;
    }

    public Set<T> lower() {
        return this.lower;
    }

    protected Set<T> createAddedSet() {
        return new HashSet();
    }

    protected Set<T> createRemovedSet() {
        return new HashSet();
    }
}

