/*
 * Decompiled with CFR 0.152.
 */
package groove.util.collect;

import groove.util.collect.SetOfDisjointSets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class KeyPartition<T, U> {
    private final Map<T, Set<U>> partitionMap;
    private final Set<U> valueSet;
    private int size;
    private final boolean emptyCells;

    public KeyPartition(boolean emptyCells) {
        this.emptyCells = emptyCells;
        this.partitionMap = new HashMap<T, Set<U>>();
        this.valueSet = new ValueSetView();
    }

    public KeyPartition() {
        this(false);
    }

    public Set<Map.Entry<T, Set<U>>> entrySet() {
        return Collections.unmodifiableSet(this.partitionMap.entrySet());
    }

    public Set<T> keySet() {
        return Collections.unmodifiableSet(this.partitionMap.keySet());
    }

    public int cellCount() {
        return this.partitionMap.size();
    }

    public boolean containsKey(T key) {
        return this.partitionMap.containsKey(key);
    }

    public Set<U> removeCell(T key) {
        Set<U> result = this.partitionMap.remove(key);
        if (result != null) {
            this.size -= result.size();
        }
        return result;
    }

    public boolean addCell(T key) {
        boolean result;
        boolean bl = result = this.emptyCells && !this.containsKey(key);
        if (result) {
            this.partitionMap.put(key, this.createCell());
        }
        return result;
    }

    public Set<U> getCell(T key) {
        Set<U> result = this.partitionMap.get(key);
        return result == null ? null : Collections.unmodifiableSet(result);
    }

    public Set<U> values() {
        return this.valueSet;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.partitionMap.clear();
        this.size = 0;
    }

    public boolean contains(U value) {
        Set<U> cell = this.partitionMap.get(this.getKey(value));
        return cell != null && cell.contains(value);
    }

    public boolean add(U value) {
        boolean result;
        T key = this.getKey(value);
        Set<U> cell = this.partitionMap.get(key);
        if (cell == null) {
            cell = this.createCell();
            this.partitionMap.put(key, cell);
        }
        if (result = cell.add(value)) {
            ++this.size;
        }
        return result;
    }

    public boolean remove(Object value) {
        boolean result;
        T key = this.getKey(value);
        Set<U> cell = this.partitionMap.get(key);
        boolean bl = result = cell != null && cell.remove(value);
        if (result) {
            --this.size;
            if (cell.isEmpty() && !this.emptyCells) {
                this.partitionMap.remove(key);
            }
        }
        return result;
    }

    public boolean allowsEmptyCells() {
        return this.emptyCells;
    }

    protected Set<U> createCell() {
        return new HashSet();
    }

    protected abstract T getKey(Object var1);

    final Map<T, Set<U>> getPartitionMap() {
        return this.partitionMap;
    }

    private class ValueSetView
    extends SetOfDisjointSets<U> {
        public ValueSetView() {
            super(KeyPartition.this.getPartitionMap().values());
        }

        @Override
        public boolean add(U elem) {
            return KeyPartition.this.add(elem);
        }

        @Override
        public boolean remove(Object elem) {
            return KeyPartition.this.remove(elem);
        }

        @Override
        public int size() {
            return KeyPartition.this.size();
        }
    }
}

