/*
 * Decompiled with CFR 0.152.
 */
package groove.util.collect;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class KeySet<K, E>
extends AbstractSet<E>
implements Set<E> {
    private final Map<K, E> map = new LinkedHashMap<K, E>();

    @Override
    public Iterator<E> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean contains(Object o) {
        boolean result = false;
        K key = this.getKey(o);
        if (key != null) {
            result = this.map.containsKey(key);
        }
        return result;
    }

    @Override
    public boolean add(E e) {
        boolean result = false;
        K key = this.getKey(e);
        if (key != null) {
            E element = this.map.get(key);
            boolean bl = result = element == null;
            if (result) {
                this.map.put(key, e);
            }
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = false;
        K key = this.getKey(o);
        if (key != null) {
            E element = this.map.remove(key);
            result = element != null;
        }
        return result;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public E get(K key) {
        return this.map.get(key);
    }

    protected abstract K getKey(Object var1);
}

