/*
 * Decompiled with CFR 0.152.
 */
package groove.util.collect;

import groove.util.collect.TransformIterator;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public abstract class TransformSet<T, U>
extends AbstractSet<U> {
    private final Set<T> inner;

    public TransformSet(Set<T> inner) {
        this.inner = inner;
    }

    @Override
    public Iterator<U> iterator() {
        return new TransformIterator<T, U>(this.inner.iterator()){

            @Override
            protected U toOuter(T key) {
                return TransformSet.this.toOuter(key);
            }
        };
    }

    @Override
    public boolean add(Object obj) {
        return this.inner.add(this.toInner(obj));
    }

    @Override
    public boolean contains(Object o) {
        try {
            T innerObject = this.toInner(o);
            return innerObject != null && this.inner.contains(innerObject);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return super.contains(o);
        }
    }

    @Override
    public boolean remove(Object o) {
        try {
            return this.inner.remove(this.toInner(o));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return super.remove(o);
        }
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public void clear() {
        this.inner.clear();
    }

    protected abstract U toOuter(T var1);

    protected T toInner(Object key) {
        throw new UnsupportedOperationException();
    }
}

