/*
 * Decompiled with CFR 0.152.
 */
package groove.util.collect;

import groove.util.collect.Equator;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public class TreeHashSet<T>
extends AbstractSet<T> {
    private int[] tree;
    private byte[] fill;
    private int freeRecordNr;
    private int recordCount;
    private int freeKeyIx;
    private int keyCount;
    int size;
    private int[] codes;
    Object[] keys;
    private final int rootResolution;
    private final int rootMask;
    private final int resolution;
    final int mask;
    private final Equator<T> equator;
    int modCount;
    private static double sum;
    private static int count;
    public static final int MAX_RESOLUTION = 4;
    public static final int DEFAULT_CAPACITY = 16;
    public static final int DEFAULT_RESOLUTION = 3;
    public static final int DEFAULT_ROOT_RESOLUTION = 4;
    public static final Equator EQUALS_EQUATOR;
    public static final Equator IDENTITY_EQUATOR;
    public static final Equator HASHCODE_EQUATOR;
    public static final Equator DEFAULT_EQUATOR;
    private static final int BYTES_PER_INT = 4;
    private static final int BYTES_PER_REF = 4;
    private static final int BYTES_PER_OBJECT = 12;
    private static final double GROWTH_FACTOR = 1.5;
    private static final boolean FILL_PRINT = false;
    private static final boolean DEBUG = false;
    private static final boolean SIZE_PRINT = false;

    static {
        EQUALS_EQUATOR = new Equator<Object>(){

            @Override
            public int getCode(Object key) {
                return key.hashCode();
            }

            @Override
            public boolean areEqual(Object o1, Object o2) {
                return o1.equals(o2);
            }

            @Override
            public boolean allEqual() {
                return false;
            }
        };
        IDENTITY_EQUATOR = new Equator<Object>(){

            @Override
            public int getCode(Object key) {
                return System.identityHashCode(key);
            }

            @Override
            public boolean areEqual(Object o1, Object o2) {
                return o1 == o2;
            }

            @Override
            public boolean allEqual() {
                return false;
            }
        };
        HASHCODE_EQUATOR = new Equator<Object>(){

            @Override
            public int getCode(Object key) {
                return key.hashCode();
            }

            @Override
            public boolean areEqual(Object o1, Object o2) {
                return true;
            }

            @Override
            public boolean allEqual() {
                return true;
            }
        };
        DEFAULT_EQUATOR = EQUALS_EQUATOR;
    }

    public TreeHashSet(int capacity, int resolution, int rootResolution, Equator<T> equator) {
        if (resolution < 1) {
            throw new IllegalArgumentException(String.format("Invalid resolution %d (max %d)", resolution, 1));
        }
        if (rootResolution < 1) {
            throw new IllegalArgumentException(String.format("Invalid root resolution %d (min %d)", rootResolution, 1));
        }
        if (resolution > 4) {
            throw new IllegalArgumentException(String.format("Invalid resolution %d (max %d)", resolution, 4));
        }
        this.resolution = resolution;
        this.mask = (1 << resolution) - 1;
        this.rootResolution = rootResolution;
        this.rootMask = (1 << rootResolution) - 1;
        this.equator = equator;
        this.codes = new int[capacity];
        this.keys = new Object[capacity];
        this.freeKeyIx = -1;
        int maxRecordCount = Math.max(capacity >> resolution, 1);
        this.tree = new int[this.getRecordIx(maxRecordCount) + maxRecordCount];
        this.fill = new byte[maxRecordCount];
        this.recordCount = 1;
    }

    public TreeHashSet(int capacity, int resolution, int rootResolution) {
        this(capacity, resolution, rootResolution, DEFAULT_EQUATOR);
    }

    public TreeHashSet(int capacity, int resolution) {
        this(capacity, resolution, Math.max(resolution, 4));
    }

    public TreeHashSet(int capacity, Equator<T> equator) {
        this(capacity, 3, 4, equator);
    }

    public TreeHashSet(Equator<T> equator) {
        this(16, equator);
    }

    public TreeHashSet(int capacity) {
        this(capacity, 3, 4);
    }

    public TreeHashSet() {
        this(16);
    }

    public TreeHashSet(TreeHashSet<T> other) {
        this(other.size(), other.resolution, other.rootResolution, other.equator);
        int otherTreeLength = other.tree.length;
        if (this.tree.length < otherTreeLength) {
            this.tree = new int[otherTreeLength];
            this.fill = new byte[other.fill.length];
        }
        System.arraycopy(other.tree, 0, this.tree, 0, otherTreeLength);
        System.arraycopy(other.fill, 0, this.fill, 0, other.fill.length);
        int otherCodesLength = other.codes.length;
        if (this.codes.length < otherCodesLength) {
            this.codes = new int[otherCodesLength];
            this.keys = new Object[otherCodesLength];
        }
        System.arraycopy(other.codes, 0, this.codes, 0, otherCodesLength);
        System.arraycopy(other.keys, 0, this.keys, 0, otherCodesLength);
        this.size = other.size;
        this.freeRecordNr = other.freeRecordNr;
        this.recordCount = other.recordCount;
        this.freeKeyIx = other.freeKeyIx;
        this.keyCount = other.keyCount;
        assert (this.containsAll(other)) : String.format("Clone    %s does not equal%noriginal %s", this, other);
    }

    @Override
    public void clear() {
        this.size = 0;
        ++this.modCount;
        Arrays.fill(this.keys, 0, this.keyCount, null);
        Arrays.fill(this.codes, 0, this.keyCount, 0);
        this.keyCount = 0;
        this.freeKeyIx = -1;
        Arrays.fill(this.tree, 0, this.getRecordIx(this.recordCount), 0);
        Arrays.fill(this.tree, this.getRecordIx(this.fill.length), this.getRecordIx(this.fill.length) + this.recordCount, 0);
        Arrays.fill(this.fill, 0, this.recordCount, (byte)0);
        this.recordCount = 1;
        this.freeRecordNr = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Object[] keys;
            private int index;
            private T next;
            private int remainingCount;
            private final int expectedModCount;
            {
                this.keys = TreeHashSet.this.keys;
                this.index = 0;
                this.remainingCount = TreeHashSet.this.size;
                this.expectedModCount = TreeHashSet.this.modCount;
            }

            @Override
            public boolean hasNext() {
                if (this.expectedModCount != TreeHashSet.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                Object next = this.next;
                if (next == null) {
                    if (this.remainingCount == 0) {
                        return false;
                    }
                    int index = this.index;
                    Object[] keys = this.keys;
                    do {
                        next = keys[index];
                        ++index;
                    } while (next == null);
                    this.next = next instanceof MyListEntry ? ((MyListEntry)next).getValue() : next;
                    this.index = index;
                    if (!$assertionsDisabled && this.next == null) {
                        throw new AssertionError();
                    }
                    --this.remainingCount;
                }
                return true;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    Object result = this.next;
                    this.next = null;
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<T> sortedIterator() {
        return new Iterator<T>(){
            private int lastTreeIx = -1;
            private final Stack<Integer> treeIxStack = new Stack();
            private int maxTreeIx;
            private final Stack<Integer> maxIxStack;
            private MyListEntry<T> lastEntry;
            private T next;
            private boolean atEnd;
            private final int expectedModCount;
            {
                this.maxTreeIx = TreeHashSet.this.rootMask;
                this.maxIxStack = new Stack();
                this.expectedModCount = TreeHashSet.this.modCount;
            }

            @Override
            public boolean hasNext() {
                if (this.expectedModCount != TreeHashSet.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                int[] tree = TreeHashSet.this.tree;
                Object next = this.next;
                if (next == null && !this.atEnd) {
                    int nextKeyIx = -1;
                    if (this.lastEntry == null) {
                        while (!this.atEnd && nextKeyIx < 0) {
                            ++this.lastTreeIx;
                            if (this.lastTreeIx > this.maxTreeIx) {
                                if (this.treeIxStack.isEmpty()) {
                                    this.atEnd = true;
                                    continue;
                                }
                                this.lastTreeIx = this.treeIxStack.pop();
                                this.maxTreeIx = this.maxIxStack.pop();
                                continue;
                            }
                            int treeValue = tree[this.lastTreeIx];
                            if (treeValue < 0) {
                                nextKeyIx = -treeValue - 1;
                                continue;
                            }
                            if (treeValue <= 0) continue;
                            this.treeIxStack.push(this.lastTreeIx);
                            this.maxIxStack.push(this.maxTreeIx);
                            this.lastTreeIx = treeValue - 1;
                            this.maxTreeIx = treeValue + TreeHashSet.this.mask;
                        }
                    } else {
                        nextKeyIx = this.lastEntry.getNext();
                    }
                    if (nextKeyIx >= 0 && (next = TreeHashSet.this.keys[nextKeyIx]) instanceof MyListEntry) {
                        this.lastEntry = (MyListEntry)next;
                        next = ((MyListEntry)next).getValue();
                    }
                    this.next = next;
                }
                return next != null;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    Object result = this.next;
                    this.next = null;
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean add(T key) {
        boolean result = this.put(key) == null;
        return result;
    }

    public T put(T key) {
        Object result;
        int code = this.getCode(key);
        if (this.size == 0) {
            this.tree[code & this.rootMask] = -this.newKeyIx(code, key) - 1;
            result = null;
        } else {
            int[] tree = this.tree;
            int mask = this.mask;
            int resolution = this.resolution;
            int indexPlusOffset = code & this.rootMask;
            int index = tree[indexPlusOffset];
            int depth = this.rootResolution;
            int search = code >>> depth;
            while (index > 0) {
                indexPlusOffset = index + (search & mask);
                index = tree[indexPlusOffset];
                search >>>= resolution;
                depth += resolution;
            }
            if (index == 0) {
                this.setTreeSlot(indexPlusOffset, -this.newKeyIx(code, key) - 1);
                result = null;
            } else {
                int oldCode = this.codes[-index - 1];
                if (oldCode == code) {
                    result = this.putEqualKey(code, key, -index - 1);
                } else {
                    int oldOffset;
                    int newOffset;
                    int oldKeyIndex = index;
                    index = this.newRecordIx(indexPlusOffset);
                    int oldSearch = oldCode >>> depth;
                    while ((newOffset = search & mask) == (oldOffset = oldSearch & mask)) {
                        index = this.newRecordIx(index + newOffset);
                        search >>>= resolution;
                        oldSearch >>>= resolution;
                    }
                    this.setTreeSlot(index + oldOffset, oldKeyIndex);
                    this.setTreeSlot(index + newOffset, -this.newKeyIx(code, key) - 1);
                    result = null;
                }
            }
        }
        return result;
    }

    public Iterator<T> get(int code) {
        int index = this.indexOf(code);
        if (index < 0) {
            return Collections.emptySet().iterator();
        }
        if (this.allEqual()) {
            int keyIndex = -this.tree[index] - 1;
            return Collections.singleton(this.keys[keyIndex]).iterator();
        }
        final Object[] keys = this.keys;
        int keyIndex = -this.tree[index] - 1;
        return new Iterator<T>(keyIndex){
            private T next;
            private Object key;
            {
                this.key = objectArray[n];
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    if (this.key instanceof MyListEntry) {
                        MyListEntry entry = (MyListEntry)this.key;
                        this.next = entry.getValue();
                        this.key = keys[entry.getNext()];
                    } else if (this.key != null) {
                        this.next = this.key;
                        this.key = null;
                    }
                }
                return this.next != null;
            }

            @Override
            public T next() {
                this.hasNext();
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                return this.next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean remove(Object obj) {
        boolean result;
        if (this.size == 0) {
            return false;
        }
        Object key = obj;
        int index = this.indexOf(this.getCode(key));
        if (index < 0) {
            result = false;
        } else if (this.allEqual()) {
            int keyIndex = -this.tree[index] - 1;
            this.disposeTreeSlot(index);
            this.disposeKey(keyIndex);
            result = true;
        } else {
            Object[] keys = this.keys;
            int keyIndex = -this.tree[index] - 1;
            Object knownKey = keys[keyIndex];
            int prevKeyIndex = -1;
            while (knownKey instanceof MyListEntry) {
                MyListEntry entry = (MyListEntry)knownKey;
                int nextKeyIndex = entry.getNext();
                if (this.areEqual(key, entry.getValue())) {
                    keys[keyIndex] = keys[nextKeyIndex];
                    this.disposeKey(nextKeyIndex);
                    return true;
                }
                prevKeyIndex = keyIndex;
                keyIndex = nextKeyIndex;
                knownKey = keys[keyIndex];
            }
            assert (knownKey != null);
            if (this.areEqual(key, knownKey)) {
                if (prevKeyIndex < 0) {
                    this.disposeTreeSlot(index);
                } else {
                    keys[prevKeyIndex] = ((MyListEntry)keys[prevKeyIndex]).getValue();
                }
                this.disposeKey(keyIndex);
                result = true;
            } else {
                result = false;
            }
        }
        return result;
    }

    @Override
    public boolean contains(Object obj) {
        if (this.size == 0) {
            return false;
        }
        Object key = obj;
        int index = this.indexOf(this.getCode(key));
        if (index < 0) {
            return false;
        }
        return this.allEqual() || this.containsAt(key, -this.tree[index] - 1);
    }

    public double getBytesPerElement() {
        int treeSpace = 4 * this.tree.length;
        int codesSpace = 4 * this.codes.length;
        int keysSpace = 4 * this.keys.length;
        int myEntrySpace = 20 * TreeHashSet.getMyListEntryCount();
        return (double)(treeSpace + codesSpace + keysSpace + myEntrySpace) / (double)this.size;
    }

    protected boolean areEqual(T newKey, T oldKey) {
        return this.equator.areEqual(newKey, oldKey);
    }

    protected int getCode(T key) {
        return this.equator.getCode(key);
    }

    protected boolean allEqual() {
        return this.equator.allEqual();
    }

    private int indexOf(int code) {
        int[] tree = this.tree;
        int oldIndexPlusOffset = code & this.rootMask;
        int index = tree[oldIndexPlusOffset];
        if (index > 0) {
            int search = code >>> this.rootResolution;
            int mask = this.mask;
            int resolution = this.resolution;
            oldIndexPlusOffset = index + (search & mask);
            index = tree[oldIndexPlusOffset];
            while (index > 0) {
                oldIndexPlusOffset = index + ((search >>>= resolution) & mask);
                index = tree[oldIndexPlusOffset];
            }
        }
        if (index == 0 || this.codes[-index - 1] != code) {
            return -1;
        }
        return oldIndexPlusOffset;
    }

    private boolean containsAt(T newKey, int keyIndex) {
        Object[] keys = this.keys;
        Object oldKey = keys[keyIndex];
        while (oldKey instanceof MyListEntry) {
            MyListEntry entry = (MyListEntry)oldKey;
            if (this.areEqual(newKey, entry.getValue())) {
                return true;
            }
            oldKey = keys[entry.getNext()];
        }
        return this.areEqual(newKey, oldKey);
    }

    private void setTreeSlot(int treeIx, int value) {
        assert (this.tree[treeIx] == 0) : String.format("Tree value %d at index %d overwritten by %d", this.tree[treeIx], treeIx, value);
        assert (value < 0) : String.format("Tree value at %d set to positive value %d", treeIx, value);
        this.tree[treeIx] = value;
        this.setFilled(treeIx);
    }

    private void disposeTreeSlot(int treeIx) {
        int recordNr;
        assert (this.tree[treeIx] < 0) : String.format("tree[%d] == %d cannot be disposed", treeIx, this.tree[treeIx]);
        this.tree[treeIx] = 0;
        this.resetFilled(treeIx);
        while ((recordNr = this.getRecordNr(treeIx)) > 0) {
            int lastValue;
            byte offset = this.fill[recordNr];
            int lastIx = this.getRecordIx(recordNr) + (offset & 0xFF) - 1;
            if (offset > this.mask + 1 || offset <= 0 || (lastValue = this.tree[lastIx]) >= 0) break;
            this.tree[lastIx] = 0;
            this.fill[recordNr] = 0;
            treeIx = this.disposeRecord(recordNr);
            this.tree[treeIx] = lastValue;
        }
    }

    private void setFilled(int treeIx) {
        int recordNr;
        int n = recordNr = this.getRecordNr(treeIx);
        this.fill[n] = (byte)(this.fill[n] + (this.getOffset(treeIx) + 1));
    }

    private void resetFilled(int treeIx) {
        int recordNr;
        int n = recordNr = this.getRecordNr(treeIx);
        this.fill[n] = (byte)(this.fill[n] - (this.getOffset(treeIx) + 1));
    }

    private int newRecordIx(int parentIx) {
        int resultIx;
        int resultNr = this.freeRecordNr;
        if (resultNr == 0) {
            resultNr = this.recordCount++;
            int oldMaxRecordCount = this.fill.length;
            if (this.recordCount >= oldMaxRecordCount) {
                int newMaxRecordCount = (int)((double)this.recordCount * 1.5);
                int newTreeSize = this.getRecordIx(newMaxRecordCount);
                int[] newTree = new int[newTreeSize + newMaxRecordCount];
                int oldTreeSize = this.getRecordIx(oldMaxRecordCount);
                System.arraycopy(this.tree, 0, newTree, 0, oldTreeSize);
                System.arraycopy(this.tree, oldTreeSize, newTree, newTreeSize, oldMaxRecordCount);
                byte[] newFill = new byte[newMaxRecordCount];
                System.arraycopy(this.fill, 0, newFill, 0, oldMaxRecordCount);
                this.tree = newTree;
                this.fill = newFill;
            }
            this.setParentIx(resultNr, parentIx);
        } else {
            this.freeRecordNr = this.setParentIx(resultNr, parentIx);
        }
        if (this.tree[parentIx] == 0) {
            this.setFilled(parentIx);
        }
        this.tree[parentIx] = resultIx = this.getRecordIx(resultNr);
        return resultIx;
    }

    private int disposeRecord(int recordNr) {
        assert (recordNr > 0);
        int parentIx = this.setParentIx(recordNr, this.freeRecordNr);
        this.freeRecordNr = recordNr;
        return parentIx;
    }

    private int newKeyIx(int code, T key) {
        assert (code == this.getCode(key)) : "Key " + key + " should have hash code " + code + ", but has " + this.getCode(key);
        int result = this.freeKeyIx;
        if (result < 0) {
            int oldLength = this.keys.length;
            if ((result = this.keyCount++) >= oldLength) {
                int newLength = (int)(1.5 * (double)this.keyCount + 1.0);
                Object[] newKeys = new Object[newLength];
                System.arraycopy(this.keys, 0, newKeys, 0, oldLength);
                this.keys = newKeys;
                int[] newCodes = new int[newLength];
                System.arraycopy(this.codes, 0, newCodes, 0, oldLength);
                this.codes = newCodes;
            }
        } else {
            this.freeKeyIx = this.codes[result];
        }
        this.codes[result] = code;
        this.keys[result] = key;
        ++this.size;
        ++this.modCount;
        return result;
    }

    private void disposeKey(int keyIx) {
        this.keys[keyIx] = null;
        this.codes[keyIx] = this.freeKeyIx;
        this.freeKeyIx = keyIx;
        --this.size;
        ++this.modCount;
    }

    private T putEqualKey(int code, T newKey, int keyIndex) {
        MyListEntry<Object> newEntry;
        if (this.allEqual()) {
            return (T)this.keys[keyIndex];
        }
        Object[] keys = this.keys;
        Object key = keys[keyIndex];
        while (key instanceof MyListEntry) {
            MyListEntry entry = (MyListEntry)key;
            Object value = entry.getValue();
            if (this.areEqual(newKey, value)) {
                return value;
            }
            keyIndex = entry.getNext();
            key = keys[keyIndex];
        }
        assert (key != null);
        Object oldKey = key;
        if (this.areEqual(newKey, oldKey)) {
            return (T)oldKey;
        }
        this.keys[keyIndex] = newEntry = new MyListEntry<Object>(oldKey, this.newKeyIx(code, newKey));
        return null;
    }

    private int getRecordIx(int recordNr) {
        return recordNr == 0 ? 0 : (recordNr - 1 << this.resolution) + this.rootSize();
    }

    private int getRecordNr(int treeIx) {
        return treeIx < this.rootSize() ? 0 : (treeIx - this.rootSize() >>> this.resolution) + 1;
    }

    private int getOffset(int treeIx) {
        return treeIx < this.rootSize() ? treeIx : treeIx - this.rootSize() & this.mask;
    }

    private int rootSize() {
        return this.rootMask + 1;
    }

    private int getParentIx(int recordNr) {
        return this.tree[this.getRecordIx(this.fill.length) + recordNr];
    }

    private int setParentIx(int recordNr, int parentIx) {
        int recordIx = this.getRecordIx(this.fill.length) + recordNr;
        int oldParentIx = this.tree[recordIx];
        this.tree[recordIx] = parentIx;
        return oldParentIx;
    }

    private void testConsistent() {
        HashSet<Integer> freeRecordNrs = new HashSet<Integer>();
        int freeRecordNr = this.freeRecordNr;
        while (freeRecordNr > 0) {
            if (freeRecordNr >= this.recordCount) {
                throw new IllegalStateException(String.format("Free record %d > record count %d", freeRecordNr, this.recordCount));
            }
            freeRecordNrs.add(freeRecordNr);
            freeRecordNr = this.getParentIx(freeRecordNr);
        }
        int recordNr = 1;
        while (recordNr < this.recordCount) {
            if (!freeRecordNrs.contains(recordNr)) {
                int recordIx = this.getRecordIx(recordNr);
                byte recordFill = 0;
                int treeIx = recordIx;
                while (treeIx < this.getRecordIx(recordNr + 1)) {
                    int value = this.tree[treeIx];
                    if (value > 0) {
                        if (this.getOffset(value) != 0) {
                            throw new IllegalStateException(String.format("Child record index %d at %d is not at record boundary", value, treeIx));
                        }
                        if (this.getParentIx(this.getRecordNr(value)) != treeIx) {
                            throw new IllegalStateException(String.format("Child record index %d at %d points back to %d", value, treeIx, this.getParentIx(this.getRecordNr(value))));
                        }
                    }
                    if (value != 0) {
                        recordFill = (byte)(recordFill + (1 + this.getOffset(treeIx)));
                    }
                    ++treeIx;
                }
                if (recordFill == 0) {
                    throw new IllegalStateException(String.format("Non-empty record %d has no entries", recordNr));
                }
                if (this.fill[recordNr] != recordFill) {
                    throw new IllegalStateException(String.format("Record fill of %d should be %d rather than %d", recordNr, recordFill, this.fill[recordNr]));
                }
                int parentIx = this.getParentIx(recordNr);
                int parentNr = this.getRecordNr(parentIx);
                if (parentNr >= this.recordCount) {
                    throw new IllegalStateException(String.format("Parent %d of record %d larger than count %d", parentNr, recordNr, this.recordCount));
                }
                if (freeRecordNrs.contains(parentNr)) {
                    throw new IllegalStateException(String.format("Parent %d of record %d is free record", parentNr, recordNr));
                }
                if (this.getRecordNr(this.tree[parentIx]) != recordNr) {
                    throw new IllegalStateException(String.format("Parent index %d of record %d points to record %d", parentIx, recordNr, this.getRecordNr(this.tree[parentIx])));
                }
            }
            ++recordNr;
        }
    }

    public static <E> Equator<E> equalsEquator() {
        return EQUALS_EQUATOR;
    }

    public static <E> Equator<E> hashCodeEquator() {
        return HASHCODE_EQUATOR;
    }

    public static <E> Equator<E> identityEquator() {
        return IDENTITY_EQUATOR;
    }

    public static int getMyListEntryCount() {
        return MyListEntry.instanceCount;
    }

    private static float getAverageFill(int recordCount, int size) {
        return (float)(sum += (double)size / (double)recordCount) / (float)(++count);
    }

    private static class MyListEntry<T> {
        private final T value;
        private final int next;
        static int instanceCount;

        MyListEntry(T value, int next) {
            this.next = next;
            this.value = value;
            ++instanceCount;
        }

        int getNext() {
            return this.next;
        }

        T getValue() {
            return this.value;
        }
    }
}

