/*
 * Decompiled with CFR 0.152.
 */
package groove.verify;

import groove.lts.GTS;
import groove.lts.GraphState;
import groove.lts.GraphTransition;
import groove.verify.Formula;
import groove.verify.FormulaParser;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class DefaultMarker {
    private final Formula formula;
    private final GTS gts;
    private final Map<Formula, Integer> formulaNr = new HashMap<Formula, Integer>();
    private final Map<String, Integer> stringAtoms = new HashMap<String, Integer>();
    private final Map<String, Integer> ruleAtoms = new HashMap<String, Integer>();
    private BitSet[] marking;
    private int[][] backward;
    private GraphState[] states;
    private int stateCount;

    public DefaultMarker(Formula formula, GTS gts) {
        this.formula = formula;
        this.gts = gts;
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    private void init() {
        void var6_11;
        this.initFormula(this.formula);
        int formulaCount = this.formulaNr.size();
        int stateCount = this.stateCount = this.gts.nodeCount();
        this.marking = new BitSet[formulaCount];
        for (int i : this.ruleAtoms.values()) {
            this.marking[i] = new BitSet(stateCount);
        }
        for (int i : this.stringAtoms.values()) {
            this.marking[i] = new BitSet(stateCount);
        }
        this.states = new GraphState[stateCount];
        List[] backward = new List[stateCount];
        Integer openAtomIndex = this.stringAtoms.get("$open");
        Integer finalAtomIndex = this.stringAtoms.get("$open");
        for (GraphState graphState : this.gts.nodeSet()) {
            Set<? extends GraphTransition> transitions = graphState.getTransitions();
            int stateNr = graphState.getNumber();
            this.states[stateNr] = graphState;
            for (GraphTransition graphTransition : transitions) {
                GraphState target = graphTransition.target();
                int targetNr = target.getNumber();
                if (backward[targetNr] == null) {
                    backward[targetNr] = new ArrayList();
                }
                backward[targetNr].add(stateNr);
                Integer atomIndex = this.ruleAtoms.get(graphTransition.getAction().getFullName());
                if (atomIndex != null) {
                    this.marking[atomIndex].set(stateNr);
                }
                if ((atomIndex = this.stringAtoms.get(graphTransition.label().text())) == null) continue;
                this.marking[atomIndex].set(stateNr);
            }
            if (openAtomIndex != null && !graphState.isClosed()) {
                this.marking[openAtomIndex].set(stateNr);
            }
            if (finalAtomIndex == null || !this.gts.isFinal(graphState)) continue;
            this.marking[finalAtomIndex].set(stateNr);
        }
        this.backward = new int[stateCount][];
        boolean bl = false;
        while (var6_11 < stateCount) {
            int backCount = backward[var6_11] == null ? 0 : backward[var6_11].size();
            int[] backEntry = new int[backCount];
            int j = 0;
            while (j < backCount) {
                backEntry[j] = (Integer)backward[var6_11].get(j);
                ++j;
            }
            this.backward[var6_11] = backEntry;
            ++var6_11;
        }
    }

    private void initFormula(Formula formula) {
        Integer result = this.formulaNr.get(formula);
        if (result == null) {
            result = this.formulaNr.size();
            this.formulaNr.put(formula, result);
            switch (formula.getToken().getArity()) {
                case 0: {
                    if (formula.getToken() == FormulaParser.Token.TRUE || formula.getToken() == FormulaParser.Token.FALSE) break;
                    String prop = formula.getProp();
                    assert (prop != null);
                    if (this.isRuleName(prop)) {
                        this.ruleAtoms.put(prop, result);
                        break;
                    }
                    this.stringAtoms.put(prop, result);
                    break;
                }
                case 1: {
                    this.initFormula(formula.getArg1());
                    break;
                }
                case 2: {
                    this.initFormula(formula.getArg1());
                    this.initFormula(formula.getArg2());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private boolean isRuleName(String text) {
        return this.gts.getGrammar().getRule(text) != null;
    }

    public void verify() {
        this.mark(this.formula);
    }

    private BitSet mark(Formula property) {
        int nr = this.formulaNr.get(property);
        BitSet result = this.marking[nr];
        if (result != null) {
            return result;
        }
        FormulaParser.Token token = property.getToken();
        BitSet arg1 = null;
        BitSet arg2 = null;
        switch (token.getArity()) {
            case 1: {
                if (token != FormulaParser.Token.NOT) break;
                arg1 = this.mark(property.getArg1());
                break;
            }
            case 2: {
                arg1 = this.mark(property.getArg1());
                arg2 = this.mark(property.getArg2());
            }
        }
        switch (token) {
            case TRUE: {
                result = this.computeTrue();
                break;
            }
            case FALSE: {
                result = this.computeFalse();
                break;
            }
            case NOT: {
                result = this.computeNeg(arg1);
                break;
            }
            case OR: {
                result = this.computeOr(arg1, arg2);
                break;
            }
            case AND: {
                result = this.computeAnd(arg1, arg2);
                break;
            }
            case IMPLIES: {
                result = this.computeImplies(arg1, arg2);
                break;
            }
            case FOLLOWS: {
                result = this.computeImplies(arg2, arg1);
                break;
            }
            case EQUIV: {
                result = this.computeEquiv(arg1, arg2);
                break;
            }
            case FORALL: {
                result = this.markForall(property.getArg1());
                break;
            }
            case EXISTS: {
                result = this.markExists(property.getArg1());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.marking[nr] = result;
        return result;
    }

    private BitSet markExists(Formula property) {
        switch (property.getToken()) {
            case NEXT: {
                return this.computeEX(this.mark(property.getArg1()));
            }
            case UNTIL: {
                return this.computeEU(this.mark(property.getArg1()), this.mark(property.getArg2()));
            }
            case EVENTUALLY: {
                throw new UnsupportedOperationException("The EF(phi) construction should have been rewritten to a E(true U phi) construction.");
            }
            case ALWAYS: {
                throw new UnsupportedOperationException("The EG(phi) construction should have been rewritten to a !(AF(!phi)) construction.");
            }
        }
        throw new IllegalArgumentException();
    }

    private BitSet markForall(Formula property) {
        switch (property.getToken()) {
            case NEXT: {
                return this.computeAX(this.mark(property.getArg1()));
            }
            case UNTIL: {
                return this.computeAU(this.mark(property.getArg1()), this.mark(property.getArg2()));
            }
            case EVENTUALLY: {
                throw new UnsupportedOperationException("The AF(phi) construction should have been rewritten to a A(true U phi) construction.");
            }
            case ALWAYS: {
                throw new UnsupportedOperationException("The AG(phi) construction should have been rewritten to a !(EF(!phi)) construction.");
            }
        }
        throw new IllegalArgumentException();
    }

    private BitSet computeTrue() {
        BitSet result = new BitSet(this.stateCount);
        int i = 0;
        while (i < this.stateCount) {
            result.set(i);
            ++i;
        }
        return result;
    }

    private BitSet computeFalse() {
        return new BitSet(this.stateCount);
    }

    private BitSet computeNeg(BitSet arg) {
        BitSet result = (BitSet)arg.clone();
        result.flip(0, this.stateCount);
        return result;
    }

    private BitSet computeOr(BitSet arg1, BitSet arg2) {
        BitSet result = (BitSet)arg1.clone();
        result.or(arg2);
        return result;
    }

    private BitSet computeAnd(BitSet arg1, BitSet arg2) {
        BitSet result = (BitSet)arg1.clone();
        result.and(arg2);
        return result;
    }

    private BitSet computeImplies(BitSet arg1, BitSet arg2) {
        BitSet result = (BitSet)arg2.clone();
        int i = 0;
        while (i < this.stateCount) {
            if (!result.get(i)) {
                result.set(i, arg1.get(i));
            }
            ++i;
        }
        return result;
    }

    private BitSet computeEquiv(BitSet arg1, BitSet arg2) {
        BitSet result = new BitSet(this.stateCount);
        int i = 0;
        while (i < this.stateCount) {
            result.set(i, arg1.get(i) == arg1.get(i));
            ++i;
        }
        return result;
    }

    private BitSet computeEX(BitSet arg) {
        BitSet result = new BitSet(this.stateCount);
        int i = 0;
        while (i < this.stateCount) {
            if (arg.get(i)) {
                int[] preds = this.backward[i];
                int p = 0;
                while (p < preds.length) {
                    result.set(preds[p]);
                    ++p;
                }
            }
            ++i;
        }
        return result;
    }

    private BitSet computeAX(BitSet arg) {
        BitSet result = new BitSet(this.stateCount);
        int[] nextCounts = new int[this.stateCount];
        int i = 0;
        while (i < this.stateCount) {
            if (arg.get(i)) {
                int[] preds = this.backward[i];
                int p = 0;
                while (p < preds.length) {
                    int pred;
                    int n = pred = preds[p];
                    nextCounts[n] = nextCounts[n] + 1;
                    if (this.states[pred].getTransitions().size() == nextCounts[pred]) {
                        result.set(pred);
                    }
                    ++p;
                }
            }
            if (this.states[i].getTransitions().isEmpty()) {
                result.set(i);
            }
            ++i;
        }
        return result;
    }

    private BitSet computeEU(BitSet arg1, BitSet arg2) {
        BitSet result = new BitSet(this.stateCount);
        BitSet arg1Marking = arg1;
        BitSet arg2Marking = arg2;
        LinkedList<Integer> newStates = new LinkedList<Integer>();
        int i = 0;
        while (i < this.stateCount) {
            if (arg2Marking.get(i)) {
                result.set(i);
                newStates.add(i);
            }
            ++i;
        }
        while (!newStates.isEmpty()) {
            int newState = (Integer)newStates.poll();
            int[] preds = this.backward[newState];
            int b = 0;
            while (b < preds.length) {
                int pred = preds[b];
                if (arg1Marking.get(pred) && !result.get(pred)) {
                    result.set(pred);
                    newStates.add(pred);
                }
                ++b;
            }
        }
        return result;
    }

    private BitSet computeAU(BitSet arg1, BitSet arg2) {
        BitSet result = new BitSet(this.stateCount);
        int[] markedNextCount = new int[this.stateCount];
        LinkedList<Integer> newStates = new LinkedList<Integer>();
        int i = 0;
        while (i < this.stateCount) {
            if (arg2.get(i)) {
                result.set(i);
                newStates.add(i);
            }
            ++i;
        }
        while (!newStates.isEmpty()) {
            int newState = (Integer)newStates.poll();
            int[] preds = this.backward[newState];
            int b = 0;
            while (b < preds.length) {
                int pred = preds[b];
                if (arg1.get(pred) && !result.get(pred)) {
                    int n = pred;
                    markedNextCount[n] = markedNextCount[n] + 1;
                    int nextTotal = this.states[pred].getTransitions().size();
                    if (markedNextCount[pred] == nextTotal) {
                        result.set(pred);
                        newStates.add(pred);
                    }
                }
                ++b;
            }
        }
        return result;
    }

    public boolean hasValue(boolean value) {
        return this.hasValue(this.formula, value);
    }

    public boolean hasValue(GraphState state, boolean value) {
        return this.hasValue(this.formula, state, value);
    }

    public boolean hasValue(Formula formula, boolean value) {
        assert (this.formulaNr.containsKey(formula));
        return this.hasValue(formula, this.gts.startState(), value);
    }

    public boolean hasValue(Formula formula, GraphState state, boolean value) {
        assert (this.formulaNr.containsKey(formula));
        return this.marking[this.formulaNr.get(formula)].get(state.getNumber()) == value;
    }

    public int getCount(boolean value) {
        return this.getCount(this.formula, value);
    }

    public int getCount(Formula formula, boolean value) {
        assert (this.formulaNr.containsKey(formula));
        int result = 0;
        BitSet sat = this.marking[this.formulaNr.get(formula)];
        int i = 0;
        while (i < this.stateCount) {
            if (sat.get(i) == value) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public Iterable<GraphState> getStates(boolean value) {
        return this.getStates(this.formula, value);
    }

    public Iterable<GraphState> getStates(Formula formula, final boolean value) {
        assert (this.formulaNr.containsKey(formula));
        final BitSet sat = this.marking[this.formulaNr.get(formula)];
        return new Iterable<GraphState>(){

            @Override
            public Iterator<GraphState> iterator() {
                return new Iterator<GraphState>(){
                    int stateIx;
                    {
                        this.stateIx = bl ? bitSet.nextSetBit(0) : bitSet.nextClearBit(0);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.stateIx >= 0 && this.stateIx < DefaultMarker.this.stateCount;
                    }

                    @Override
                    public GraphState next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        GraphState result = DefaultMarker.this.states[this.stateIx];
                        this.stateIx = value ? sat.nextSetBit(this.stateIx + 1) : sat.nextClearBit(this.stateIx + 1);
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

