/*
 * Decompiled with CFR 0.152.
 */
package groove.verify;

public class ModelChecking {
    public static final int NO_COLOUR = Color.NONE.ordinal();

    private static enum Color {
        NONE,
        WHITE,
        CYAN,
        BLUE,
        RED,
        ALT_WHITE,
        ALT_CYAN,
        ALT_BLUE,
        ALT_RED;

    }

    public static enum Outcome {
        OK,
        ERROR;

    }

    public static class Record {
        private int white;
        private int cyan;
        private int red;
        private int blue;
        private boolean altColour;
        private int iteration = 0;

        public Record() {
            this.setColours(false);
        }

        private void setColours(boolean altColour) {
            this.altColour = altColour;
            this.white = (altColour ? Color.ALT_WHITE : Color.WHITE).ordinal();
            this.cyan = (altColour ? Color.ALT_CYAN : Color.CYAN).ordinal();
            this.blue = (altColour ? Color.ALT_BLUE : Color.BLUE).ordinal();
            this.red = (altColour ? Color.ALT_RED : Color.RED).ordinal();
        }

        public int white() {
            return this.white;
        }

        public int cyan() {
            return this.cyan;
        }

        public int red() {
            return this.red;
        }

        public int blue() {
            return this.blue;
        }

        public int getIteration() {
            return this.iteration;
        }

        public void increase() {
            ++this.iteration;
            this.setColours(!this.altColour);
        }
    }
}

