/*
 * Decompiled with CFR 0.152.
 */
package groove.verify;

import groove.explore.result.CycleAcceptor;
import groove.util.collect.TreeHashSet;
import groove.verify.ProductListener;
import groove.verify.ProductState;
import java.util.HashSet;
import java.util.Set;

public class ProductStateSet {
    private final TreeHashSet<ProductState> stateSet = new TreeHashStateSet();
    private int closedCount = 0;
    private final Set<ProductListener> listeners = new HashSet<ProductListener>();

    public ProductState addState(ProductState newState) {
        ProductState result = this.stateSet.put(newState);
        if (result == null) {
            this.fireAddState(newState);
        }
        return result;
    }

    public void setClosed(ProductState state) {
        if (state.setClosed()) {
            ++this.closedCount;
        }
        this.fireCloseState(state);
    }

    public void addListener(ProductListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ProductListener listener) {
        assert (this.listeners.contains(listener)) : "Listener cannot be removed since it is not registered.";
        this.listeners.remove(listener);
    }

    private void fireCloseState(ProductState state) {
        for (ProductListener listener : this.listeners) {
            if (!(listener instanceof CycleAcceptor)) continue;
            listener.closeUpdate(this, state);
        }
    }

    private void fireAddState(ProductState state) {
        for (ProductListener listener : this.listeners) {
            listener.addUpdate(this, state);
        }
    }

    public boolean hasOpenStates() {
        int openStateCount = this.openStateCount();
        return openStateCount > 0;
    }

    public int openStateCount() {
        return this.stateCount() - this.closedCount;
    }

    public int stateCount() {
        return this.stateSet.size();
    }

    private class TreeHashStateSet
    extends TreeHashSet<ProductState> {
        private TreeHashStateSet() {
        }
    }
}

