/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.Attributes;
import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.EmptyVisitor;
import gov.nasa.ltl.graph.Node;
import gov.nasa.ltl.graph.Visitor;
import java.util.LinkedList;
import java.util.List;

public class Graph<PropT> {
    private List<Node<PropT>> nodes;
    private Node<PropT> init;
    private Attributes attributes;

    public Graph(Attributes a) {
        this.init(a);
    }

    public Graph() {
        this.init(null);
    }

    public synchronized void setAttributes(Attributes a) {
        this.attributes = new Attributes(a);
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public synchronized void setBooleanAttribute(String name, boolean value) {
        this.attributes.setBoolean(name, value);
    }

    public boolean getBooleanAttribute(String name) {
        return this.attributes.getBoolean(name);
    }

    public int getEdgeCount() {
        int count = 0;
        LinkedList<Node<PropT>> l = new LinkedList<Node<PropT>>(this.nodes);
        for (Node node : l) {
            count += node.getOutgoingEdgeCount();
        }
        return count;
    }

    public synchronized void setInit(Node<PropT> n) {
        if (this.nodes.contains(n)) {
            this.init = n;
            this.number();
        }
    }

    public Node<PropT> getInit() {
        return this.init;
    }

    public synchronized void setIntAttribute(String name, int value) {
        this.attributes.setInt(name, value);
    }

    public int getIntAttribute(String name) {
        return this.attributes.getInt(name);
    }

    public Node<PropT> getNode(int id) {
        for (Node<PropT> n : this.nodes) {
            if (n.getId() != id) continue;
            return n;
        }
        return null;
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public List<Node<PropT>> getNodes() {
        return new LinkedList<Node<PropT>>(this.nodes);
    }

    public synchronized void setStringAttribute(String name, String value) {
        this.attributes.setString(name, value);
    }

    public String getStringAttribute(String name) {
        return this.attributes.getString(name);
    }

    public synchronized void dfs(Visitor<PropT> v) {
        if (this.init == null) {
            return;
        }
        this.forAllNodes(new EmptyVisitor<PropT>(){

            @Override
            public void visitNode(Node<PropT> n) {
                n.setBooleanAttribute("_reached", false);
            }
        });
        this.dfs(this.init, v);
        this.forAllNodes(new EmptyVisitor<PropT>(){

            @Override
            public void visitNode(Node<PropT> n) {
                n.setBooleanAttribute("_reached", false);
            }
        });
    }

    public synchronized void forAll(Visitor<PropT> v) {
        LinkedList<Node<PropT>> l = new LinkedList<Node<PropT>>(this.nodes);
        for (Node node : l) {
            v.visitNode(node);
            node.forAllEdges(v);
        }
    }

    public synchronized void forAllEdges(Visitor<PropT> v) {
        LinkedList<Node<PropT>> l = new LinkedList<Node<PropT>>(this.nodes);
        for (Node node : l) {
            node.forAllEdges(v);
        }
    }

    public synchronized void forAllNodes(Visitor<PropT> v) {
        LinkedList<Node<PropT>> l = new LinkedList<Node<PropT>>(this.nodes);
        for (Node node : l) {
            v.visitNode(node);
        }
    }

    synchronized void addNode(Node<PropT> n) {
        this.nodes.add(n);
        if (this.init == null) {
            this.init = n;
        }
        this.number();
    }

    synchronized void removeNode(Node<PropT> n) {
        this.nodes.remove(n);
        if (this.init == n) {
            this.init = this.nodes.size() != 0 ? this.nodes.get(0) : null;
        }
        this.number();
    }

    private void init(Attributes a) {
        this.attributes = a == null ? new Attributes() : a;
        this.nodes = new LinkedList<Node<PropT>>();
        this.init = null;
    }

    public synchronized void number() {
        int cnt;
        if (this.init != null) {
            this.init.setId(0);
            cnt = 1;
        } else {
            cnt = 0;
        }
        for (Node<PropT> n : this.nodes) {
            if (n == this.init) continue;
            n.setId(cnt++);
        }
    }

    private synchronized void dfs(Node<PropT> n, Visitor<PropT> v) {
        final Visitor<PropT> visitor = v;
        if (n.getBooleanAttribute("_reached")) {
            return;
        }
        n.setBooleanAttribute("_reached", true);
        v.visitNode(n);
        n.forAllEdges(new EmptyVisitor<PropT>(){

            @Override
            public void visitEdge(Edge<PropT> e) {
                Graph.this.dfs(e.getNext(), visitor);
            }
        });
    }
}

