/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.EmptyVisitor;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Node;

public class Label {
    public static <PropT> Graph<PropT> label(Graph<PropT> g) {
        String type = g.getStringAttribute("type");
        String ac = g.getStringAttribute("ac");
        final int nsets = g.getIntAttribute("nsets");
        assert (type.equals("gba")) : "invalid graph type: " + type;
        if (!ac.equals("nodes")) {
            g.setStringAttribute("ac", "edges");
            return g;
        }
        g.forAllNodes(new EmptyVisitor<PropT>(){

            @Override
            public void visitNode(Node<PropT> n) {
                n.forAllEdges(new EmptyVisitor<PropT>(){

                    @Override
                    public void visitEdge(Edge<PropT> e) {
                        Node n1 = e.getSource();
                        int i = 0;
                        while (i < nsets) {
                            if (n1.getBooleanAttribute("acc" + i)) {
                                e.setBooleanAttribute("acc" + i, true);
                            }
                            ++i;
                        }
                    }
                });
                int i = 0;
                while (i < nsets) {
                    n.setBooleanAttribute("acc" + i, false);
                    ++i;
                }
            }
        });
        g.setStringAttribute("ac", "edges");
        return g;
    }
}

