/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import java.util.ArrayList;

public class Literal<PropT>
implements Comparable<Literal<PropT>> {
    private PropT atom;
    private boolean negated;
    private static ArrayList<Object> representatives = new ArrayList();

    public Literal(PropT atom, boolean negated) {
        assert (atom != null);
        this.atom = atom;
        this.negated = negated;
    }

    public PropT getAtom() {
        return this.atom;
    }

    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public int compareTo(Literal<PropT> o) {
        if (o == null) {
            throw new NullPointerException();
        }
        int r = this.compareAtoms(this.atom, o.atom);
        if (r != 0) {
            return r;
        }
        if (this.negated) {
            if (o.negated) {
                return 0;
            }
            return 1;
        }
        if (o.negated) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Literal && (obj == this || this.compareTo((Literal)obj) == 0);
    }

    private int compareAtoms(PropT a1, PropT a2) {
        if (a1 instanceof Comparable && a2 instanceof Comparable) {
            int r2;
            Comparable c1 = (Comparable)a1;
            Comparable c2 = (Comparable)a2;
            int r1 = c1.compareTo(a2);
            if (r1 == -(r2 = c2.compareTo(a1))) {
                return r1;
            }
        }
        if (a1.equals(a2)) {
            return 0;
        }
        for (Object o : representatives) {
            if (a1.equals(o)) {
                return -1;
            }
            if (!a2.equals(o)) continue;
            return 1;
        }
        representatives.add(a1);
        representatives.add(a2);
        return -1;
    }
}

