/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.Attributes;
import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Visitor;
import java.util.LinkedList;
import java.util.List;

public class Node<PropT> {
    private Graph<PropT> graph;
    private List<Edge<PropT>> outgoingEdges;
    private List<Edge<PropT>> incomingEdges;
    private Attributes attributes;

    public Node(Graph<PropT> g, Attributes a) {
        this.init(g, a);
    }

    public Node(Graph<PropT> g) {
        this.init(g, null);
    }

    public Node(Node<PropT> n) {
        this.init(n.graph, new Attributes(n.attributes));
        for (Edge<PropT> e : n.outgoingEdges) {
            new Edge<PropT>(this, e);
        }
        for (Edge<PropT> e : n.incomingEdges) {
            new Edge<PropT>(e, this);
        }
    }

    public synchronized void setAttributes(Attributes a) {
        int id = this.getId();
        this.attributes = new Attributes(a);
        this.setId(id);
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public synchronized void setBooleanAttribute(String name, boolean value) {
        if (name.equals("_id")) {
            return;
        }
        this.attributes.setBoolean(name, value);
    }

    public boolean getBooleanAttribute(String name) {
        return this.attributes.getBoolean(name);
    }

    public Graph<PropT> getGraph() {
        return this.graph;
    }

    public synchronized int getId() {
        return this.attributes.getInt("_id");
    }

    public int getIncomingEdgeCount() {
        return this.outgoingEdges.size();
    }

    public List<Edge<PropT>> getIncomingEdges() {
        return new LinkedList<Edge<PropT>>(this.incomingEdges);
    }

    public synchronized void setIntAttribute(String name, int value) {
        if (name.equals("_id")) {
            return;
        }
        this.attributes.setInt(name, value);
    }

    public int getIntAttribute(String name) {
        return this.attributes.getInt(name);
    }

    public int getOutgoingEdgeCount() {
        return this.outgoingEdges.size();
    }

    public List<Edge<PropT>> getOutgoingEdges() {
        return new LinkedList<Edge<PropT>>(this.outgoingEdges);
    }

    public synchronized void setStringAttribute(String name, String value) {
        if (name.equals("_id")) {
            return;
        }
        this.attributes.setString(name, value);
    }

    public String getStringAttribute(String name) {
        return this.attributes.getString(name);
    }

    public synchronized void forAllEdges(Visitor<PropT> v) {
        LinkedList<Edge<PropT>> l = new LinkedList<Edge<PropT>>(this.outgoingEdges);
        for (Edge edge : l) {
            v.visitEdge(edge);
        }
    }

    public synchronized void remove() {
        LinkedList<Edge<PropT>> l = new LinkedList<Edge<PropT>>(this.outgoingEdges);
        for (Edge edge : l) {
            edge.remove();
        }
        LinkedList<Edge<PropT>> linkedList = new LinkedList<Edge<PropT>>(this.incomingEdges);
        for (Edge edge : linkedList) {
            edge.remove();
        }
        this.graph.removeNode(this);
    }

    synchronized void setId(int id) {
        this.attributes.setInt("_id", id);
    }

    synchronized void addIncomingEdge(Edge<PropT> e) {
        this.incomingEdges.add(e);
    }

    synchronized void addOutgoingEdge(Edge<PropT> e) {
        this.outgoingEdges.add(e);
    }

    synchronized void removeIncomingEdge(Edge<PropT> e) {
        this.incomingEdges.remove(e);
    }

    synchronized void removeOutgoingEdge(Edge<PropT> e) {
        this.outgoingEdges.remove(e);
    }

    private void init(Graph<PropT> g, Attributes a) {
        this.graph = g;
        this.attributes = a == null ? new Attributes() : a;
        this.incomingEdges = new LinkedList<Edge<PropT>>();
        this.outgoingEdges = new LinkedList<Edge<PropT>>();
        this.graph.addNode(this);
    }
}

