/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.EmptyVisitor;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Node;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class SCC {
    public static <PropT> List<List<Node<PropT>>> scc(Graph<PropT> g) {
        Node<PropT> init = g.getInit();
        if (init == null) {
            return new LinkedList<List<Node<PropT>>>();
        }
        init.setBooleanAttribute("_reached", true);
        SCCState s = new SCCState();
        SCC.visit(init, s);
        final List[] scc = new List[s.SCC];
        int i = 0;
        while (i < s.SCC) {
            scc[i] = new LinkedList();
            ++i;
        }
        g.forAllNodes(new EmptyVisitor<PropT>(){

            @Override
            public void visitNode(Node<PropT> n) {
                scc[n.getIntAttribute("_scc")].add(n);
                n.setBooleanAttribute("_reached", false);
                n.setBooleanAttribute("_dfsnum", false);
                n.setBooleanAttribute("_low", false);
                n.setBooleanAttribute("_scc", false);
            }
        });
        return Arrays.asList(scc);
    }

    private static <PropT> void visit(Node<PropT> p, SCCState<PropT> s) {
        s.L.add(0, p);
        p.setIntAttribute("_dfsnum", s.N);
        p.setIntAttribute("_low", s.N);
        ++s.N;
        for (Edge<PropT> e : p.getOutgoingEdges()) {
            Node<PropT> q = e.getNext();
            if (!q.getBooleanAttribute("_reached")) {
                q.setBooleanAttribute("_reached", true);
                SCC.visit(q, s);
                p.setIntAttribute("_low", Math.min(p.getIntAttribute("_low"), q.getIntAttribute("_low")));
                continue;
            }
            if (q.getIntAttribute("_dfsnum") >= p.getIntAttribute("_dfsnum") || !s.L.contains(q)) continue;
            p.setIntAttribute("_low", Math.min(p.getIntAttribute("_low"), q.getIntAttribute("_dfsnum")));
        }
        if (p.getIntAttribute("_low") == p.getIntAttribute("_dfsnum")) {
            Node v;
            do {
                v = s.L.remove(0);
                v.setIntAttribute("_scc", s.SCC);
            } while (v != p);
            ++s.SCC;
        }
    }

    private static class SCCState<PropT> {
        public int N = 0;
        public int SCC = 0;
        public List<Node<PropT>> L = new LinkedList<Node<PropT>>();

        private SCCState() {
        }
    }
}

