/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.EmptyVisitor;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Node;

public class SuperSetReduction {
    public static <PropT> Graph<PropT> reduce(Graph<PropT> g) {
        boolean[][] asets;
        boolean[][] asets_;
        int nsomething;
        final int nsets = g.getIntAttribute("nsets");
        String type = g.getStringAttribute("type");
        String ac = g.getStringAttribute("ac");
        Edge[] edges = null;
        if (!type.equals("gba")) {
            throw new RuntimeException("invalid graph type: " + type);
        }
        assert (ac.equals("nodes") || ac.equals("edges")) : "invalid accepting type: " + ac;
        if (ac.equals("nodes")) {
            int nnodes;
            nsomething = nnodes = g.getNodeCount();
            asets = asets_ = new boolean[nsets][nnodes];
            g.forAllNodes(new EmptyVisitor<PropT>(){

                @Override
                public void visitNode(Node<PropT> n) {
                    int i = 0;
                    while (i < nsets) {
                        String acc = "acc" + i;
                        if (n.getBooleanAttribute(acc)) {
                            asets_[i][n.getId()] = true;
                            n.setBooleanAttribute(acc, false);
                        }
                        ++i;
                    }
                }
            });
        } else {
            int nedges;
            nsomething = nedges = g.getEdgeCount();
            asets = asets_ = new boolean[nsets][nedges];
            final Edge[] edges_ = new Edge[nedges];
            edges = edges_;
            g.forAllEdges(new EmptyVisitor<PropT>(new Integer(0)){

                @Override
                public void visitEdge(Edge<PropT> e) {
                    int id = (Integer)this.arg;
                    this.arg = new Integer(id + 1);
                    edges_[id] = e;
                    int i = 0;
                    while (i < nsets) {
                        String acc = "acc" + i;
                        if (e.getBooleanAttribute(acc)) {
                            asets_[i][id] = true;
                            e.setBooleanAttribute(acc, false);
                        }
                        ++i;
                    }
                }
            });
        }
        boolean[] remove = new boolean[nsets];
        int i = 0;
        while (i < nsets) {
            int j = 0;
            while (j < nsets && !remove[i]) {
                if (i != j && !remove[j] && SuperSetReduction.included(asets[j], asets[i])) {
                    remove[i] = true;
                }
                ++j;
            }
            ++i;
        }
        int n_nsets = 0;
        int i2 = 0;
        while (i2 < nsets) {
            if (!remove[i2]) {
                ++n_nsets;
            }
            ++i2;
        }
        boolean[][] n_asets = new boolean[n_nsets][nsomething];
        n_nsets = 0;
        int i3 = 0;
        while (i3 < nsets) {
            if (!remove[i3]) {
                n_asets[n_nsets++] = asets[i3];
            }
            ++i3;
        }
        g.setIntAttribute("nsets", n_nsets);
        if (ac.equals("nodes")) {
            i3 = 0;
            while (i3 < nsomething) {
                Node<PropT> n = g.getNode(i3);
                int j = 0;
                while (j < n_nsets) {
                    if (n_asets[j][i3]) {
                        n.setBooleanAttribute("acc" + j, true);
                    }
                    ++j;
                }
                ++i3;
            }
        } else {
            i3 = 0;
            while (i3 < nsomething) {
                Edge e = edges[i3];
                int j = 0;
                while (j < n_nsets) {
                    if (n_asets[j][i3]) {
                        e.setBooleanAttribute("acc" + j, true);
                    }
                    ++j;
                }
                ++i3;
            }
        }
        return g;
    }

    private static boolean included(boolean[] a, boolean[] b) {
        int bl = b.length;
        int al = a.length;
        if (bl < al) {
            throw new IllegalArgumentException("Second array cannot be smaller!");
        }
        int i = 0;
        while (i < al) {
            if (a[i] && !b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

