/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graphio;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Guard;
import gov.nasa.ltl.graph.Literal;
import gov.nasa.ltl.graph.Node;
import gov.nasa.ltl.graphio.Writer;
import gov.nasa.ltl.trans.State;
import gov.nasa.ltl.trans.Transition;
import java.io.PrintStream;

class SpinWriter<PropT>
extends Writer<PropT> {
    protected PrintStream out;

    SpinWriter(PrintStream s) {
        this.out = s;
    }

    @Override
    public void write(Graph<PropT> g) {
        if (g.getInit() == null) {
            this.out.println("Empty");
            return;
        }
        this.out.println("never {");
        this.write(g.getInit());
        for (Node<PropT> n : g.getNodes()) {
            if (n == g.getInit()) continue;
            this.write(n);
            this.out.println();
        }
        this.out.println("}");
    }

    @Override
    public void write(Node<PropT> n) {
        if (n.getBooleanAttribute("accepting")) {
            this.out.print("accept_");
        }
        this.out.println("S" + n.getId() + ":");
        this.out.println("     if");
        for (Edge<PropT> e : n.getOutgoingEdges()) {
            this.out.print("     :: ");
            this.write(e);
        }
        this.out.println("     fi;");
    }

    @Override
    public void write(Edge<PropT> e) {
        int nsets = e.getSource().getGraph().getIntAttribute("nsets");
        this.out.print('(');
        this.write(e.getGuard());
        this.out.print(") ");
        if (nsets == 0) {
            if (e.getBooleanAttribute("accepting")) {
                this.out.print('@');
            }
        } else {
            boolean first = true;
            int i = 0;
            while (i < nsets) {
                if (e.getBooleanAttribute("acc" + i)) {
                    if (first) {
                        this.out.print('{');
                        first = false;
                    } else {
                        this.out.print(',');
                    }
                    this.out.print(i);
                }
                ++i;
            }
            if (!first) {
                this.out.print('}');
            }
        }
        this.out.print("-> goto ");
        if (e.getNext().getBooleanAttribute("accepting")) {
            this.out.print("accept_");
        }
        this.out.println("S" + e.getNext().getId());
    }

    @Override
    public void write(State<PropT>[] states) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void write(State<PropT> s) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void write(Transition<PropT> t) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void write(Guard<PropT> g) {
        boolean first = true;
        if (g.isTrue()) {
            this.out.print('1');
            return;
        }
        for (Literal literal : g) {
            if (first) {
                first = false;
            } else {
                this.out.print(" && ");
            }
            this.write(literal);
        }
    }

    @Override
    public void write(Literal<PropT> l) {
        if (l.isNegated()) {
            this.out.print('!');
        }
        this.out.print(l.getAtom());
    }
}

