/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.tests;

import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graphio.Writer;
import gov.nasa.ltl.trans.Formula;
import gov.nasa.ltl.trans.LTL2Buchi;

public class TrickyAtomTest {
    public static void main(String[] args) {
        LTL2Buchi.debug = true;
        System.out.println("Easy:");
        Formula<Character> easy = Formula.Always(Formula.And(Formula.And(Formula.Eventually(Formula.Proposition(Character.valueOf('a'))), Formula.Implies(Formula.Proposition(Character.valueOf('a')), Formula.Eventually(Formula.Proposition(Character.valueOf('b'))))), Formula.Implies(Formula.Proposition(Character.valueOf('b')), Formula.Eventually(Formula.Proposition(Character.valueOf('c'))))));
        System.out.println(easy);
        Graph<Character> gEasy = LTL2Buchi.translate(easy);
        Writer<Character> v = Writer.getWriter(Writer.Format.FSP, System.out);
        v.write(gEasy);
        Formula.resetStatic();
        System.out.println("Tricky:");
        Formula<TrickyAtom> tricky = Formula.Always(Formula.And(Formula.And(Formula.Eventually(Formula.Proposition(new TrickyAtom('a'))), Formula.Implies(Formula.Proposition(new TrickyAtom('a')), Formula.Eventually(Formula.Proposition(new TrickyAtom('b'))))), Formula.Implies(Formula.Proposition(new TrickyAtom('b')), Formula.Eventually(Formula.Proposition(new TrickyAtom('c'))))));
        System.out.println(tricky);
        Graph<TrickyAtom> gTricky = LTL2Buchi.translate(tricky);
        Writer<TrickyAtom> w = Writer.getWriter(Writer.Format.FSP, System.out);
        w.write(gTricky);
    }

    private static class TrickyAtom
    implements Comparable<TrickyAtom> {
        private final char x;
        private static int instances = 0;
        private static int toString = 0;
        private static int compareTo = 0;
        private static int equals = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TrickyAtom(char c) {
            this.x = c;
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                ++instances;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
            }
            return "{" + this.x + "," + instances + "," + ++toString + "," + compareTo + "," + equals + "}";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int compareTo(TrickyAtom o) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                ++compareTo;
            }
            return new Character(this.x).compareTo(Character.valueOf(o.x));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                ++equals;
            }
            return o != null && o instanceof TrickyAtom && (o == this || this.compareTo((TrickyAtom)o) == 0);
        }
    }
}

