/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.trans;

import gov.nasa.ltl.graph.Degeneralize;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.SCCReduction;
import gov.nasa.ltl.graph.SFSReduction;
import gov.nasa.ltl.graph.Simplify;
import gov.nasa.ltl.graph.SuperSetReduction;
import gov.nasa.ltl.graphio.Writer;
import gov.nasa.ltl.trans.Formula;
import gov.nasa.ltl.trans.LTLErrorException;
import gov.nasa.ltl.trans.ParseErrorException;
import gov.nasa.ltl.trans.Parser;
import gov.nasa.ltl.trans.Rewriter;
import gov.nasa.ltl.trans.Translator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

public class LTL2Buchi {
    public static boolean debug = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        Writer.Format format;
        boolean file_provided;
        boolean fairSim;
        boolean bisim;
        boolean rewrite;
        String ltl;
        block18: {
            ltl = null;
            rewrite = true;
            bisim = true;
            fairSim = true;
            file_provided = false;
            format = Writer.Format.FSP;
            debug = true;
            System.out.println("\nAuthors Dimitra Giannakopoulou & Flavio Lerda, \n(c) 2001,2003 NASA Ames Research Center\n");
            Translator.setAlgorithm(Translator.Algorithm.LTL2BUCHI);
            if (args.length == 0) break block18;
            int i = 0;
            while (i < args.length) {
                block17: {
                    block24: {
                        block25: {
                            block23: {
                                block22: {
                                    block21: {
                                        block20: {
                                            block19: {
                                                if (args[i].equals("usage")) {
                                                    LTL2Buchi.usage_warning();
                                                }
                                                if (!args[i].equals("-a")) break block19;
                                                if (++i >= args.length) {
                                                    LTL2Buchi.usage_warning();
                                                    return;
                                                }
                                                if (args[i].equals("ltl2buchi")) {
                                                    Translator.setAlgorithm(Translator.Algorithm.LTL2BUCHI);
                                                    break block17;
                                                } else {
                                                    if (!args[i].equals("ltl2aut")) {
                                                        LTL2Buchi.usage_warning();
                                                        return;
                                                    }
                                                    Translator.setAlgorithm(Translator.Algorithm.LTL2AUT);
                                                }
                                                break block17;
                                            }
                                            if (!args[i].equals("-norw")) break block20;
                                            rewrite = false;
                                            break block17;
                                        }
                                        if (!args[i].equals("-nobisim")) break block21;
                                        bisim = false;
                                        break block17;
                                    }
                                    if (!args[i].equals("-nofsim")) break block22;
                                    fairSim = false;
                                    break block17;
                                }
                                if (!args[i].equals("-nodebug")) break block23;
                                debug = false;
                                break block17;
                            }
                            if (!args[i].equals("-o")) break block24;
                            if (++i >= args.length) break block17;
                            if (!args[i].equals("fsp")) break block25;
                            format = Writer.Format.FSP;
                            break block17;
                        }
                        if (args[i].equals("promela")) {
                            format = Writer.Format.SPIN;
                            break block17;
                        } else if (args[i].equals("xml")) {
                            format = Writer.Format.XML;
                        }
                        break block17;
                    }
                    if (!args[i].equals("-f")) {
                        LTL2Buchi.usage_warning();
                        return;
                    }
                    if (++i >= args.length) {
                        LTL2Buchi.usage_warning();
                        return;
                    }
                    ltl = args[i];
                    if (ltl.endsWith(".ltl")) {
                        ltl = LTL2Buchi.loadLTL(ltl);
                        file_provided = true;
                    } else if (!ltl.equals("-")) {
                        LTL2Buchi.usage_warning();
                        return;
                    }
                }
                ++i;
            }
        }
        if (!file_provided) {
            ltl = LTL2Buchi.readLTL();
        }
        try {
            Graph<String> g = LTL2Buchi.translate(ltl, rewrite, bisim, fairSim);
            Writer<String> w = Writer.getWriter(format, System.out);
            w.write(g);
            System.out.println("\n***********************\n");
            return;
        }
        catch (ParseErrorException ex) {
            System.out.println("Error: " + ex);
        }
    }

    public static void reset_all_static() {
        Formula.resetStatic();
    }

    public static Graph<String> translate(String formula, boolean rewrite, boolean bisim, boolean fair_sim) throws ParseErrorException {
        return LTL2Buchi.translate(Parser.parse(formula), rewrite, bisim, fair_sim);
    }

    private static <PropT> void printStats(Graph<PropT> gba, String op) {
        if (!debug) {
            return;
        }
        System.out.println("\n***********************");
        System.out.println("\n" + op);
        System.out.println("\t" + gba.getNodeCount() + " states " + gba.getEdgeCount() + " transitions");
    }

    public static <PropT> Graph<PropT> translate(Formula<PropT> formula, boolean rewrite, boolean bisim, boolean fair_sim) {
        if (rewrite) {
            formula = new Rewriter<PropT>(formula).rewrite();
            if (debug) {
                System.out.println("Rewritten as      : " + formula + "\n");
            }
        }
        Graph<PropT> gba = Translator.translate(formula);
        LTL2Buchi.printStats(gba, "Generalized buchi automaton generated");
        gba = SuperSetReduction.reduce(gba);
        LTL2Buchi.printStats(gba, "Superset reduction");
        Graph<PropT> ba = Degeneralize.degeneralize(gba);
        LTL2Buchi.printStats(ba, "Degeneralized buchi automaton generated");
        ba = SCCReduction.reduce(ba);
        LTL2Buchi.printStats(ba, "Strongly connected component reduction");
        if (bisim) {
            ba = Simplify.simplify(ba);
            LTL2Buchi.printStats(ba, "Bisimulation applied");
        }
        if (fair_sim) {
            ba = SFSReduction.reduce(ba);
            LTL2Buchi.printStats(ba, "Fair simulation applied");
        }
        if (debug) {
            System.out.println("***********************\n");
        }
        LTL2Buchi.reset_all_static();
        return ba;
    }

    public static Graph<String> translate(String formula) throws ParseErrorException {
        return LTL2Buchi.translate(formula, true, true, true);
    }

    public static <PropT> Graph<PropT> translate(Formula<PropT> formula) {
        return LTL2Buchi.translate(formula, true, true, true);
    }

    public static Graph<String> translate(File file) throws ParseErrorException {
        String formula = "";
        try {
            LineNumberReader f = new LineNumberReader(new FileReader(file));
            formula = f.readLine().trim();
            f.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return LTL2Buchi.translate(formula, true, true, true);
    }

    public static void usage_warning() {
        System.out.println("\n*******  USAGE *******");
        System.out.println("java gov.nasa.ltl.trans.LTL2Buchi <options>");
        System.out.println("\toptions can be (in any order):");
        System.out.println("\t\t \"-f <filename.ltl>\" (read formula from file)");
        System.out.println("\t\t \"-a [ltl2buchi|ltl2aut]\" (set algorithm to be used)");
        System.out.println("\t\t \"-norw\" (no rewriting)");
        System.out.println("\t\t \"-nobisim\" (no bisimulation reduction)");
        System.out.println("\t\t \"-nofsim\" (no fair simulation reduction)");
        System.out.println("\t\t \"-o [fsp|promela|xml>\" (format of output; default is fsp)");
    }

    private static String loadLTL(String fname) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(fname));
            String line = in.readLine();
            in.close();
            return line;
        }
        catch (FileNotFoundException e) {
            throw new LTLErrorException("Can't load LTL formula: " + fname);
        }
        catch (IOException e) {
            throw new LTLErrorException("Error read on LTL formula: " + fname);
        }
    }

    private static String readLTL() {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("\nInsert LTL formula: ");
            return in.readLine();
        }
        catch (IOException e) {
            throw new LTLErrorException("Invalid LTL formula");
        }
    }
}

