/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.trans;

import gov.nasa.ltl.trans.Formula;
import gov.nasa.ltl.trans.ParseErrorException;
import gov.nasa.ltl.trans.Parser;
import gov.nasa.ltl.trans.RulesClass;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;

public class Rewriter<PropT> {
    private static Formula<String>[] rules = null;
    private Formula<PropT> formula;
    private Hashtable<String, Formula<PropT>> matches;
    private Formula<String>[] instanceRules = Arrays.copyOf(rules, rules.length);
    private HashSet<FormulaContainer> rewritten;

    static {
        Rewriter.readRules(null);
    }

    public Rewriter(Formula<PropT> f) {
        this.formula = f;
        this.rewritten = new HashSet();
    }

    protected Rewriter(Formula<PropT> f, HashSet<FormulaContainer> r) {
        this.formula = f;
        this.rewritten = r;
    }

    public Formula<PropT> rewrite() {
        boolean changed;
        boolean negated = false;
        assert (rules != null) : "rules not loaded";
        if (this.formula.isLiteral() || this.isRewritten(this.formula)) {
            return this.formula;
        }
        do {
            changed = false;
            int i = 0;
            while (i + 1 < this.instanceRules.length) {
                if (this.rewrite(this.instanceRules[i], this.instanceRules[i + 1])) {
                    changed = true;
                }
                i += 2;
            }
            negated = !negated;
            this.formula = Formula.Not(this.formula);
        } while (changed || negated);
        this.markRewritten(this.formula);
        return this.formula;
    }

    private boolean isRewritten(Formula<PropT> f) {
        return this.rewritten.contains(new FormulaContainer(f));
    }

    private void markRewritten(Formula<PropT> f) {
        this.rewritten.add(new FormulaContainer(f));
    }

    private boolean rewrite(Formula<String> rule, Formula<String> target) {
        Formula<PropT> f1 = this.formula.getSub1();
        Formula<PropT> f2 = this.formula.getSub2();
        if (f1 != null) {
            f1 = new Rewriter<PropT>(f1, this.rewritten).rewrite();
        }
        if (f2 != null) {
            f2 = new Rewriter<PropT>(f2, this.rewritten).rewrite();
        }
        switch (this.formula.getContent()) {
            case AND: 
            case OR: 
            case UNTIL: 
            case WEAK_UNTIL: {
                this.formula.addLeft(f1);
                this.formula.addRight(f2);
                break;
            }
            case RELEASE: {
                this.formula.addRight(f1);
                this.formula.addLeft(f2);
                break;
            }
            case NOT: 
            case NEXT: {
                this.formula.addLeft(f1);
                break;
            }
            case PROPOSITION: 
            case TRUE: 
            case FALSE: {
                return false;
            }
        }
        this.matches = new Hashtable();
        if (this.match(this.formula, rule)) {
            this.formula = this.substituteMatches(target);
            return true;
        }
        return false;
    }

    private boolean match(Formula<PropT> f, Formula<String> rule) {
        if (rule.getContent() != f.getContent()) {
            return false;
        }
        Hashtable<String, Formula<PropT>> saved = new Hashtable<String, Formula<PropT>>(this.matches);
        switch (f.getContent()) {
            case PROPOSITION: {
                Formula<PropT> match = this.matches.get(rule.getName());
                if (match == null) {
                    this.matches.put(rule.getName(), f);
                    return true;
                }
                return match == f;
            }
            case AND: 
            case OR: {
                if (this.match(f.getSub1(), rule.getSub1()) && this.match(f.getSub2(), rule.getSub2())) {
                    return true;
                }
                this.matches = saved;
                if (this.match(f.getSub2(), rule.getSub1()) && this.match(f.getSub1(), rule.getSub2())) {
                    return true;
                }
                this.matches = saved;
                return false;
            }
            case UNTIL: 
            case RELEASE: 
            case WEAK_UNTIL: {
                if (this.match(f.getSub1(), rule.getSub1()) && this.match(f.getSub2(), rule.getSub2())) {
                    return true;
                }
                this.matches = saved;
                return false;
            }
            case NOT: 
            case NEXT: {
                if (this.match(f.getSub1(), rule.getSub1())) {
                    return true;
                }
                this.matches = saved;
                return false;
            }
            case TRUE: 
            case FALSE: {
                return true;
            }
        }
        return false;
    }

    private Formula<PropT> substituteMatches(Formula<String> f) {
        Formula r = null;
        switch (f.getContent()) {
            case PROPOSITION: {
                r = this.matches.get(f.getName());
                break;
            }
            case AND: {
                Formula<PropT> s = this.substituteMatches(f.getSub1());
                Formula<PropT> t = this.substituteMatches(f.getSub2());
                r = Formula.And(s, t);
                break;
            }
            case OR: {
                Formula<PropT> s = this.substituteMatches(f.getSub1());
                Formula<PropT> t = this.substituteMatches(f.getSub2());
                r = Formula.Or(s, t);
                break;
            }
            case UNTIL: {
                Formula<PropT> s = this.substituteMatches(f.getSub1());
                Formula<PropT> t = this.substituteMatches(f.getSub2());
                r = Formula.Until(s, t);
                break;
            }
            case RELEASE: {
                Formula<PropT> s = this.substituteMatches(f.getSub1());
                Formula<PropT> t = this.substituteMatches(f.getSub2());
                r = Formula.Release(t, s);
                break;
            }
            case WEAK_UNTIL: {
                Formula<PropT> s = this.substituteMatches(f.getSub1());
                Formula<PropT> t = this.substituteMatches(f.getSub2());
                r = Formula.WUntil(s, t);
                break;
            }
            case NEXT: {
                Formula<PropT> s = this.substituteMatches(f.getSub1());
                r = Formula.Next(s);
                break;
            }
            case NOT: {
                Formula<PropT> s = this.substituteMatches(f.getSub1());
                r = Formula.Not(s);
                break;
            }
            case TRUE: {
                r = Formula.True();
                break;
            }
            case FALSE: {
                r = Formula.False();
            }
        }
        return r;
    }

    public static void readRules(String filename) {
        String rulesPath = filename != null ? filename : System.getProperty("gov.nasa.ltl.trans.rules");
        BufferedReader in = null;
        LinkedList<Formula<String>> rulesList = new LinkedList<Formula<String>>();
        try {
            if (rulesPath != null) {
                FileReader fr = new FileReader(rulesPath);
                in = new BufferedReader(fr);
            } else {
                in = new BufferedReader(new StringReader(RulesClass.getRules()));
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Rules file " + rulesPath + " not found.");
            System.exit(1);
        }
        while (true) {
            String line = null;
            Formula<String> rule = null;
            try {
                line = in.readLine();
            }
            catch (IOException e) {
                System.err.println("Failed read from " + in);
                System.exit(1);
            }
            if (line == null) break;
            if (line.equals("")) continue;
            try {
                rule = Parser.parse(line);
            }
            catch (ParseErrorException e) {
                System.err.println("Exception while reading rules: " + e);
                System.exit(1);
            }
            rulesList.add(rule);
        }
        rules = rulesList.toArray(new Formula[0]);
    }

    private class FormulaContainer {
        private final Formula<PropT> f;

        public FormulaContainer(Formula<PropT> fo) {
            this.f = fo;
        }

        public int hashCode() {
            return this.f.getId();
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof FormulaContainer && this.hashCode() == obj.hashCode();
        }
    }
}

