/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.trans;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Node;
import gov.nasa.ltl.trans.Formula;
import gov.nasa.ltl.trans.Guard;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.TreeSet;

public class Transition<PropT> {
    private TreeSet<Formula<PropT>> propositions;
    private int pointsTo;
    private BitSet accepting;
    private boolean safe_accepting;
    private Guard<PropT> guard;
    private int accepting_conds;

    Transition(TreeSet<Formula<PropT>> prop, int nd_id, BitSet acc, boolean safety, int accepting_conds) {
        this.propositions = prop;
        this.guard = new Guard<PropT>(prop);
        this.pointsTo = nd_id;
        this.accepting_conds = accepting_conds;
        this.accepting = new BitSet(accepting_conds);
        this.accepting.or(acc);
        this.safe_accepting = safety;
    }

    public void SMoutput(Node<PropT>[] nodes, Node<PropT> node) {
        String action = "-";
        Edge<PropT> e = new Edge<PropT>(node, nodes[this.pointsTo], this.guard, action);
        if (this.accepting_conds == 0) {
            e.setBooleanAttribute("acc0", true);
        } else {
            int i = 0;
            while (i < this.accepting_conds) {
                if (!this.accepting.get(i)) {
                    e.setBooleanAttribute("acc" + i, true);
                }
                ++i;
            }
        }
    }

    public boolean enabled(Hashtable<PropT, Boolean> programState) {
        block5: for (Formula<PropT> literal : this.propositions) {
            PropT atom = literal.getName();
            boolean negated = false;
            switch (literal.getContent()) {
                case TRUE: {
                    break;
                }
                case NOT: {
                    atom = literal.getSub1().getName();
                    negated = true;
                }
                case PROPOSITION: {
                    if (!programState.containsKey(atom)) {
                        return false;
                    }
                    if ((!programState.get(atom).booleanValue() || !negated) && (programState.get(atom).booleanValue() || negated)) continue block5;
                    return false;
                }
                default: {
                    assert (false) : "non-literal formula in propositions set";
                    continue block5;
                }
            }
        }
        return true;
    }

    public int goesTo() {
        return this.pointsTo;
    }

    public boolean isSafeAccepting() {
        return this.safe_accepting;
    }

    public Guard<PropT> getGuard() {
        return this.guard;
    }

    public boolean isAccepting(int i) {
        return this.accepting.get(i);
    }

    public int getAcceptingConds() {
        return this.accepting_conds;
    }
}

