/*
 * Decompiled with CFR 0.152.
 */
package net.java.swingfx.waitwithstyle;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import net.java.swingfx.waitwithstyle.CancelableAdaptee;
import net.java.swingfx.waitwithstyle.CancelableProgessAdapter;
import net.java.swingfx.waitwithstyle.InfiniteProgressAdapter;
import net.java.swingfx.waitwithstyle.InfiniteProgressPanel;

public class PerformanceInfiniteProgressPanel
extends JComponent
implements ActionListener,
CancelableAdaptee {
    private static final int DEFAULT_NUMBER_OF_BARS = 12;
    private int numBars;
    protected InfiniteProgressAdapter infiniteProgressAdapter;
    private double dScale = 1.2;
    private MouseAdapter mouseAdapter = new MouseAdapter(){};
    private MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){};
    private KeyAdapter keyAdapter = new KeyAdapter(){};
    private ComponentAdapter componentAdapter = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            if (PerformanceInfiniteProgressPanel.this.useBackBuffer) {
                PerformanceInfiniteProgressPanel.this.setOpaque(false);
                PerformanceInfiniteProgressPanel.this.imageBuf = null;
                PerformanceInfiniteProgressPanel.this.iterate = 3;
            }
        }
    };
    private BufferedImage imageBuf = null;
    private Area[] bars;
    private Rectangle barsBounds = null;
    private Rectangle barsScreenBounds = null;
    private AffineTransform centerAndScaleTransform = null;
    private Timer timer = new Timer(250, this);
    private Color[] colors = null;
    private int colorOffset = 0;
    private boolean useBackBuffer;
    private boolean tempHide = false;
    private String text;
    int iterate;

    public PerformanceInfiniteProgressPanel() {
        this(true);
    }

    public PerformanceInfiniteProgressPanel(boolean i_bUseBackBuffer) {
        this(i_bUseBackBuffer, 12);
    }

    public PerformanceInfiniteProgressPanel(int numBars) {
        this(true, numBars, null);
    }

    public PerformanceInfiniteProgressPanel(InfiniteProgressAdapter infiniteProgressAdapter) {
        this(true, 12, infiniteProgressAdapter);
    }

    public PerformanceInfiniteProgressPanel(boolean i_bUseBackBuffer, int numBars) {
        this(i_bUseBackBuffer, numBars, null);
    }

    public PerformanceInfiniteProgressPanel(boolean i_bUseBackBuffer, InfiniteProgressAdapter infiniteProgressAdapter) {
        this(i_bUseBackBuffer, 12, infiniteProgressAdapter);
    }

    public PerformanceInfiniteProgressPanel(int numBars, InfiniteProgressAdapter infiniteProgressAdapter) {
        this(true, numBars, infiniteProgressAdapter);
    }

    public PerformanceInfiniteProgressPanel(boolean i_bUseBackBuffer, int numBars, InfiniteProgressAdapter infiniteProgressAdapter) {
        this.useBackBuffer = i_bUseBackBuffer;
        this.numBars = numBars;
        this.setInfiniteProgressAdapter(infiniteProgressAdapter);
        this.colors = new Color[numBars * 2];
        this.bars = PerformanceInfiniteProgressPanel.buildTicker(numBars);
        this.barsBounds = new Rectangle();
        int i = 0;
        while (i < this.bars.length) {
            this.barsBounds = this.barsBounds.union(this.bars[i].getBounds());
            ++i;
        }
        i = 0;
        while (i < this.bars.length) {
            int channel = 224 - 128 / (i + 1);
            this.colors[i] = new Color(channel, channel, channel);
            this.colors[numBars + i] = this.colors[i];
            ++i;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setOpaque(this.useBackBuffer);
    }

    protected void setInfiniteProgressAdapter(InfiniteProgressAdapter infiniteProgressAdapter) {
        this.infiniteProgressAdapter = infiniteProgressAdapter;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.colorOffset = this.colorOffset == this.numBars - 1 ? 0 : ++this.colorOffset;
        if (this.barsScreenBounds != null) {
            this.repaint(this.barsScreenBounds);
        } else {
            this.repaint();
        }
        if (this.useBackBuffer && this.imageBuf == null) {
            if (this.iterate < 0) {
                try {
                    this.makeSnapshot();
                    this.setOpaque(true);
                }
                catch (AWTException e1) {
                    e1.printStackTrace();
                }
            } else {
                --this.iterate;
            }
        }
    }

    @Override
    public void setVisible(boolean i_bIsVisible) {
        this.setOpaque(false);
        if (i_bIsVisible) {
            if (this.useBackBuffer) {
                Window w = SwingUtilities.getWindowAncestor(this);
                if (w != null) {
                    w.addComponentListener(this.componentAdapter);
                } else {
                    this.addAncestorListener(new AncestorListener(){

                        @Override
                        public void ancestorAdded(AncestorEvent event) {
                            Window w = SwingUtilities.getWindowAncestor(PerformanceInfiniteProgressPanel.this);
                            if (w != null) {
                                w.addComponentListener(PerformanceInfiniteProgressPanel.this.componentAdapter);
                            }
                        }

                        @Override
                        public void ancestorRemoved(AncestorEvent event) {
                        }

                        @Override
                        public void ancestorMoved(AncestorEvent event) {
                        }
                    });
                }
                this.iterate = 3;
            }
            this.addMouseListener(this.mouseAdapter);
            this.addMouseMotionListener(this.mouseMotionAdapter);
            this.addKeyListener(this.keyAdapter);
            if (this.infiniteProgressAdapter != null) {
                this.infiniteProgressAdapter.animationStarting();
                this.infiniteProgressAdapter.rampUpEnded();
            }
            this.timer.start();
        } else {
            this.timer.stop();
            if (this.infiniteProgressAdapter != null) {
                this.infiniteProgressAdapter.animationStopping();
            }
            this.imageBuf = null;
            this.removeMouseListener(this.mouseAdapter);
            this.removeMouseMotionListener(this.mouseMotionAdapter);
            this.removeKeyListener(this.keyAdapter);
            Window oWindow = SwingUtilities.getWindowAncestor(this);
            if (oWindow != null) {
                oWindow.removeComponentListener(this.componentAdapter);
            }
        }
        super.setVisible(i_bIsVisible);
    }

    private void makeSnapshot() throws AWTException {
        Window oWindow = SwingUtilities.getWindowAncestor(this);
        Insets oInsets = oWindow.getInsets();
        Rectangle oRectangle = new Rectangle(oWindow.getBounds());
        oRectangle.x += oInsets.left;
        oRectangle.y += oInsets.top;
        oRectangle.width -= oInsets.left + oInsets.right;
        oRectangle.height -= oInsets.top + oInsets.bottom;
        this.imageBuf = new Robot().createScreenCapture(oRectangle);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.centerAndScaleTransform = new AffineTransform();
        this.centerAndScaleTransform.translate((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
        this.centerAndScaleTransform.scale(this.dScale, this.dScale);
        if (this.barsBounds != null) {
            Area oBounds = new Area(this.barsBounds);
            oBounds.transform(this.centerAndScaleTransform);
            this.barsScreenBounds = oBounds.getBounds();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.tempHide) {
            Rectangle oClip = g.getClipBounds();
            if (this.imageBuf == null) {
                g.setColor(new Color(255, 255, 255, 180));
                g.fillRect(oClip.x, oClip.y, oClip.width, oClip.height);
            }
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.transform(this.centerAndScaleTransform);
            int i = 0;
            while (i < this.bars.length) {
                g2.setColor(this.colors[i + this.colorOffset]);
                g2.fill(this.bars[i]);
                ++i;
            }
            double maxY = InfiniteProgressPanel.drawTextAt(this.text, this.getFont(), g2, this.getWidth(), this.barsScreenBounds.getMaxY(), this.getForeground());
            if (this.infiniteProgressAdapter != null) {
                this.infiniteProgressAdapter.paintSubComponents(maxY);
            }
        }
    }

    private static Area[] buildTicker(int i_iBarCount) {
        Area[] ticker = new Area[i_iBarCount];
        Point2D.Double center = new Point2D.Double(0.0, 0.0);
        double fixedAngle = Math.PI * 2 / (double)i_iBarCount;
        double i = 0.0;
        while (i < (double)i_iBarCount) {
            Area primitive = PerformanceInfiniteProgressPanel.buildPrimitive();
            AffineTransform toCenter = AffineTransform.getTranslateInstance(center.getX(), center.getY());
            AffineTransform toBorder = AffineTransform.getTranslateInstance(45.0, -6.0);
            AffineTransform toCircle = AffineTransform.getRotateInstance(-i * fixedAngle, center.getX(), center.getY());
            AffineTransform toWheel = new AffineTransform();
            toWheel.concatenate(toCenter);
            toWheel.concatenate(toBorder);
            primitive.transform(toWheel);
            primitive.transform(toCircle);
            ticker[(int)i] = primitive;
            i += 1.0;
        }
        return ticker;
    }

    private static Area buildPrimitive() {
        Rectangle2D.Double body = new Rectangle2D.Double(6.0, 0.0, 30.0, 12.0);
        Ellipse2D.Double head = new Ellipse2D.Double(0.0, 0.0, 12.0, 12.0);
        Ellipse2D.Double tail = new Ellipse2D.Double(30.0, 0.0, 12.0, 12.0);
        Area tick = new Area(body);
        tick.add(new Area(head));
        tick.add(new Area(tail));
        return tick;
    }

    @Override
    public void start() {
        this.setVisible(true);
    }

    @Override
    public void stop() {
        this.setVisible(false);
    }

    @Override
    public void setText(String text) {
        this.text = text;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void addCancelListener(ActionListener listener) {
        if (!(this.infiniteProgressAdapter instanceof CancelableProgessAdapter)) {
            throw new RuntimeException("Expected CancelableProgessAdapter for cancel listener.  Adapter is " + this.infiniteProgressAdapter);
        }
        ((CancelableProgessAdapter)this.infiniteProgressAdapter).addCancelListener(listener);
    }

    @Override
    public void removeCancelListener(ActionListener listener) {
        if (!(this.infiniteProgressAdapter instanceof CancelableProgessAdapter)) {
            throw new RuntimeException("Expected CancelableProgessAdapter for cancel listener.  Adapter is " + this.infiniteProgressAdapter);
        }
        ((CancelableProgessAdapter)this.infiniteProgressAdapter).removeCancelListener(listener);
    }
}

