/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import com.jaxfront.core.dom.DOMBuilder;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.help.HelpEvent;
import com.jaxfront.core.help.HelpListener;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.core.util.io.cache.XUICache;
import com.jaxfront.swing.ui.editor.EditorPanel;
import com.jaxfront.swing.ui.editor.ShowXMLDialog;
import com.jaxfront.swing.ui.tools.Dialog;
import com.jaxfront.swing.ui.wrapper.JAXJSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class JAXFrontEditorPluginBean
extends JPanel
implements Serializable,
ActionListener,
PropertyChangeListener,
HelpListener {
    public static final String XSD_CHANGED = "xsdChanged";
    public static final String XUI_CHANGED = "xuiChanged";
    public static final String XML_CHANGED = "xmlChanged";
    public static final String ROOTNAME_CHANGED = "rootNameChanged";
    private String _xsdURL;
    private String _xuiURL;
    private String _xmlURL;
    private String _rootName;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private EditorPanel _editorPanel;
    private JPanel _mainContent;
    private Document _targetDOM;
    private JPanel _helpPanel;
    private JPanel _actionPanel;
    private JPanel _errorPanel;
    private JTabbedPane _infoTabPane;
    private AbstractAction _serializeAction;
    private AbstractAction _printAction;
    private AbstractAction _validateAction;

    public JAXFrontEditorPluginBean() {
        this.buildGUI();
        this.addPropertyChangeListener(this);
        this.setVisible(true);
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        JComponent xPanel = this.createDomVisualizer();
        if (xPanel != null) {
            this.getMainContentPanel().removeAll();
            this.getMainContentPanel().add((Component)xPanel, "Center");
        } else {
            this.getMainContentPanel().removeAll();
            JLabel messageLabel = new JLabel("JAXFront: nothing loaded");
            JPanel panel = new JPanel(new GridLayout(1, 1));
            panel.add(messageLabel);
            this.getMainContentPanel().add((Component)panel, "Center");
        }
        this.getInfoTabbedPane().addTab("Error", this.getErrorPanel());
        this.getInfoTabbedPane().addTab("Help", this.getHelpPanel());
        JAXJSplitPane splitPane = new JAXJSplitPane(0);
        splitPane.setDividerSize(4);
        splitPane.setDividerLocation(0.8);
        splitPane.setBorder(null);
        splitPane.setTopComponent(this.getMainContentPanel());
        splitPane.setBottomComponent(this.getInfoTabbedPane());
        this.add((Component)this.getActionPanel(), "North");
        this.add((Component)splitPane, "Center");
    }

    public JTabbedPane getInfoTabbedPane() {
        if (this._infoTabPane == null) {
            this._infoTabPane = new JTabbedPane();
        }
        return this._infoTabPane;
    }

    public JPanel getMainContentPanel() {
        if (this._mainContent == null) {
            this._mainContent = new JPanel(new BorderLayout());
        }
        return this._mainContent;
    }

    public String getXSDUrl() {
        return this._xsdURL;
    }

    public void setXSDUrl(String value) {
        String oldValue = this._xsdURL;
        this._xsdURL = value;
        this.propertySupport.firePropertyChange(XSD_CHANGED, oldValue, this._xsdURL);
    }

    public String getXUIUrl() {
        return this._xuiURL;
    }

    public JPanel getHelpPanel() {
        if (this._helpPanel == null) {
            this._helpPanel = new JPanel();
        }
        return this._helpPanel;
    }

    public JPanel getActionPanel() {
        if (this._actionPanel == null) {
            this._actionPanel = new JPanel();
            this._actionPanel.add(new JButton(this.getValidateAction()));
            this._actionPanel.add(new JButton(this.getSerializeAction()));
            this._actionPanel.add(new JButton(this.getPrintAction()));
        }
        return this._actionPanel;
    }

    public JPanel getErrorPanel() {
        if (this._errorPanel == null) {
            this._errorPanel = new JPanel(new BorderLayout());
            this._errorPanel.setBorder(null);
        }
        return this._errorPanel;
    }

    public void setXUIUrl(String value) {
        String oldValue = this._xuiURL;
        this._xuiURL = value;
        this.propertySupport.firePropertyChange(XUI_CHANGED, oldValue, this._xuiURL);
    }

    public String getXMLUrl() {
        return this._xmlURL;
    }

    public void setXMLUrl(String value) {
        String oldValue = this._xmlURL;
        this._xmlURL = value;
        this.propertySupport.firePropertyChange(XML_CHANGED, oldValue, this._xmlURL);
    }

    public String getRootName() {
        return this._rootName;
    }

    public void setRootName(String value) {
        String oldValue = this._rootName;
        this._rootName = value;
        this.propertySupport.firePropertyChange(ROOTNAME_CHANGED, oldValue, this._rootName);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    private Window getWindow() {
        Window window = SwingUtilities.getWindowAncestor(this);
        return window;
    }

    private JComponent createDomVisualizer() {
        if (this.getDom() != null) {
            Type lastSelectedType = null;
            if (this._editorPanel != null && this._editorPanel.getSelectedTreeNode() != null) {
                lastSelectedType = this._editorPanel.getSelectedTreeNode().getType();
            }
            TypeVisualizerFactory.getInstance().releaseCache(this.getDom());
            this._editorPanel = new EditorPanel(this.getDom().getRootType(), this.getWindow());
            this._editorPanel.addHelpListener(this);
            this._editorPanel.setTargetMessageTable(this.getErrorPanel());
            if (lastSelectedType != null) {
                this._editorPanel.selectNode(lastSelectedType);
            }
            this._editorPanel.setBorder(null);
        }
        return this._editorPanel;
    }

    private Document getDom() {
        if (this._targetDOM == null && this._xsdURL != null) {
            URL url = null;
            URL xmlUrl = null;
            URL xuiUrl = null;
            String root = this._rootName;
            if (this._xsdURL != null) {
                url = URLHelper.getUserURL((String)this._xsdURL);
            }
            if (this._xuiURL != null) {
                xuiUrl = URLHelper.getUserURL((String)this._xuiURL);
            }
            if (this._xmlURL != null) {
                xmlUrl = URLHelper.getUserURL((String)this._xmlURL);
            }
            try {
                this._targetDOM = DOMBuilder.getInstance().build(null, url, xmlUrl, xuiUrl, root);
                if (this._editorPanel != null) {
                    this._editorPanel.selectNode((Type)null);
                }
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                PrintWriter writer = new PrintWriter(sw);
                ex.printStackTrace(writer);
                Dialog.showComponentDialog(new JScrollPane(new JTextArea(sw.toString())), "getDomError");
                ex.printStackTrace();
            }
        }
        return this._targetDOM;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        JAXFrontEditorPluginBean plugin = new JAXFrontEditorPluginBean();
        plugin.setXSDUrl("file:c:/Dokumente und Einstellungen/All Users/Dokumente/workspace/JAXFront Demo/examples/purchaseOrder/po.xsd");
        plugin.setXUIUrl("file:c:/Dokumente und Einstellungen/All Users/Dokumente/workspace/JAXFront Demo/examples/purchaseOrder/po.xui");
        f.getContentPane().add(plugin);
        f.setVisible(true);
        f.setSize(400, 400);
    }

    public void resetGUIVars() {
        this._editorPanel = null;
        this._targetDOM = null;
    }

    public void reInitGUI() {
        try {
            if (this._editorPanel != null) {
                this.getMainContentPanel().remove(this._editorPanel);
            }
            if (this._xsdURL != null) {
                this.resetGUIVars();
                JComponent xPanel = this.createDomVisualizer();
                if (xPanel != null) {
                    this.getMainContentPanel().removeAll();
                    this.getMainContentPanel().add((Component)xPanel, "Center");
                } else {
                    this.getMainContentPanel().removeAll();
                    JTextArea messageLabel = new JTextArea("JAXFront: nothing loaded:" + this._xsdURL + "\n" + this._rootName + "\n" + this._xuiURL + "\n" + this._xmlURL);
                    JPanel panel = new JPanel(new GridLayout(4, 1));
                    panel.add(messageLabel);
                    this.getMainContentPanel().add((Component)panel, "Center");
                }
            }
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(this.getClass(), e.toString());
            this.getMainContentPanel().removeAll();
            JTextArea messageLabel = new JTextArea(e.toString());
            JPanel panel = new JPanel(new GridLayout(1, 1));
            panel.add(messageLabel);
            this.getMainContentPanel().add((Component)panel, "Center");
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getNewValue() != evt.getOldValue()) {
            if (evt.getPropertyName() == XML_CHANGED) {
                this._xmlURL = (String)evt.getNewValue();
            }
            if (evt.getPropertyName() == XSD_CHANGED) {
                this._xsdURL = (String)evt.getNewValue();
            }
            if (evt.getPropertyName() == XUI_CHANGED) {
                this._xuiURL = (String)evt.getNewValue();
            }
            if (evt.getPropertyName() == ROOTNAME_CHANGED) {
                this._rootName = (String)evt.getNewValue();
            }
            this.reInitGUI();
            if (LogRegistry.getInstance().logInfos()) {
                LogRegistry.getInstance().info(this.getClass(), "setProperty:" + evt.getPropertyName() + " value:" + evt.getNewValue());
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void showHelp(HelpEvent event) {
        this.getHelpPanel().removeAll();
        String helpText = "Help (" + event.getHelpID() + "): " + ((Type)event.getSource()).getXPathLocation();
        JLabel helpLabel = new JLabel(helpText);
        this.getHelpPanel().add(helpLabel);
        this.getHelpPanel().updateUI();
    }

    private AbstractAction getSerializeAction() {
        if (this._serializeAction == null) {
            this._serializeAction = new AbstractAction("Serialize", JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/editXML_16x16.gif")){

                public void actionPerformed(ActionEvent e) {
                    JAXFrontEditorPluginBean.this.serialize();
                }
            };
        }
        return this._serializeAction;
    }

    private AbstractAction getPrintAction() {
        if (this._printAction == null) {
            this._printAction = new AbstractAction("Print PDF", JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/pdf_16x16.gif")){

                public void actionPerformed(ActionEvent e) {
                }
            };
        }
        return this._printAction;
    }

    private AbstractAction getValidateAction() {
        if (this._validateAction == null) {
            this._validateAction = new AbstractAction("Validate", JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/validate_16x16.gif")){

                public void actionPerformed(ActionEvent e) {
                    JAXFrontEditorPluginBean.this.validateXML();
                }
            };
        }
        return this._validateAction;
    }

    private void validateXML() {
        if (this.getDom() != null) {
            this.getDom().validate();
        }
    }

    public void releaseXUICache() {
        XUICache.getInstance().releaseCache();
    }

    public void serialize() {
        ShowXMLDialog dialog = new ShowXMLDialog(this.getDom());
        dialog.prettyPrint();
        Dimension dialogDim = dialog.getSize();
        Dimension thisDim = this.getSize();
        int x = (thisDim.width - dialogDim.width) / 2;
        int y = (thisDim.height - dialogDim.height) / 2;
        if (this.getLocation().x > 0 || this.getLocation().y > 0) {
            x += this.getLocation().x;
            y += this.getLocation().y;
        }
        dialog.setLocation(x > 0 ? x : 0, y > 0 ? y : 0);
        dialog.setVisible(true);
    }

    public void setHelpVisible(Boolean visible) {
        this.getHelpPanel().setVisible(visible);
    }

    public void setErrorsVisible(Boolean visible) {
        this.getErrorPanel().setVisible(visible);
    }
}

