/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.swing.ui.beans.JCalendar;
import com.jaxfront.swing.ui.tools.GUITools;
import com.jaxfront.swing.ui.wrapper.JAXJButton;
import com.jaxfront.swing.ui.wrapper.JAXJDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.MaskFormatter;

public class JCalendarPopUp
extends JPanel
implements ActionListener,
PropertyChangeListener,
FocusListener,
AncestorListener {
    private boolean _forceRefreshData;
    public static Dimension fixedPopupWidth = new Dimension(160, 140);
    private boolean _isPopUpShowing = false;
    private JFormattedTextField _textField;
    private JAXJButton _button;
    private JDialog _dialog;
    private SimpleType _model;
    protected JCalendar _calendar;

    public void addFocusListener(FocusListener focusListener) {
        if (this._textField != null) {
            this._textField.addFocusListener(focusListener);
        }
        if (this._button != null) {
            this._button.addFocusListener(focusListener);
        }
    }

    public void addKeyListener(KeyListener focusListener) {
        if (this._textField != null) {
            this._textField.addKeyListener(focusListener);
        }
    }

    public void removeFocusListener(FocusListener focusListener) {
        if (this._textField != null) {
            this._textField.removeFocusListener(focusListener);
        }
        if (this._button != null) {
            this._button.removeFocusListener(focusListener);
        }
    }

    public void removeKeyListener(KeyListener focusListener) {
        if (this._textField != null) {
            this._textField.removeKeyListener(focusListener);
        }
    }

    public void ancestorAdded(AncestorEvent event) {
    }

    public void ancestorMoved(AncestorEvent event) {
        if (this._isPopUpShowing) {
            this.hideDropDownList();
        }
    }

    public void ancestorRemoved(AncestorEvent event) {
    }

    public JCalendarPopUp(SimpleType model) {
        this._model = model;
        this.init();
    }

    public void actionPerformed(ActionEvent event) {
        if (!this.getDialog().isVisible()) {
            this._textField.requestFocus();
            this.populateModel();
            this.showDropDownList();
        } else {
            this.hideDropDownList();
        }
    }

    public Color getBackground() {
        if (this._textField == null) {
            return super.getBackground();
        }
        return this._textField.getBackground();
    }

    public Calendar getCalendar() {
        return this._calendar.getCalendar();
    }

    public String getCurrentDateFromTextField() {
        if (this._textField != null) {
            return this.transformDateToISO(this._textField.getText());
        }
        return null;
    }

    private String transformISOToDate(String isoDate) {
        String year = null;
        String month = null;
        String day = null;
        if (isoDate != null) {
            if (isoDate.indexOf("-") != -1) {
                StringTokenizer tokenizer = new StringTokenizer(isoDate, "-");
                if (tokenizer.hasMoreTokens()) {
                    year = tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        month = tokenizer.nextToken();
                        if (tokenizer.hasMoreTokens()) {
                            day = tokenizer.nextToken();
                        }
                    }
                }
                isoDate = day + "." + month + "." + year;
            }
            return isoDate;
        }
        return "";
    }

    private String transformDateToISO(String dateString) {
        String year = null;
        String month = null;
        String day = null;
        if (dateString != null && !dateString.equals("  .  .    ")) {
            StringTokenizer tokenizer = new StringTokenizer(dateString, ".");
            if (tokenizer.hasMoreTokens()) {
                day = tokenizer.nextToken();
                if (!day.equals("  ")) {
                    day = day.trim();
                }
                if (day.length() == 1) {
                    day = "0" + day;
                }
                if (tokenizer.hasMoreTokens()) {
                    month = tokenizer.nextToken();
                    if (!month.equals("  ")) {
                        month = month.trim();
                    }
                    if (month.length() == 1) {
                        month = "0" + month;
                    }
                    if (tokenizer.hasMoreTokens()) {
                        year = tokenizer.nextToken();
                        if (!year.equals("    ")) {
                            year = year.trim();
                        }
                        if (year.length() == 1) {
                            year = "200" + year;
                        } else if (year.length() == 2) {
                            year = "20" + year;
                        } else if (year.length() == 3) {
                            year = "2" + year;
                        }
                    }
                }
            }
            dateString = year + "-" + month + "-" + day;
            dateString = TextTools.replace((String)dateString, (String)" ", (String)"0");
            return dateString;
        }
        return "";
    }

    public Color getForeground() {
        if (this._textField == null) {
            return super.getForeground();
        }
        return this._textField.getForeground();
    }

    public String getHelpId() {
        return this.getName();
    }

    public JFormattedTextField getTextField() {
        return this._textField;
    }

    private void hideDropDownList() {
        this.hidePopUp();
    }

    protected void hidePopUp() {
        this.setPopUpVisible(false);
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter("##.##.####");
            formatter.setAllowsInvalid(false);
            formatter.setOverwriteMode(true);
            formatter.setCommitsOnValidEdit(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        this._textField = new JFormattedTextField(formatter);
        this._textField.setFocusLostBehavior(3);
        this._textField.setFont(new JTextField().getFont());
        this._button = new JAXJButton(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/calendar_16x16.gif"));
        this._button.setRequestFocusEnabled(false);
        this._button.addActionListener(this);
        this._button.setFocusable(false);
        this._calendar = new JCalendar();
        this._calendar.addPropertyChangeListener(this);
        this.add((Component)this._textField, "Center");
        this.add((Component)this._button, "East");
        this.setBounds(100, 100, 50, 19);
        Dimension d = new Dimension(19, 19);
        this._button.setPreferredSize(d);
        this._button.setMaximumSize(d);
        this._button.setMinimumSize(d);
        this._button.setSize(d);
        this._textField.addFocusListener(this);
        this._calendar.setBorder(BorderFactory.createLineBorder(Color.black, 1));
    }

    public boolean isEditable() {
        if (this._textField == null) {
            return true;
        }
        return this._textField.isEditable();
    }

    public boolean isEnabled() {
        if (this._textField == null) {
            return super.isEnabled();
        }
        return this._textField.isEnabled();
    }

    public boolean isForceRefreshData() {
        return this._forceRefreshData;
    }

    public boolean isPopUpVisible() {
        return this._isPopUpShowing;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this._calendar != null && evt.getPropertyName().equals("calendar")) {
            Object oldValue = this._textField.getValue();
            Calendar calendar = (Calendar)evt.getNewValue();
            String value = this.getValue(calendar);
            this._textField.setValue(value);
            this.populateModel();
            boolean shouldClose = (Boolean)evt.getOldValue();
            if (this._dialog != null && this.getDialog().isVisible()) {
                this.setPopUpVisible(!shouldClose);
            }
        }
    }

    private String getValue(Calendar calendar) {
        int day = calendar.get(5);
        int month = calendar.get(2) + 1;
        int year = calendar.get(1);
        String dayString = String.valueOf(day).toString();
        String monthString = String.valueOf(month).toString();
        String yearString = String.valueOf(year).toString();
        if (dayString.length() != 2) {
            dayString = "0" + dayString;
        }
        if (monthString.length() != 2) {
            monthString = "0" + monthString;
        }
        if (yearString.length() != 4) {
            int count = 4 - yearString.length();
            for (int i = 0; i < count; ++i) {
                yearString = "0" + yearString;
            }
        }
        String value = dayString + "." + monthString + "." + yearString;
        return value;
    }

    public void requestFocus() {
        if (this.getTextField() != null) {
            this.getTextField().requestFocus();
        }
    }

    public void release() {
        if (this._calendar != null) {
            this._calendar.removePropertyChangeListener(this);
            this._calendar.release();
        }
        this._model = null;
    }

    public void setBackground(Color color) {
        if (this.getTextField() != null) {
            this.getTextField().setBackground(color);
        }
    }

    public void setDate(Date date) {
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            this._calendar.setCalendar(cal);
        }
    }

    public void setEditable(boolean value) {
        if (this.getTextField() != null) {
            this.getTextField().setEditable(value);
            this.getTextField().setOpaque(value);
            this.getTextField().setFocusable(value);
        }
        if (this._button != null) {
            this._button.setEditable(value);
        }
    }

    public void setEnabled(boolean value) {
        if (this.getTextField() != null) {
            this.getTextField().setEnabled(value);
            if (!value) {
                this.getTextField().setDisabledTextColor(Color.black);
            }
        }
        if (this._button != null) {
            this._button.setEnabled(value);
        }
    }

    public void setForceRefreshData(boolean newForceRefreshData) {
        this._forceRefreshData = newForceRefreshData;
    }

    public void setForeground(Color color) {
        if (this.getTextField() != null) {
            this.getTextField().setForeground(color);
        }
    }

    private void setPopUpVisible(boolean bool) {
        this._isPopUpShowing = bool;
        this._textField.setEditable(!bool);
        this.getDialog().setVisible(bool);
        if (!bool) {
            this.getDialog().dispose();
            this._dialog = null;
        }
        this._textField.requestFocus();
    }

    private void setPopUpWindowPosition() {
        int popUpWidth;
        Point point = this.getLocationOnScreen();
        Rectangle bounds = this.getBounds();
        Window owner = this.getDialog().getOwner();
        Rectangle ownerBounds = owner.getBounds();
        Dimension screenSize = owner.getToolkit().getScreenSize();
        int endx = point.x;
        int endy = point.y + bounds.height;
        int popUpHeight = fixedPopupWidth != null ? JCalendarPopUp.fixedPopupWidth.height : this._calendar.getPreferredSize().height;
        int n = popUpWidth = fixedPopupWidth != null ? JCalendarPopUp.fixedPopupWidth.width : this.getSize().width;
        if (popUpHeight + endy > screenSize.height) {
            endy = point.y - popUpHeight;
        }
        if (popUpWidth + endx > screenSize.width) {
            endx = screenSize.width - popUpWidth;
        }
        if (endx < 0) {
            endx = 0;
        }
        if (endy < 0) {
            endy = 0;
        }
        if (popUpWidth < 140 && endx > 0) {
            endx -= 140 - popUpWidth;
            popUpWidth += 140 - popUpWidth;
        }
        if (fixedPopupWidth != null) {
            this.getDialog().setBounds(endx + bounds.width - JCalendarPopUp.fixedPopupWidth.width, endy, JCalendarPopUp.fixedPopupWidth.width, JCalendarPopUp.fixedPopupWidth.height);
        } else {
            this.getDialog().setBounds(endx, endy, popUpWidth, popUpHeight);
        }
    }

    public void setRequired(boolean aBoolean) {
    }

    public void setToolTipText(String aText) {
        if (this._textField != null) {
            this._textField.setToolTipText(aText);
        }
    }

    private void showDropDownList() {
        this.showDropDownListOnly();
    }

    private void showDropDownListOnly() {
        this.setPopUpWindowPosition();
        this.showPopUp();
    }

    private Date getNewValue(String value) {
        if (value != null) {
            Date newValue;
            block3: {
                SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
                newValue = null;
                try {
                    newValue = format.parse(value);
                }
                catch (Exception e) {
                    if (!LogRegistry.getInstance().logWarnings()) break block3;
                    LogRegistry.getInstance().warn(this.getClass(), "wrong date: " + value);
                }
            }
            return newValue;
        }
        return null;
    }

    private void showPopUp() {
        Date newValue;
        if (this.isDateValid() && this._textField.getText() != null && !this._textField.getText().equals("  .  .    ") && (newValue = this.getNewValue((String)this._textField.getValue())) != null) {
            this.setDate(newValue);
        }
        this.setPopUpVisible(true);
    }

    private JDialog getDialog() {
        if (this._dialog == null) {
            Window parentWindow = this._model.getDOM().getEditor().getWindow();
            if (parentWindow == null) {
                parentWindow = SwingUtilities.getWindowAncestor(this);
            }
            this._dialog = GUITools.createDialogFor(parentWindow, true);
            ((JAXJDialog)this._dialog).setCloseAtEscape();
            this._dialog.setJMenuBar(null);
            this._dialog.setUndecorated(true);
            this._dialog.setFocusable(false);
            this._dialog.getContentPane().add((Component)this._calendar, "Center");
            GUITools.applySWTSwingModalDialog(this._dialog);
        }
        return this._dialog;
    }

    public void focusGained(FocusEvent e) {
        if (this._textField.getFocusLostBehavior() == 3) {
            this._textField.setFocusLostBehavior(1);
            this._textField.setCaretPosition(0);
        }
    }

    private boolean isDateValid() {
        return this._model == null || !this._model.hasValidationError();
    }

    private void populateModel() {
        String value;
        if (this._textField != null && (value = this._textField.getText()) != null && value.length() > 0) {
            this.firePropertyChange("newDate", null, value);
        }
    }

    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.getTextField() && !e.isTemporary()) {
            if (this._textField.getText().equals("  .  .    ")) {
                this._textField.setFocusLostBehavior(3);
                this.firePropertyChange("calendar", null, "");
            } else {
                this._textField.setFocusLostBehavior(3);
                this.populateModel();
                if (this.isDateValid()) {
                    try {
                        String dateFormatMask = "dd.MM.yyyy";
                        SimpleDateFormat df = new SimpleDateFormat(dateFormatMask);
                        Date date = df.parse(this._textField.getText());
                        if (date != null) {
                            this.setDate(date);
                            this.firePropertyChange("calendar", null, date);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void setText(String text) {
        if (this._textField != null && text != null) {
            this._textField.setText(this.transformISOToDate(text));
        }
    }
}

