/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import com.jaxfront.core.util.TextTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class JTextAreaListRenderer
extends JTextArea
implements ListCellRenderer {
    private Color selectionBackground;
    private Color background;
    private int _highlightFrom = -1;
    private int _highlightTo = -1;
    private int _row = -1;
    private int _fixedWidth = -1;
    private int _fixedHeight = -1;
    Highlighter.HighlightPainter myHighlightPainter = new MyHighlightPainter(Color.red);
    private int _width;

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.width = this._fixedWidth != -1 ? this._fixedWidth : this._width;
        if (this._fixedHeight != -1) {
            dim.height = this._fixedHeight;
        }
        return dim;
    }

    public JTextAreaListRenderer(JList list) {
        this.selectionBackground = list.getSelectionBackground();
        this.background = list.getBackground();
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
    }

    public void setFixedWidth(int width) {
        this._fixedWidth = width;
    }

    public void setFixedHeight(int height) {
        this._fixedHeight = height;
    }

    public Component getListCellRendererComponent(JList list, Object object, int index, boolean isSelected, boolean cellHasFocus) {
        this.setText((String)object);
        this.setBackground(isSelected ? this.selectionBackground : this.background);
        if (isSelected && this._row == index && this._highlightFrom >= 0 && this._highlightTo >= 0) {
            this.highlight(this, this._highlightFrom, this._highlightTo);
        }
        if (this.getText() != null) {
            this._width = TextTools.calculateTextLength((Font)this.getFont(), (String)this.getText());
        }
        return this;
    }

    public void setTextHighlighting(int row, int from, int to) {
        this._highlightFrom = from;
        this._highlightTo = to;
        this._row = row;
    }

    public void highlight(JTextComponent textComp, int from, int to) {
        this.removeHighlights(textComp);
        try {
            Highlighter hilite = textComp.getHighlighter();
            hilite.addHighlight(from, to, this.myHighlightPainter);
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    public void removeHighlights(JTextComponent textComp) {
        Highlighter hilite = textComp.getHighlighter();
        Highlighter.Highlight[] hilites = hilite.getHighlights();
        for (int i = 0; i < hilites.length; ++i) {
            if (!(hilites[i].getPainter() instanceof MyHighlightPainter)) continue;
            hilite.removeHighlight(hilites[i]);
        }
    }

    class MyHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public MyHighlightPainter(Color color) {
            super(color);
        }
    }
}

