/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.TextTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.text.MaskFormatter;

public class JTimeOneField
extends JPanel
implements FocusListener {
    private final String EMPTY_HH_TIME = "  ";
    private final String EMPTY_HH_MM_TIME = "  :  ";
    private final String EMPTY_HH_MM_SS_TIME = "  :  :  ";
    private String _minutes = "00";
    private String _seconds = "00";
    private JFormattedTextField _formattedTextField;
    private Type _model;
    private boolean _useFormatter;

    public JTimeOneField(boolean useErrorSound, Type model, boolean useFormatter) {
        this._model = model;
        this._useFormatter = useFormatter;
        this.initView();
    }

    protected void initView() {
        this.setLayout(new BorderLayout());
        this.add(this.getPanelTime());
    }

    public void addFocusListener(FocusListener focusListener) {
        if (this._formattedTextField != null) {
            this._formattedTextField.addFocusListener(focusListener);
        }
    }

    public void addKeyListener(KeyListener focusListener) {
        if (this._formattedTextField != null) {
            this._formattedTextField.addKeyListener(focusListener);
        }
    }

    public void removeFocusListener(FocusListener focusListener) {
        if (this._formattedTextField != null) {
            this._formattedTextField.removeFocusListener(focusListener);
        }
    }

    public void removeKeyListener(KeyListener focusListener) {
        if (this._formattedTextField != null) {
            this._formattedTextField.removeKeyListener(focusListener);
        }
    }

    private JPanel getPanelTime() {
        JPanel panelTime = new JPanel();
        panelTime.setLayout(new BorderLayout());
        if (this._useFormatter) {
            MaskFormatter formatter = null;
            String timeFormat = this._model.getXUIDefinition().getStyle().getTimeFormat();
            if (timeFormat.length() > 0) {
                block15: {
                    try {
                        if (timeFormat.equals("hh:mm:ss'Z'")) {
                            formatter = new MaskFormatter("##:##:##*##:##");
                            formatter.setValidCharacters("0123456789+-");
                        } else if (timeFormat.equals("hh:mm:ss")) {
                            formatter = new MaskFormatter("##:##:##******");
                        } else if (timeFormat.equals("hh:mm")) {
                            formatter = new MaskFormatter("##:##");
                        } else if (timeFormat.equals("hh")) {
                            formatter = new MaskFormatter("##");
                        } else if (LogRegistry.getInstance().logInfos()) {
                            LogRegistry.getInstance().info(this.getClass(), "not valid timeFormat");
                        }
                    }
                    catch (Exception e) {
                        if (!LogRegistry.getInstance().logInfos()) break block15;
                        LogRegistry.getInstance().info(this.getClass(), e.getMessage());
                    }
                }
                if (formatter != null) {
                    formatter.setAllowsInvalid(false);
                    formatter.setOverwriteMode(true);
                    formatter.setCommitsOnValidEdit(true);
                }
            }
            this._formattedTextField = formatter != null ? new JFormattedTextField(formatter) : new JFormattedTextField();
        } else {
            this._formattedTextField = new JFormattedTextField();
        }
        this._formattedTextField.addFocusListener(this);
        this._formattedTextField.setFocusLostBehavior(3);
        panelTime.add((Component)this._formattedTextField, "Center");
        return panelTime;
    }

    public JFormattedTextField getTimeField() {
        return this._formattedTextField;
    }

    private String getTimeFormat() {
        String time = "";
        time = this._formattedTextField.getText();
        if (time.equals("  ") || time.equals("  :  ") || time.equals("  :  :  ")) {
            return null;
        }
        String newTime = "";
        try {
            this._formattedTextField.commitEdit();
        }
        catch (ParseException ex) {
            time = newTime = TextTools.replace((String)time, (String)" ", (String)"0");
        }
        if (time != null) {
            if (time.length() == 2) {
                time = time + ":" + this._minutes + ":" + this._seconds;
            } else if (time.length() == 5) {
                time = time + ":" + this._seconds;
            }
        }
        return time;
    }

    public String getTime() {
        return this.getTimeFormat();
    }

    public void setTime(String time) {
        this._formattedTextField.setValue(time);
    }

    public void setBackground(Color color) {
        if (this._formattedTextField != null && color != null) {
            this._formattedTextField.setBackground(color);
        }
    }

    public void setFont(Font font) {
    }

    public void setForeground(Color fg) {
    }

    public void setEnabled(boolean enabled) {
        if (this._formattedTextField != null) {
            this._formattedTextField.setEnabled(enabled);
        }
    }

    public void setEditable(boolean editable) {
        if (this._formattedTextField != null) {
            this._formattedTextField.setEditable(editable);
            this._formattedTextField.setOpaque(editable);
            this._formattedTextField.setFocusable(editable);
            if (editable) {
                this.setBackground(this._formattedTextField.getBackground());
            }
        }
    }

    public void focusLost(FocusEvent e) {
        if (e.getSource() == this._formattedTextField && !e.isTemporary()) {
            if (this._formattedTextField.getText().equals("  ") || this._formattedTextField.getText().equals("  :  ") || this._formattedTextField.getText().equals("  :  :  ")) {
                this._formattedTextField.setFocusLostBehavior(3);
            }
            this.firePropertyChange("time", null, null);
        }
    }

    public void focusGained(FocusEvent e) {
        if (this._formattedTextField.getFocusLostBehavior() == 3) {
            this._formattedTextField.setFocusLostBehavior(1);
        }
    }
}

