/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.editor;

import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.JFrame;

public abstract class AbstractFrame
extends JFrame
implements WindowListener {
    private JComponent _workSpace;
    private JComponent _menuBar;
    private JComponent _statusBar;
    private JComponent _toolBar;
    private JComponent _buttonBar;
    private FormLayout _frameLayout;

    public AbstractFrame() {
        this.addWindowListener(this);
    }

    protected void initializeFrame() {
        this._frameLayout = new FormLayout("f:p:g", "f:p:g");
        this.getContentPane().setLayout(this._frameLayout);
        this.initializeActions();
        this.initializeDecoration();
        this.initializeMenuBar();
        JComponent toolBar = this.initializeToolBar();
        JComponent workSpace = this.initializeWorkspace();
        JComponent buttonBar = this.initializeButtonBar();
        JComponent statusBar = this.initializeStatusBar();
        if (toolBar != null) {
            this.setToolBar(toolBar, "f:p");
        }
        if (workSpace != null) {
            this.setWorkspace(workSpace, "f:p:g");
        }
        if (buttonBar != null) {
            this.setButtonBar(buttonBar, "f:p");
        }
        if (statusBar != null) {
            this.setStatusBar(statusBar, "f:p");
        }
    }

    protected void initializeActions() {
    }

    protected void initializeDecoration() {
    }

    protected void initializeMenuBar() {
    }

    protected JComponent initializeToolBar() {
        return null;
    }

    protected abstract JComponent initializeWorkspace();

    protected JComponent initializeButtonBar() {
        return null;
    }

    protected JComponent initializeStatusBar() {
        return null;
    }

    public JComponent getWorkspace() {
        return this._workSpace;
    }

    public JComponent getButtonBar() {
        return this._buttonBar;
    }

    public JComponent getStatusBar() {
        return this._statusBar;
    }

    public JComponent getToolBar() {
        return this._toolBar;
    }

    public void setWorkspace(JComponent workspace, String constraints) {
        if (this._workSpace != null) {
            this.getContentPane().remove(this._workSpace);
        }
        this._workSpace = workspace;
        if (this._workSpace != null) {
            this.addComponentToFrame(workspace, 2, constraints);
        }
    }

    public void setToolBar(JComponent toolBar, String constraints) {
        if (this._toolBar != null) {
            this.getContentPane().remove(this._toolBar);
        }
        this._toolBar = toolBar;
        if (this._toolBar != null) {
            this.addComponentToFrame(toolBar, 1, constraints);
        }
    }

    public void setButtonBar(JComponent buttonBar, String constraints) {
        if (this._buttonBar != null) {
            this._frameLayout.removeLayoutComponent(this._buttonBar);
        }
        this._buttonBar = buttonBar;
        if (this._buttonBar != null) {
            this.addComponentToFrame(buttonBar, 3, constraints);
        }
    }

    public void setStatusBar(JComponent statusBar, String constraints) {
        if (this._statusBar != null) {
            this.getContentPane().remove(this._statusBar);
        }
        this._statusBar = statusBar;
        if (this._statusBar != null) {
            this.addComponentToFrame(statusBar, 4, constraints);
        }
    }

    public void setMenuBar(JComponent menuBar) {
        if (this._menuBar != null) {
            this.remove(this._menuBar);
        }
        this._menuBar = menuBar;
        if (this._menuBar != null) {
            this.setMenuBar(this._menuBar);
        }
    }

    public void center() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = this.getSize().width;
        int h = this.getSize().height;
        int x = (dim.width - w) / 2;
        int y = (dim.height - h) / 2;
        this.setLocation(x, y);
    }

    public void setFullScreen(boolean fullScreen) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        if (gs.isFullScreenSupported()) {
            if (fullScreen) {
                gs.setFullScreenWindow(this);
            } else {
                gs.setFullScreenWindow(null);
            }
            this.validate();
        }
    }

    private void addComponentToFrame(JComponent component, int position, String constraints) {
        if (component != null) {
            int numberOfRows = this._frameLayout.getRowCount();
            if (constraints == null) {
                constraints = "f:p";
            }
            RowSpec rowSpec = new RowSpec(constraints);
            if (this.getContentPane().getComponentCount() == 0) {
                this._frameLayout.appendRow(rowSpec);
                this.getContentPane().add((Component)component, "1,2");
                this._frameLayout.removeRow(1);
            } else if (position > numberOfRows) {
                this._frameLayout.appendRow(rowSpec);
                this.getContentPane().add((Component)component, "1," + ++numberOfRows);
            } else {
                this._frameLayout.insertRow(position, rowSpec);
                this.getContentPane().add((Component)component, "1," + position);
            }
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

