/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.editor;

import com.jaxfront.core.dom.DOMBuilder;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.SchemaCreationException;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.schema.XMLSchema;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.JAXFrontURLEntityResolver;
import com.jaxfront.core.util.LastFile;
import com.jaxfront.swing.ui.editor.FileLocationChooser;
import com.jaxfront.swing.ui.tools.Dialog;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ChooserTab
extends JPanel
implements PropertyChangeListener,
ItemListener {
    protected Hashtable _lastFiles;
    public String _rootName;
    private XMLSchema _schema;
    protected FileLocationChooser _xsdChooser;
    protected FileLocationChooser _xmlChooser;
    protected FileLocationChooser _xuiChooser;
    protected JComboBox _rootNameChooser;
    protected Vector _foundRoots;
    private boolean _resolveWSDL;
    private AbstractAction _loadAction = null;
    private boolean _useRemoteLoader;

    public ChooserTab(boolean useRemoteLoader, Vector lastFiles, FileLocationChooser xsdChooser, FileLocationChooser xmlChooser, FileLocationChooser xuiChooser, Vector rootNames, boolean resolveWSDL) {
        this._useRemoteLoader = useRemoteLoader;
        this.initLastFiles(lastFiles);
        this._resolveWSDL = resolveWSDL;
        this._xsdChooser = xsdChooser;
        this._xmlChooser = xmlChooser;
        this._xuiChooser = xuiChooser;
        this.init();
    }

    public String getSelectedRootName() {
        return (String)this._rootNameChooser.getSelectedItem();
    }

    public static Vector getSchemaGlobals(XMLSchema schema) {
        Map globalEntities = schema.getGlobalElements();
        Vector<String> globals = new Vector<String>(globalEntities.size());
        Iterator globalCollection = globalEntities.values().iterator();
        while (globalCollection.hasNext()) {
            String name = ((SchemaNode)globalCollection.next()).getName();
            globals.add(name);
        }
        for (int i = globals.size() / 2; i > 0; i /= 2) {
            for (int j = i; j < globals.size(); ++j) {
                int k;
                String temp = (String)globals.get(j);
                for (k = j; k >= i && temp.compareTo((String)globals.get(k - i)) < 0; k -= i) {
                    globals.setElementAt((String)globals.get(k - i), k);
                }
                globals.setElementAt(temp, k);
            }
        }
        return globals;
    }

    public FileLocationChooser getXMLChooser() {
        return this._xmlChooser;
    }

    public FileLocationChooser getXSDChooser() {
        return this._xsdChooser;
    }

    public FileLocationChooser getXUIChooser() {
        return this._xuiChooser;
    }

    private void initLastFiles(Vector lastFiles) {
        this._lastFiles = new Hashtable();
        for (int i = lastFiles.size() - 1; i >= 0; --i) {
            LastFile lastFile = (LastFile)lastFiles.get(i);
            if (lastFile.getXsdURL() == null) continue;
            this._lastFiles.put(this.formatUrl(lastFile.getXsdURL().toExternalForm()), lastFile);
        }
    }

    protected void init() {
        FormLayout newLayout = new FormLayout("f:p", "f:p,10,f:p,10,f:p,10,f:p");
        this.setLayout(newLayout);
        this.setBorder(null);
        this._xsdChooser.addPropertyChangeListener(this);
        this._rootNameChooser = new JComboBox();
        this._rootNameChooser.addItemListener(this);
        if (this.getXSDChooser().getURL() == null) {
            this._rootNameChooser.setEnabled(false);
        } else {
            this.initComboBox(this.getXSDChooser().getURL(), true);
            if (this._rootName != null) {
                this._rootNameChooser.setSelectedItem(this._rootName);
            } else if (!this._foundRoots.isEmpty()) {
                this._rootName = (String)this._foundRoots.firstElement();
                this._rootNameChooser.setSelectedItem(this._rootName);
            }
        }
        FormLayout rootNameLayout = new FormLayout("113,r:15,310,40", "f:p");
        JPanel rootNamePanel = new JPanel(rootNameLayout);
        rootNamePanel.add((Component)new JLabel(GUIComponentNLS.getInstance().getNLSText("tree_root_name", "Root Node") + ":"), "1,1");
        rootNamePanel.add((Component)this._rootNameChooser, "3,1");
        this.add((Component)((JComponent)((Object)this._xsdChooser)), "1,1");
        this.add((Component)rootNamePanel, "1,3");
        if (this._xmlChooser != null) {
            this.add((Component)((JComponent)((Object)this._xmlChooser)), "1,5");
        }
        if (this._xuiChooser != null) {
            this.add((Component)((JComponent)((Object)this._xuiChooser)), "1,7");
        }
    }

    private String formatUrl(String url) {
        return url;
    }

    protected void initComboBox(URL url, boolean initializeLastFiles) {
        LastFile lastFile = (LastFile)this._lastFiles.get(this.formatUrl(url.toExternalForm()));
        if (lastFile != null) {
            this._rootName = lastFile.getRootName();
            if (this._xmlChooser != null) {
                if (lastFile.getXmlURL() != null) {
                    this._xmlChooser.setEnabled(true);
                    this._xmlChooser.setSelectedItem(this.formatUrl(lastFile.getXmlURL().toExternalForm()));
                } else {
                    this._xmlChooser.setEnabled(false);
                }
            }
            if (this._xuiChooser != null) {
                if (lastFile.getXuiURL() != null) {
                    this._xuiChooser.setEnabled(true);
                    this._xuiChooser.setSelectedItem(this.formatUrl(lastFile.getXuiURL().toExternalForm()));
                } else {
                    this._xuiChooser.setEnabled(false);
                }
            }
        } else {
            this._rootName = null;
            if (this._xmlChooser != null) {
                this._xmlChooser.setSelectedItem("");
            }
            if (this._xuiChooser != null) {
                this._xuiChooser.setSelectedItem("");
            }
        }
        this.inititializeXSD(url);
        if (this._foundRoots != null) {
            this._foundRoots.removeAllElements();
        } else {
            this._foundRoots = new Vector();
        }
        if (this._schema != null) {
            Vector schemaGlobals = ChooserTab.getSchemaGlobals(this._schema);
            Iterator iterator = JAXFrontProperties.getInstance().getLastFiles().iterator();
            while (iterator.hasNext()) {
                LastFile temp = (LastFile)iterator.next();
                String root = temp.getRootName();
                if (schemaGlobals == null || !schemaGlobals.contains(root)) continue;
                this._foundRoots.add(root);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this._xsdChooser.getURL() != null) {
            this.initComboBox(this._xsdChooser.getURL(), false);
            if (this._rootName != null && this._foundRoots.contains(this._rootName)) {
                this._rootNameChooser.setSelectedItem(this._rootName);
            } else if (!this._foundRoots.isEmpty()) {
                this._rootName = (String)this._foundRoots.firstElement();
                this._rootNameChooser.setSelectedItem(this._rootName);
            }
        } else {
            this._rootNameChooser.setEnabled(false);
        }
    }

    public static ChooserTab createInstance(Vector xsdFiles, Vector xmlFiles, Vector xuiFiles) {
        return null;
    }

    public void load() {
        if (this.getLoadAction() != null) {
            this.getLoadAction().actionPerformed(new ActionEvent(this, 0, "load"));
        } else {
            this.inititializeXSD(this.getXSDChooser().getURL());
            if (this.getSelectedRootName() != null) {
                this._schema.setRootName(this.getSelectedRootName());
            }
        }
    }

    public void refreshXSD() {
        this.inititializeXSD(this._xsdChooser.getURL());
    }

    private void inititializeXSD(URL url) {
        block10: {
            try {
                if (this._resolveWSDL) {
                    this.resolveWSDL(url);
                } else {
                    Hashtable<String, JAXFrontURLEntityResolver> args = new Hashtable<String, JAXFrontURLEntityResolver>();
                    if (this._useRemoteLoader) {
                        args.put("XMLEntityResolver", new JAXFrontURLEntityResolver(url));
                    }
                    this._schema = DOMBuilder.getInstance().getSchemaBuilder().build(null, url, this._rootName, args);
                }
            }
            catch (SchemaCreationException ex) {
                if (ex.getMessage().indexOf("Specified root name") != -1) {
                    this._rootName = null;
                    this.inititializeXSD(url);
                }
                Dialog.showErrorDialog(this, "unable to create XMLSchema from URL: " + url);
                if (!LogRegistry.getInstance().logWarnings()) break block10;
                LogRegistry.getInstance().warn(this.getClass(), "unable to create XMLSchema from URL: " + url);
            }
        }
        if (this._schema != null) {
            Vector schemaGlobals = ChooserTab.getSchemaGlobals(this._schema);
            this._rootNameChooser.setModel(new DefaultComboBoxModel(schemaGlobals));
            this._rootNameChooser.setEnabled(true);
            if (this._rootName != null) {
                this._rootNameChooser.setSelectedItem(this._rootName);
            } else {
                this._rootNameChooser.setSelectedItem(this._schema.getRootName());
            }
            File xsdDirectory = new File(this.getXSDChooser().getURL().getFile());
            this.getXMLChooser().setDefaultDirectory(xsdDirectory);
            this.getXUIChooser().setDefaultDirectory(xsdDirectory);
        } else {
            this._rootNameChooser.setEnabled(false);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this._rootNameChooser) {
            String item;
            this._rootName = item = (String)e.getItem();
        }
    }

    private void resolveWSDL(URL url) {
    }

    public void setLoadAction(AbstractAction _loadAction) {
        this._loadAction = _loadAction;
    }

    private AbstractAction getLoadAction() {
        return this._loadAction;
    }
}

