/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public class MemoryIndicatorPanel
extends JPanel
implements MouseListener {
    public static int yOffset = 2;
    public static int yOffset2 = 4;
    public static int xOffset = 2;
    int preferedHeight = 16;

    public MemoryIndicatorPanel() {
        this.addMouseListener(this);
        this.setVisible(true);
        Thread thread = new Thread(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(1000L);
                            MemoryIndicatorPanel.this.paint(MemoryIndicatorPanel.this.getGraphics());
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        };
        thread.start();
    }

    public void paint(Graphics g) {
        if (g != null) {
            long freeMemory = Runtime.getRuntime().freeMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            long maxMemory = Runtime.getRuntime().maxMemory();
            long memoryUsed = totalMemory - freeMemory;
            Insets insets = this.getInsets();
            int width = this.getWidth() - insets.left - insets.right;
            int height = this.getHeight() - insets.top - insets.bottom;
            int x0 = insets.left;
            int x1 = insets.left + (int)((long)width * memoryUsed / maxMemory);
            int x2 = insets.left + (int)((long)width * totalMemory / maxMemory);
            int x3 = insets.left + width;
            int y0 = insets.top;
            int y1 = insets.top + height;
            Graphics2D g2d = (Graphics2D)g;
            Paint oldPaint = g2d.getPaint();
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, height, Color.green));
            g2d.fillRect(x0 + xOffset, y0 + yOffset, x1, y1 - yOffset2);
            g2d.setPaint(oldPaint);
            g2d.setColor(new Color(0x999999));
            g2d.fillRect(x1 + xOffset, y0 + yOffset, x2, y1 - yOffset2);
            g2d.setColor(this.getBackground());
            g2d.fillRect(x2 + xOffset, y0 + yOffset, x3, y1 - yOffset2);
            g.setFont(this.getFont());
            g.setColor(Color.black);
            g.drawString(memoryUsed / 0x100000L + " of " + maxMemory / 0x100000L + "M", x0 + xOffset, 15);
            FontMetrics fm = g.getFontMetrics();
            this.preferedHeight = fm.getHeight();
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            System.gc();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (dim.getHeight() < (double)this.preferedHeight) {
            dim.setSize(dim.getWidth(), (double)this.preferedHeight);
        }
        return dim;
    }

    public void mouseReleased(MouseEvent e) {
    }
}

