/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.editor;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.LicenseChecker;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.swing.ui.tools.FontTools;
import com.jaxfront.swing.ui.tools.ShadowedWindow;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JWindow;

public class SplashScreen
extends Canvas {
    private String progressText;
    private FontMetrics fm;
    private JWindow win;
    private Image image;
    private Image offscreenImg;
    private Graphics offscreenGfx;
    private int progress;
    private static final int PROGRESS_HEIGHT = 20;
    private boolean drawVersionNumber = true;
    private Point _infoPoint;
    private Point _infoPointVersionNumber;
    private String _versionNumber;

    public SplashScreen(String imageName, boolean drawVersionNumber) {
        this(imageName, drawVersionNumber, new Point(128, 72), null, null);
    }

    public SplashScreen(String imageName, boolean drawVersionNumber, Point infoPoint, Point versionNumberPoint, String versionNumber) {
        this.drawVersionNumber = drawVersionNumber;
        this._infoPointVersionNumber = versionNumberPoint;
        this._versionNumber = versionNumber;
        this._infoPoint = infoPoint;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setBackground(Color.white);
        Font font = new Font("Dialog", 0, 10);
        this.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.image = JAXFrontProperties.getImage((String)imageName);
        if (this.image != null) {
            block6: {
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(this.image, 0);
                try {
                    tracker.waitForAll();
                }
                catch (Exception e) {
                    if (!LogRegistry.getInstance().logLogs()) break block6;
                    LogRegistry.getInstance().log(this.getClass(), e.getMessage());
                }
            }
            BufferedImage bufferedImage = null;
            try {
                URL imageURL = URLHelper.getUserURL((String)imageName);
                if (imageURL == null) {
                    imageURL = URLHelper.getUserURL((String)"com/jaxfront/core/images/files/jaxfront.gif");
                }
                bufferedImage = ImageIO.read(URLHelper.openStream((URL)imageURL));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.win = new ShadowedWindow((Window)new Frame(), bufferedImage);
            Dimension screen = this.getToolkit().getScreenSize();
            Dimension size = new Dimension(this.image.getWidth(this) + 2, this.image.getHeight(this) + 2 + 20);
            this.win.setSize(size);
            this.win.getContentPane().setLayout(new BorderLayout());
            this.win.getContentPane().add("Center", this);
            this.win.setLocation((screen.width - size.width) / 2, (screen.height - size.height) / 2);
            this.win.validate();
            this.win.show();
        }
    }

    public void dispose() {
        this.win.dispose();
    }

    public synchronized void advance(String text) {
        this.progressText = text;
        ++this.progress;
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public synchronized void paint(Graphics g) {
        Dimension size = this.getSize();
        if (this.offscreenImg == null) {
            this.offscreenImg = this.createImage(size.width, size.height);
            this.offscreenGfx = this.offscreenImg.getGraphics();
            this.offscreenGfx.setFont(this.getFont());
        }
        this.offscreenGfx.setColor(Color.gray);
        this.offscreenGfx.draw3DRect(0, 0, size.width - 1, size.height - 1, true);
        this.offscreenGfx.drawImage(this.image, 1, 1, this);
        this.offscreenGfx.setColor(new Color(30, 97, 26));
        this.offscreenGfx.fill3DRect(1, this.image.getHeight(this) + 1, (this.win.getWidth() - 2) * this.progress / 5, 20, true);
        if (this.progressText != null) {
            this.offscreenGfx.setFont(this.getFont());
            this.offscreenGfx.setColor(Color.WHITE);
            this.offscreenGfx.drawString(this.progressText, 5, this.image.getHeight(this) + 20 - 5);
        }
        if (this.drawVersionNumber) {
            Point versionPoint = this._infoPoint;
            if (this._infoPointVersionNumber != null) {
                versionPoint = this._infoPointVersionNumber;
            }
            String versionNumber = Document.getXUIVersionNo();
            if (this._versionNumber != null) {
                versionNumber = this._versionNumber;
            }
            this.offscreenGfx.setColor(Color.darkGray);
            this.offscreenGfx.setFont(FontTools.getBoldFont(20.0f));
            this.offscreenGfx.drawString("V" + versionNumber, versionPoint.x, versionPoint.y);
            if (this._versionNumber == null) {
                this.offscreenGfx.setColor(Color.darkGray);
                this.offscreenGfx.setFont(FontTools.getBoldFont(12.0f));
                this.offscreenGfx.drawString("Build: " + Document.getBuildVersion(), versionPoint.x, versionPoint.y + 18);
            }
            if (LicenseChecker.getInstance().hasValidLicense()) {
                this.offscreenGfx.setColor(Color.darkGray);
                this.offscreenGfx.setFont(FontTools.getBoldFont(10.0f));
                this.offscreenGfx.drawString("Licensed to: ", versionPoint.x, versionPoint.y + 54);
                this.printLicense(this.offscreenGfx, versionPoint);
            }
        }
        String copyrightInfo = "(c) 2001-2010 xcentric technology GmbH.";
        this.offscreenGfx.setColor(Color.GRAY);
        this.offscreenGfx.setFont(FontTools.getPlainFont(9.0f));
        this.offscreenGfx.drawString(copyrightInfo, this._infoPoint.x, this._infoPoint.y + 120);
        String jaxfront = "http://www.jaxfront.com";
        this.offscreenGfx.setColor(Color.GRAY);
        this.offscreenGfx.setFont(FontTools.getPlainFont(9.0f));
        this.offscreenGfx.drawString(jaxfront, this._infoPoint.x, this._infoPoint.y + 133);
        g.drawImage(this.offscreenImg, 0, 0, this);
        this.notify();
    }

    private void printLicense(Graphics offscreenGfx, Point point) {
        offscreenGfx.setColor(Color.GRAY);
        int x = point.x;
        int y = point.y + 64;
        StringBuffer info = new StringBuffer();
        String customer = LicenseChecker.getLicense().Customer;
        boolean openBracket = false;
        if (customer != null) {
            String[] lines = TextTools.tokenize((String)customer, (String)",(");
            for (int i = 0; i < lines.length; ++i) {
                if (i > 3) continue;
                String line = lines[i];
                if (i > 0) {
                    info.append("<br/>");
                }
                if (i == 0) {
                    offscreenGfx.setFont(FontTools.getBoldFont(10.0f));
                    offscreenGfx.drawString(line, x, y);
                } else {
                    offscreenGfx.setFont(FontTools.getPlainFont(10.0f));
                    offscreenGfx.drawString(line, x, y);
                }
                y += 12;
            }
        }
    }
}

