/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.editor;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.ValidationException;
import com.jaxfront.core.type.ComplexGroup;
import com.jaxfront.core.type.ComplexGroupList;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleGroup;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.ValidationChangeEvent;
import com.jaxfront.core.type.ValidationChangeListener;
import com.jaxfront.core.ui.ListVisualizer;
import com.jaxfront.core.ui.TabbableView;
import com.jaxfront.core.ui.TreeNode;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.io.FileSelector;
import com.jaxfront.swing.ui.beans.MessageTable;
import com.jaxfront.swing.ui.editor.AbstractEditorPanel;
import com.jaxfront.swing.ui.editor.ErrorMessageStatusBar;
import com.jaxfront.swing.ui.tools.Dialog;
import com.jaxfront.swing.ui.tools.GUITools;
import com.jaxfront.swing.ui.tools.UITree;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import com.jaxfront.swing.ui.visualizers.AbstractView;
import com.jaxfront.swing.ui.visualizers.ComplexGroupListView;
import com.jaxfront.swing.ui.visualizers.SimpleGroupListView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class TypeWorkspace
extends JPanel
implements ActionListener,
ValidationChangeListener {
    private static final int HORIZONTAL_SCROLLBAR_OUTER_SCROLL_STEP = 25;
    private static final int VERTICAL_SCROLLBAR_OUTER_SCROLL_STEP = 25;
    private static final int HORIZONTAL_SCROLLBAR_INNER_SCROLL_STEP = 200;
    private static final int VERTICAL_SCROLLBAR_INNER_SCROLL_STEP = 200;
    private JPanel _headerPanel;
    private JLabel _headerLabel;
    private Document _DOM;
    private Visualizer _lastViewHolder;
    private JScrollPane _scrollPane;
    private JPanel _southPanel;
    private JPanel _buttonPanel;
    private JPanel _westPanel;
    private JPanel _eastPanel;
    private JPanel _centerPanel;
    private JPanel _innerCenterPanel;
    private JPanel _messageTablePanel;
    private MessageTable _messageTable;
    private AbstractEditorPanel _editor;
    private JButton _saveButton;
    private JButton _cancelButton;
    private JButton _backwardButton;
    private JButton _forwardButton;
    private Action _saveAction = null;
    private Action _cancelAction = null;
    private Action _forwardAction = null;
    private Action _backwardAction = null;
    private Type _lastVisualizedType = null;
    private ErrorMessageStatusBar _statusBar;
    private KeyboardFocusManager _keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
    private KeyEventDispatcher _keyEventDispatcher;
    public static final int WEST = 1;
    public static final int EAST = 2;

    public TypeWorkspace(AbstractEditorPanel editor) {
        super(new BorderLayout());
        this._editor = editor;
        this._DOM = this._editor.getDOM();
        this.init();
    }

    public Action getSaveAction() {
        if (this._saveAction == null) {
            this._saveAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        if (!TypeWorkspace.this._DOM.getGlobalDefinition().isAllowingSavingWithErrors()) {
                            TypeWorkspace.this._DOM.validate();
                            if (TypeWorkspace.this._DOM.getController().getErrorController().hasValidationErrors()) {
                                return;
                            }
                        }
                        FileSelector selector = new FileSelector("Export Help Information");
                        selector.setCurrentFileFilter("xml", ".xml", false);
                        selector.setRootDir(new File(JAXFrontProperties.getInstance().getLastOpenedFolder().getFile()));
                        selector.showSaveDialog((Component)TypeWorkspace.this);
                        if (selector.getSelectedFile() == null) {
                            return;
                        }
                        TypeWorkspace.this._DOM.saveAs(selector.getSelectedFile());
                    }
                    catch (ValidationException ex) {
                        LogRegistry.getInstance().error(this.getClass(), (Exception)((Object)ex));
                    }
                    catch (IOException ie) {
                        Dialog.showErrorDialog(ie.getMessage());
                    }
                }
            };
        }
        return this._saveAction;
    }

    public void setSaveAction(Action action) {
        if (this._saveAction != null && this._saveButton != null) {
            this._saveButton.removeActionListener(this._saveAction);
            this._saveButton.addActionListener(action);
        }
        this._saveAction = action;
    }

    public Action getCancelAction() {
        if (this._cancelAction == null) {
            this._cancelAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    TypeWorkspace.this._DOM.cancelInstance();
                    if (TypeWorkspace.this._DOM.systemExitOnClose()) {
                        System.exit(0);
                    }
                }
            };
        }
        return this._cancelAction;
    }

    public void setCancelAction(Action action) {
        if (this._cancelAction != null && this._cancelButton != null) {
            this._cancelButton.removeActionListener(this._cancelAction);
            this._cancelButton.addActionListener(action);
        }
        this._cancelAction = action;
    }

    public Action getForwardAction() {
        if (this._forwardAction == null) {
            this._forwardAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    TypeWorkspace.this.visualizeNextNode();
                }
            };
        }
        return this._cancelAction;
    }

    public void setForwardAction(Action action) {
        if (this._forwardAction != null && this._forwardButton != null) {
            this._forwardButton.removeActionListener(this._forwardAction);
            this._forwardButton.addActionListener(action);
        }
        this._forwardAction = action;
    }

    public Action getBackwardAction() {
        if (this._backwardAction == null) {
            this._backwardAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    TypeWorkspace.this.visualizePreviousNode();
                }
            };
        }
        return this._backwardAction;
    }

    public void setBackwardAction(Action action) {
        if (this._backwardAction != null && this._backwardButton != null) {
            this._backwardButton.removeActionListener(this._backwardAction);
            this._backwardButton.addActionListener(action);
        }
        this._backwardAction = action;
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void addButton(JButton button) {
        this.addButton(button, 1);
    }

    public void addButton(JButton button, int orientation) {
        if (this._DOM.isUsingButtonBar()) {
            if (orientation == 1) {
                this._westPanel.add(button);
            } else if (orientation == 2) {
                this._eastPanel.add(button);
            } else {
                LogRegistry.getInstance().warn(this.getClass(), "unable to add button because of bad orientation (" + orientation + ")");
            }
        }
    }

    public Document getDOM() {
        return this._DOM;
    }

    protected void init() {
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this.setFocusable(false);
        this._centerPanel = new JPanel(new BorderLayout());
        this._centerPanel.setFocusable(false);
        EmptyBorder emptyBorder = (EmptyBorder)BorderFactory.createEmptyBorder();
        if (this._DOM.getVerticalScrollBarPolicy() == -99 && this._DOM.getGlobalDefinition().getHorizontalScrollBarPolicy() == -99) {
            this.add((Component)this._centerPanel, "Center");
        } else {
            this._scrollPane = new JScrollPane(this._centerPanel, this._DOM.getVerticalScrollBarPolicy(), this._DOM.getGlobalDefinition().getHorizontalScrollBarPolicy());
            JScrollBar verticalScrollBar = new JScrollBar(1);
            JScrollBar horizontalScrollBar = new JScrollBar(0);
            verticalScrollBar.setUnitIncrement(25);
            verticalScrollBar.setBlockIncrement(200);
            horizontalScrollBar.setUnitIncrement(25);
            horizontalScrollBar.setBlockIncrement(200);
            this._scrollPane.setVerticalScrollBar(verticalScrollBar);
            this._scrollPane.setHorizontalScrollBar(horizontalScrollBar);
            this._scrollPane.setBorder(emptyBorder);
            this._scrollPane.getViewport().setBorder(null);
            this._scrollPane.setFocusable(false);
            this._scrollPane.getViewport().setFocusable(false);
            this._scrollPane.getVerticalScrollBar().setFocusable(false);
            this._scrollPane.getHorizontalScrollBar().setFocusable(false);
            this.add((Component)this._scrollPane, "Center");
        }
        this._southPanel = new JPanel();
        this._southPanel.setBorder(null);
        this._southPanel.setLayout(new BoxLayout(this._southPanel, 1));
        this._southPanel.setFocusable(false);
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.setFocusable(false);
        this._DOM.getController().getErrorController().addValidationChangeListener((ValidationChangeListener)this);
        if (this.isTopLevelEditor()) {
            EtchedBorder etchedBorder;
            if (this._DOM.isUsingStatusBar()) {
                this._statusBar = new ErrorMessageStatusBar(this, this._editor);
                statusPanel.add((Component)this._statusBar, "South");
                this._southPanel.add(statusPanel);
                etchedBorder = (EtchedBorder)BorderFactory.createEtchedBorder();
                this._southPanel.setBorder(etchedBorder);
            }
            if (this._DOM.isUsingButtonBar()) {
                etchedBorder = (EtchedBorder)BorderFactory.createEtchedBorder();
                this._southPanel.setBorder(etchedBorder);
                this.initializeButtonBar();
                this._buttonPanel.setBorder(emptyBorder);
                this._southPanel.add(this._buttonPanel);
            }
        }
        this.add((Component)this._southPanel, "South");
        this.add((Component)this.getHeaderPanel(), "North");
        this.clearWorkbench();
        if (this._editor != null && this.getDOM().getGlobalDefinition().isUsingNavigationKeys()) {
            this._keyboardFocusManager.addKeyEventDispatcher(this.getKeyEventDispatcher());
        }
    }

    public JScrollPane getScrollPane() {
        return this._scrollPane;
    }

    private void initializeButtonBar() {
        this._buttonPanel = new JPanel(new BorderLayout());
        this._buttonPanel.setFocusable(false);
        this._westPanel = new JPanel();
        this._westPanel.setFocusable(false);
        this._westPanel.setLayout(new BoxLayout(this._westPanel, 0));
        this._eastPanel = new JPanel();
        this._eastPanel.setFocusable(false);
        this._eastPanel.setLayout(new BoxLayout(this._eastPanel, 0));
        this._saveButton = new JButton(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_save", "Save"));
        this._cancelButton = new JButton(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_cancel", "Cancel"));
        this._saveButton.addActionListener(this.getSaveAction());
        this._cancelButton.addActionListener(this.getCancelAction());
        if (this._DOM.isUsingBackwardButton()) {
            this._backwardButton = new JButton("<<");
            this._backwardButton.addActionListener(this.getBackwardAction());
            this._westPanel.add(this._backwardButton);
        }
        this._westPanel.add((Component)this._saveButton, "West");
        this._eastPanel.add((Component)this._cancelButton, "East");
        if (this._DOM.isUsingForwardButton()) {
            this._forwardButton = new JButton(">>");
            this._forwardButton.addActionListener(this.getForwardAction());
            this._eastPanel.add(this._forwardButton);
        }
        this._buttonPanel.add((Component)this._westPanel, "West");
        this._buttonPanel.add((Component)this._eastPanel, "East");
        this.add((Component)this._buttonPanel, "South");
    }

    private boolean isTopLevelEditor() {
        return this._editor.isTopLevelEditor();
    }

    private TreeNode getSelectedNode() {
        if (this._editor != null) {
            return this._editor.getSelectedNode();
        }
        return null;
    }

    private void setSelectedNode(TreeNode treeNode) {
        if (this._editor != null) {
            this._editor.setSelectedNode(treeNode);
        }
    }

    public void release() {
        if (this._messageTablePanel != null) {
            this._messageTablePanel.removeAll();
        }
        if (this._messageTable != null) {
            this._messageTable.release();
            this._messageTable = null;
        }
        if (this._statusBar != null) {
            this._statusBar.release();
            this._statusBar = null;
        }
        this._DOM = null;
        this._editor = null;
        this._lastViewHolder = null;
        this._keyboardFocusManager.removeKeyEventDispatcher(this._keyEventDispatcher);
    }

    public void removeCancelButton() {
        if (this._eastPanel != null && this._cancelButton != null) {
            this._eastPanel.remove(this._cancelButton);
        }
    }

    public void removeSaveButton() {
        if (this._westPanel != null && this._saveButton != null) {
            this._westPanel.remove(this._saveButton);
        }
    }

    public Visualizer visualize(Type type) {
        return this.visualize(type, false);
    }

    public Visualizer visualize(Type type, boolean readOnly) {
        return this.visualize(type, null, readOnly);
    }

    public Visualizer visualize(Type type, Type context, boolean readOnly) {
        Visualizer visualizer = null;
        if (type != null) {
            if (readOnly) {
                type.getXUIDefinition().getStyle().setEnabled(false);
            }
            visualizer = TypeVisualizerFactory.getInstance().getVisualizer(type, context, true);
            this.visualize((JComponent)visualizer);
        } else {
            this.clearWorkbench();
        }
        return visualizer;
    }

    public void clearWorkbench() {
        this._centerPanel.removeAll();
    }

    public void visualize(JComponent component) {
        this.clearWorkbench();
        this._centerPanel.add((Component)component, "Center");
        this.updateUI();
    }

    private Type getRepresentedTabHolder(Type tabbedType) {
        Type parent;
        if (tabbedType != null && tabbedType.getParent() != null && (parent = tabbedType.getParent()).getXUIDefinition().getStyle().isTabHolder()) {
            JComponent currentTabHolder = (JComponent)TypeVisualizerFactory.getInstance().getVisualizer(parent);
            JComponent currentTabVisualizer = (JComponent)TypeVisualizerFactory.getInstance().getVisualizer(tabbedType);
            if (parent instanceof SimpleGroup) {
                ((TabbableView)currentTabHolder).showTab(tabbedType, (Object)currentTabVisualizer);
            } else if (parent instanceof ComplexGroup) {
                ((TabbableView)currentTabHolder).showTab(tabbedType, (Object)currentTabVisualizer);
            }
            if (parent.isRepresentedAsTab()) {
                return this.getRepresentedTabHolder(parent);
            }
            if (parent.getRepresentedTreeNodeParent() != null) {
                return parent.getRepresentedTreeNodeParent();
            }
        }
        return tabbedType;
    }

    private Visualizer getViewHolder(Type smartType) {
        Type currentSelectedType;
        Visualizer view;
        Visualizer viewHolder = null;
        if (smartType != null) {
            if (smartType.getXUIDefinition().getStyle().isParentViewHolder()) {
                if (smartType.isRepresentedAsTab()) {
                    Type representedTabHolder = this.getRepresentedTabHolder(smartType);
                    viewHolder = representedTabHolder == smartType ? TypeVisualizerFactory.getInstance().getVisualizer(smartType) : this.getViewHolder(representedTabHolder);
                    if (smartType.getParent() != null && smartType.getParentList() != null) {
                        if (smartType instanceof ComplexGroup) {
                            ((ListVisualizer)TypeVisualizerFactory.getInstance().getVisualizer((Type)smartType.getParentList())).selectType(smartType);
                        } else if (smartType instanceof SimpleType) {
                            ((AbstractSimpleTypeView)TypeVisualizerFactory.getInstance().getVisualizer(smartType)).grabFocus();
                        }
                    }
                } else if (smartType.getParent() != null && smartType.getParent().getXUIDefinition().getStyle().isUsingTabList()) {
                    view = TypeVisualizerFactory.getInstance().getVisualizer(smartType.getParent());
                    if (view instanceof ListVisualizer) {
                        ((ListVisualizer)view).selectType(smartType);
                    }
                    this.getViewHolder(smartType.getParent());
                } else if (smartType.isRepresentedAsHeader()) {
                    Type parent;
                    if (smartType.getParent() != null && (parent = smartType.getParent()).getRepresentedTreeNodeParent() != null) {
                        viewHolder = this.getViewHolder(parent);
                    }
                } else {
                    viewHolder = this.checkTableLayoutParentVisualizer(smartType, null);
                }
                if (viewHolder == null) {
                    viewHolder = smartType.getParent() != null ? this.getViewHolder(smartType.getParent()) : TypeVisualizerFactory.getInstance().getVisualizer(smartType);
                }
            } else if (!smartType.getXUIDefinition().getStyle().isParentViewHolder()) {
                viewHolder = TypeVisualizerFactory.getInstance().getVisualizer(smartType);
            }
        }
        if (smartType.isComposite() && smartType.getParent() != null && smartType instanceof CompositeType && smartType.getParent() instanceof ListType) {
            view = TypeVisualizerFactory.getInstance().getVisualizer(smartType.getParent());
            if (view instanceof ListVisualizer) {
                ((ListVisualizer)view).selectType(smartType);
            }
        } else if (smartType.isList() && smartType instanceof ComplexGroupList && (view = TypeVisualizerFactory.getInstance().getVisualizer(smartType)) instanceof ListVisualizer && (currentSelectedType = ((ListVisualizer)view).getSelectedType()) != null && !currentSelectedType.getXUIDefinition().getStyle().isSelfViewHolder()) {
            ((ListVisualizer)view).showModel(currentSelectedType);
        }
        return viewHolder;
    }

    private Visualizer getViewHolder2(Type smartType) {
        Type currentSelectedType;
        Visualizer view;
        Visualizer viewHolder = null;
        if (smartType != null) {
            if (smartType.getXUIDefinition().getStyle().isParentViewHolder()) {
                if (smartType.isRepresentedAsTab()) {
                    Type representedTabHolder = this.getRepresentedTabHolder(smartType);
                    viewHolder = representedTabHolder == smartType ? TypeVisualizerFactory.getInstance().getVisualizer(smartType) : this.getViewHolder2(representedTabHolder);
                    if (smartType.getParent() != null && smartType.getParentList() != null) {
                        if (smartType instanceof ComplexGroup) {
                            ((ListVisualizer)TypeVisualizerFactory.getInstance().getVisualizer((Type)smartType.getParentList())).selectType(smartType);
                        } else if (smartType instanceof SimpleType) {
                            ((AbstractSimpleTypeView)TypeVisualizerFactory.getInstance().getVisualizer(smartType)).grabFocus();
                        }
                    }
                } else if (smartType.getParent() != null && smartType.getParent().getXUIDefinition().getStyle().isUsingTabList()) {
                    view = TypeVisualizerFactory.getInstance().getVisualizer(smartType.getParent());
                    if (view instanceof ListVisualizer) {
                        ((ListVisualizer)view).selectType(smartType);
                    }
                    this.getViewHolder2(smartType.getParent());
                } else if (smartType.isRepresentedAsHeader()) {
                    Type parent;
                    if (smartType.getParent() != null && (parent = smartType.getParent()).getRepresentedTreeNodeParent() != null) {
                        viewHolder = this.getViewHolder2(parent);
                    }
                } else {
                    viewHolder = this.checkTableLayoutParentVisualizer(smartType, null);
                }
                if (viewHolder == null) {
                    viewHolder = smartType.getParent() != null ? this.getViewHolder2(smartType.getParent()) : TypeVisualizerFactory.getInstance().getVisualizer(smartType);
                }
            } else if (!smartType.getXUIDefinition().getStyle().isParentViewHolder()) {
                viewHolder = TypeVisualizerFactory.getInstance().getVisualizer(smartType);
            }
        }
        if (smartType.isComposite() && smartType.getParent() != null && smartType instanceof CompositeType && smartType.getParent() instanceof ListType) {
            view = TypeVisualizerFactory.getInstance().getVisualizer(smartType.getParent());
            if (view instanceof ListVisualizer) {
                ((ListVisualizer)view).selectType(smartType);
            }
        } else if (smartType.isList() && smartType instanceof ComplexGroupList && (view = TypeVisualizerFactory.getInstance().getVisualizer(smartType)) instanceof ListVisualizer && (currentSelectedType = ((ListVisualizer)view).getSelectedType()) != null && !currentSelectedType.getXUIDefinition().getStyle().isSelfViewHolder()) {
            ((ListVisualizer)view).showModel(currentSelectedType);
        }
        return viewHolder;
    }

    public Visualizer visualize(TreeNode node) {
        return this.visualize(node, false);
    }

    public Visualizer visualize(TreeNode node, boolean forceRepaint) {
        Type smartType = node.getType();
        this.setSelectedNode(node);
        Visualizer visualizer = TypeVisualizerFactory.getInstance().getVisualizer(smartType);
        Visualizer viewHolder = null;
        viewHolder = smartType.isRepresentedAsTreeNode() && smartType.getXUIDefinition().getStyle().isSelfViewHolder() ? visualizer : this.getViewHolder(smartType);
        if (forceRepaint || this._lastViewHolder != viewHolder) {
            String url;
            this._lastViewHolder = viewHolder;
            this.setLastVisualizedType(viewHolder.getModel());
            this.clearWorkbench();
            this.removeHeader();
            Type treeHolder = smartType.getRepresentedTreeNodeHolder();
            if (treeHolder != null && (url = treeHolder.getXUIDefinition().getStyle().getHeaderImageURL()) != null && url.length() > 0) {
                this.addHeader(url);
            }
            int topIndent = this.getDOM().getGlobalDefinition().getGlobalTopIndent();
            int bottomIndent = this.getDOM().getGlobalDefinition().getGlobalBottomIndent();
            int leftIndent = this.getDOM().getGlobalDefinition().getGlobalLeftIndent();
            int rightIndent = this.getDOM().getGlobalDefinition().getGlobalRightIndent();
            this._innerCenterPanel = (JPanel)GUITools.createIndentedComponent((JComponent)viewHolder, topIndent, bottomIndent, leftIndent, rightIndent);
            this._innerCenterPanel.setFocusable(false);
            this._centerPanel.add((Component)this._innerCenterPanel, "Center");
            this._centerPanel.repaint();
            this._centerPanel.validate();
            this._scrollPane.revalidate();
        }
        if (viewHolder == visualizer || ((JComponent)visualizer).isVisible()) {
            // empty if block
        }
        this.updateUI();
        return visualizer;
    }

    private void focusFirstEditingComponent(Type type) {
        if (this._DOM == null) {
            return;
        }
        AbstractView view = null;
        if (type != null) {
            if (type.isComposite() && !type.isChoice()) {
                Type firstChild;
                if (type.getXUIDefinition().getStyle().getLayoutManager("main") != null) {
                    AbstractView tableLayoutView = (AbstractView)TypeVisualizerFactory.getInstance().getVisualizer(type);
                    if (tableLayoutView != null) {
                        tableLayoutView.transferFocus();
                    }
                } else if (((CompositeType)type).getComposites().size() > 0 && (firstChild = (Type)((CompositeType)type).getComposites().get(0)) != null) {
                    this.focusFirstEditingComponent(firstChild);
                }
            } else {
                AbstractView aView = (AbstractView)TypeVisualizerFactory.getInstance().getVisualizer(type);
                if (aView != null && aView.isVisible() && aView.getFirstFocusableComponent() != null) {
                    view = aView;
                }
            }
        }
        if (view != null) {
            view.focusFirstComponent(false);
        }
    }

    private Visualizer checkTableLayoutParentVisualizer(Type type, Type selection) {
        Type treeParent;
        Type tableParent = type.getRepresentedTableLayoutParent();
        if (tableParent != null && tableParent.getParent() != null && (treeParent = tableParent.getParent().getRepresentedTreeNodeParent()) != null) {
            if (selection == null) {
                selection = type;
            }
            this.select(selection, treeParent);
            return TypeVisualizerFactory.getInstance().getVisualizer(treeParent);
        }
        if (type.getParent() != null && type.getParent().isList()) {
            this.select(type, type.getParent());
        }
        return null;
    }

    private void select(Type selection, Type parent) {
        int index;
        if (parent.isList() && selection.isDerivedFrom(parent) && (index = ((ListType)parent).getList().indexOf(selection)) > -1) {
            Visualizer visualizer = TypeVisualizerFactory.getInstance().getVisualizer(parent);
            if (visualizer instanceof ComplexGroupListView) {
                ((ComplexGroupListView)visualizer).selectType(selection);
            } else if (visualizer instanceof SimpleGroupListView) {
                ((SimpleGroupListView)visualizer).selectType(selection);
            }
        }
        Iterator iterator = null;
        if (parent.isComposite()) {
            iterator = ((CompositeType)parent).getComposites().iterator();
        } else if (parent.isList()) {
            iterator = ((ListType)parent).getList().iterator();
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                Visualizer visualizer;
                int index2;
                Type childType = (Type)iterator.next();
                if (!selection.isDerivedFrom(childType)) continue;
                if (parent.isList() && (index2 = ((ListType)parent).getList().indexOf(childType)) > -1 && (visualizer = TypeVisualizerFactory.getInstance().getVisualizer(parent)) instanceof ComplexGroupListView) {
                    ((ComplexGroupListView)visualizer).selectType(childType);
                }
                this.select(selection, childType);
            }
        }
    }

    public void visualizeNextNode() {
        if (this.getSelectedNode() != null) {
            TreeNode selectedNode = this.getSelectedNode();
            TreeNode nextNode = (TreeNode)selectedNode.getNextNode();
            if (nextNode == null) {
                nextNode = (TreeNode)selectedNode.getRoot();
            }
            boolean isFocusable = false;
            while (nextNode != null && nextNode != selectedNode && !isFocusable) {
                Type type = nextNode.getType();
                if (type == null) continue;
                isFocusable = type.getXUIDefinition().getStyle().isTreeEntryFocusable();
                if (!isFocusable) {
                    nextNode = (TreeNode)nextNode.getNextNode();
                }
                if (nextNode != null) continue;
                nextNode = (TreeNode)selectedNode.getRoot();
            }
            if (isFocusable) {
                this.visualize(nextNode);
                this._editor.selectNode(nextNode);
            }
        }
    }

    public void visualizePreviousNode() {
        if (this.getSelectedNode() != null) {
            TreeNode selectedNode = this.getSelectedNode();
            TreeNode previousNode = (TreeNode)selectedNode.getPreviousNode();
            if (previousNode == null) {
                previousNode = (TreeNode)selectedNode.getLastLeaf();
            }
            boolean isFocusable = false;
            while (previousNode != null && previousNode != selectedNode && !isFocusable) {
                Type type = previousNode.getType();
                if (type == null) continue;
                isFocusable = type.getXUIDefinition().getStyle().isTreeEntryFocusable();
                if (!isFocusable) {
                    previousNode = (TreeNode)previousNode.getPreviousNode();
                }
                if (previousNode != null) continue;
                previousNode = (TreeNode)((TreeNode)selectedNode.getRoot()).getLastLeaf();
            }
            if (isFocusable) {
                this.visualize(previousNode);
                this._editor.selectNode(previousNode);
            }
        }
    }

    public ErrorMessageStatusBar getStatusBar() {
        if (this._statusBar != null) {
            return this._statusBar;
        }
        return null;
    }

    public MessageTable getMessageTable() {
        return this._messageTable;
    }

    public JComponent getMessageTablePanel() {
        if (this._messageTablePanel == null) {
            this._messageTablePanel = new JPanel();
            this._messageTablePanel.setFocusable(false);
            this._messageTablePanel.setLayout(new BorderLayout());
            this._messageTable = new MessageTable(this, this._editor);
            JScrollPane scrollPane = new JScrollPane(this._messageTable);
            scrollPane.setFocusable(false);
            scrollPane.getViewport().setFocusable(false);
            scrollPane.getVerticalScrollBar().setFocusable(false);
            scrollPane.getHorizontalScrollBar().setFocusable(false);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(30);
            this._messageTablePanel.add((Component)scrollPane, "Center");
        }
        return this._messageTablePanel;
    }

    public JPanel getCenterPanel() {
        return this._centerPanel;
    }

    public JPanel getButtonBar() {
        return this._buttonPanel;
    }

    private KeyEventDispatcher getKeyEventDispatcher() {
        if (this._keyEventDispatcher == null) {
            this._keyEventDispatcher = new KeyEventDispatcher(){

                public boolean dispatchKeyEvent(KeyEvent e) {
                    Component aComponent;
                    boolean discardEvent = false;
                    if (TypeWorkspace.this._editor.isShowing() && e.getSource() instanceof Component && SwingUtilities.getRoot(aComponent = (Component)e.getSource()) == SwingUtilities.getRoot(TypeWorkspace.this) && e.getID() == 401) {
                        switch (e.getKeyCode()) {
                            case 118: {
                                TypeWorkspace.this.visualizePreviousNode();
                                break;
                            }
                            case 119: {
                                TypeWorkspace.this.visualizeNextNode();
                                break;
                            }
                            case 40: {
                                TypeWorkspace.this.visualizeNextNode();
                                break;
                            }
                            case 38: {
                                TypeWorkspace.this.visualizePreviousNode();
                                break;
                            }
                            case 79: {
                                if (!e.isAltDown() || !e.isShiftDown() || !e.isControlDown() || TypeWorkspace.this._centerPanel == null || TypeWorkspace.this.getDOM().isXUIDOMInstance()) break;
                                UITree uiTree = new UITree(TypeWorkspace.this._centerPanel);
                                JScrollPane scroll = new JScrollPane(uiTree);
                                uiTree.setBorderActionRootComponent(scroll);
                                JDialog f = new JDialog((Frame)SwingUtilities.getRoot(TypeWorkspace.this._centerPanel));
                                f.getContentPane().add(scroll);
                                f.setSize(300, 300);
                                f.setVisible(true);
                                break;
                            }
                        }
                    }
                    return discardEvent;
                }
            };
        }
        return this._keyEventDispatcher;
    }

    private void addHeader(String imageURL) {
        this._headerLabel = new JLabel(JAXFrontProperties.getImageIcon((URL)this.getDOM().getFingerPrint().getXUIURL(), (String)imageURL));
        this._headerLabel.setHorizontalAlignment(2);
        this._headerLabel.setBorder(null);
        this._headerLabel.setFocusable(false);
        this._headerPanel.add((Component)this._headerLabel, "Center");
        this._headerPanel.updateUI();
    }

    private void removeHeader() {
        if (this._headerPanel != null) {
            this._headerPanel.removeAll();
            this.updateUI();
        }
    }

    public JPanel getHeaderPanel() {
        if (this._headerPanel == null) {
            this._headerPanel = new JPanel(new BorderLayout());
        }
        return this._headerPanel;
    }

    public void showBannerPanel(JPanel component) {
        this.clearWorkbench();
        this._centerPanel.add((Component)component, "Center");
        this.updateUI();
    }

    public JButton getSaveButton() {
        return this._saveButton;
    }

    public JButton getCancelButton() {
        return this._cancelButton;
    }

    public void validationChanged(ValidationChangeEvent event) {
        if (event.isOccuring() && event.getError().isShowingDialog()) {
            JOptionPane.showMessageDialog(this, event.getError().getMessageText(), "", 1, event.getError().getMessageIcon());
        }
    }

    public Type getLastVisualizedType() {
        return this._lastVisualizedType;
    }

    public void setLastVisualizedType(Type lastVisualizedType) {
        this._lastVisualizedType = lastVisualizedType;
    }

    public Visualizer getLastViewHolder() {
        return this._lastViewHolder;
    }
}

